/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.complexscripts.fonts;

import java.nio.IntBuffer;
import java.util.ArrayList;
import org.apache.fop.complexscripts.fonts.GlyphDefinitionTable;
import org.apache.fop.complexscripts.fonts.GlyphSubtable;
import org.apache.fop.complexscripts.util.GlyphContextTester;
import org.apache.fop.complexscripts.util.GlyphSequence;
import org.apache.fop.complexscripts.util.GlyphTester;
import org.apache.fop.complexscripts.util.ScriptContextTester;

public class GlyphProcessingState {
    protected GlyphDefinitionTable gdef;
    protected String script;
    protected String language;
    protected String feature;
    protected GlyphSequence igs;
    protected int index;
    protected int indexLast;
    protected int consumed;
    protected int lookupFlags;
    protected int classMatchSet;
    protected ScriptContextTester sct;
    protected GlyphContextTester gct;
    protected GlyphTester ignoreBase;
    protected GlyphTester ignoreLigature;
    protected GlyphTester ignoreMark;
    protected GlyphTester ignoreDefault;

    protected GlyphProcessingState(GlyphSequence glyphSequence, String string, String string2, String string3, ScriptContextTester scriptContextTester) {
        this.script = string;
        this.language = string2;
        this.feature = string3;
        this.igs = glyphSequence;
        this.indexLast = glyphSequence.getGlyphCount();
        this.sct = scriptContextTester;
        this.gct = scriptContextTester != null ? scriptContextTester.getTester(string3) : null;
        this.ignoreBase = new GlyphTester(){

            public boolean test(int n, int n2) {
                return GlyphProcessingState.this.isIgnoredBase(n, n2);
            }
        };
        this.ignoreLigature = new GlyphTester(){

            public boolean test(int n, int n2) {
                return GlyphProcessingState.this.isIgnoredLigature(n, n2);
            }
        };
        this.ignoreMark = new GlyphTester(){

            public boolean test(int n, int n2) {
                return GlyphProcessingState.this.isIgnoredMark(n, n2);
            }
        };
    }

    protected GlyphProcessingState(GlyphProcessingState glyphProcessingState) {
        this(new GlyphSequence(glyphProcessingState.igs), glyphProcessingState.script, glyphProcessingState.language, glyphProcessingState.feature, glyphProcessingState.sct);
        this.setPosition(glyphProcessingState.index);
    }

    public void setGDEF(GlyphDefinitionTable glyphDefinitionTable) {
        if (this.gdef == null) {
            this.gdef = glyphDefinitionTable;
        } else if (glyphDefinitionTable == null) {
            this.gdef = null;
        }
    }

    public GlyphDefinitionTable getGDEF() {
        return this.gdef;
    }

    public void setLookupFlags(int n) {
        if (this.lookupFlags == 0) {
            this.lookupFlags = n;
        } else if (n == 0) {
            this.lookupFlags = 0;
        }
    }

    public int getLookupFlags() {
        return this.lookupFlags;
    }

    public int getClassMatchSet(int n) {
        return 0;
    }

    public void setIgnoreDefault(GlyphTester glyphTester) {
        if (this.ignoreDefault == null) {
            this.ignoreDefault = glyphTester;
        } else if (glyphTester == null) {
            this.ignoreDefault = null;
        }
    }

    public GlyphTester getIgnoreDefault() {
        return this.ignoreDefault;
    }

    public void updateSubtableState(GlyphSubtable glyphSubtable) {
        this.setGDEF(glyphSubtable.getGDEF());
        this.setLookupFlags(glyphSubtable.getFlags());
        this.setIgnoreDefault(this.getIgnoreTester(this.getLookupFlags()));
    }

    public void resetSubtableState() {
        this.setGDEF(null);
        this.setLookupFlags(0);
        this.setIgnoreDefault(null);
    }

    public int getPosition() {
        return this.index;
    }

    public void setPosition(int n) throws IndexOutOfBoundsException {
        if (n < 0 || n > this.indexLast) {
            throw new IndexOutOfBoundsException();
        }
        this.index = n;
    }

    public int getLastPosition() {
        return this.indexLast;
    }

    public boolean hasNext() {
        return this.hasNext(1);
    }

    public boolean hasNext(int n) {
        return this.index + n <= this.indexLast;
    }

    public int next() {
        if (this.index < this.indexLast) {
            if (this.consumed == 0) {
                this.consumed = 1;
            }
            this.index += this.consumed;
            this.consumed = 0;
            if (this.index > this.indexLast) {
                this.index = this.indexLast;
            }
        }
        return this.index;
    }

    public boolean hasPrev() {
        return this.hasPrev(1);
    }

    public boolean hasPrev(int n) {
        return this.index - n >= 0;
    }

    public int prev() {
        if (this.index > 0) {
            if (this.consumed == 0) {
                this.consumed = 1;
            }
            this.index -= this.consumed;
            this.consumed = 0;
            if (this.index < 0) {
                this.index = 0;
            }
        }
        return this.index;
    }

    public int consume(int n) throws IndexOutOfBoundsException {
        if (this.consumed + n <= this.indexLast) {
            this.consumed += n;
            return this.consumed;
        }
        throw new IndexOutOfBoundsException();
    }

    public boolean didConsume() {
        return this.consumed > 0;
    }

    public GlyphSequence getInput() {
        return this.igs;
    }

    public int getGlyph(int n) throws IndexOutOfBoundsException {
        int n2 = this.index + n;
        if (n2 >= 0 && n2 < this.indexLast) {
            return this.igs.getGlyph(n2);
        }
        throw new IndexOutOfBoundsException("attempting index at " + n2);
    }

    public int getGlyph() throws IndexOutOfBoundsException {
        return this.getGlyph(0);
    }

    public void setGlyph(int n, int n2) throws IndexOutOfBoundsException {
        int n3 = this.index + n;
        if (n3 < 0 || n3 >= this.indexLast) {
            throw new IndexOutOfBoundsException("attempting index at " + n3);
        }
        this.igs.setGlyph(n3, n2);
    }

    public GlyphSequence.CharAssociation getAssociation(int n) throws IndexOutOfBoundsException {
        int n2 = this.index + n;
        if (n2 >= 0 && n2 < this.indexLast) {
            return this.igs.getAssociation(n2);
        }
        throw new IndexOutOfBoundsException("attempting index at " + n2);
    }

    public GlyphSequence.CharAssociation getAssociation() throws IndexOutOfBoundsException {
        return this.getAssociation(0);
    }

    public int[] getGlyphs(int n, int n2, boolean bl, GlyphTester glyphTester, int[] nArray, int[] nArray2) throws IndexOutOfBoundsException {
        int n3;
        if (n2 < 0) {
            n2 = this.getGlyphsAvailable(n, bl, glyphTester)[0];
        }
        if ((n3 = this.index + n) < 0) {
            throw new IndexOutOfBoundsException("will attempt index at " + n3);
        }
        if (!bl && n3 + n2 > this.indexLast) {
            throw new IndexOutOfBoundsException("will attempt index at " + (n3 + n2));
        }
        if (bl && n3 + 1 < n2) {
            throw new IndexOutOfBoundsException("will attempt index at " + (n3 - n2));
        }
        if (nArray == null) {
            nArray = new int[n2];
        } else if (nArray.length != n2) {
            throw new IllegalArgumentException("glyphs array is non-null, but its length (" + nArray.length + "), is not equal to count (" + n2 + ")");
        }
        if (!bl) {
            return this.getGlyphsForward(n3, n2, glyphTester, nArray, nArray2);
        }
        return this.getGlyphsReverse(n3, n2, glyphTester, nArray, nArray2);
    }

    private int[] getGlyphsForward(int n, int n2, GlyphTester glyphTester, int[] nArray, int[] nArray2) throws IndexOutOfBoundsException {
        int n3 = 0;
        int n4 = 0;
        int n5 = this.indexLast;
        int n6 = 0;
        for (int i = n; i < n5; ++i) {
            int n7 = this.getGlyph(i - this.index);
            if (n7 == 65535) {
                ++n4;
                continue;
            }
            if (glyphTester == null || !glyphTester.test(n7, this.getLookupFlags())) {
                if (n6 >= n2) break;
                nArray[n6++] = n7;
                ++n3;
                continue;
            }
            ++n4;
        }
        if (nArray2 != null && nArray2.length > 1) {
            nArray2[0] = n3;
            nArray2[1] = n4;
        }
        return nArray;
    }

    private int[] getGlyphsReverse(int n, int n2, GlyphTester glyphTester, int[] nArray, int[] nArray2) throws IndexOutOfBoundsException {
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        for (int i = n; i >= 0; --i) {
            int n6 = this.getGlyph(i - this.index);
            if (n6 == 65535) {
                ++n4;
                continue;
            }
            if (glyphTester == null || !glyphTester.test(n6, this.getLookupFlags())) {
                if (n5 >= n2) break;
                nArray[n5++] = n6;
                ++n3;
                continue;
            }
            ++n4;
        }
        if (nArray2 != null && nArray2.length > 1) {
            nArray2[0] = n3;
            nArray2[1] = n4;
        }
        return nArray;
    }

    public int[] getGlyphs(int n, int n2, int[] nArray, int[] nArray2) throws IndexOutOfBoundsException {
        return this.getGlyphs(n, n2, n < 0, this.ignoreDefault, nArray, nArray2);
    }

    public int[] getGlyphs() throws IndexOutOfBoundsException {
        return this.getGlyphs(0, this.indexLast - this.index, false, null, null, null);
    }

    public int[] getIgnoredGlyphs(int n, int n2, boolean bl, GlyphTester glyphTester, int[] nArray, int[] nArray2) throws IndexOutOfBoundsException {
        return this.getGlyphs(n, n2, bl, new NotGlyphTester(glyphTester), nArray, nArray2);
    }

    public int[] getIgnoredGlyphs(int n, int n2) throws IndexOutOfBoundsException {
        return this.getIgnoredGlyphs(n, n2, n < 0, this.ignoreDefault, null, null);
    }

    public int[] getGlyphsAvailable(int n, boolean bl, GlyphTester glyphTester) throws IndexOutOfBoundsException {
        int n2 = this.index + n;
        if (n2 < 0 || n2 > this.indexLast) {
            return new int[]{0, 0};
        }
        if (!bl) {
            return this.getGlyphsAvailableForward(n2, glyphTester);
        }
        return this.getGlyphsAvailableReverse(n2, glyphTester);
    }

    private int[] getGlyphsAvailableForward(int n, GlyphTester glyphTester) throws IndexOutOfBoundsException {
        int n2 = 0;
        int n3 = 0;
        if (glyphTester == null) {
            n2 = this.indexLast - n;
        } else {
            int n4 = this.indexLast;
            for (int i = n; i < n4; ++i) {
                int n5 = this.getGlyph(i - this.index);
                if (n5 == 65535) {
                    ++n3;
                    continue;
                }
                if (glyphTester.test(n5, this.getLookupFlags())) {
                    ++n3;
                    continue;
                }
                ++n2;
            }
        }
        return new int[]{n2, n3};
    }

    private int[] getGlyphsAvailableReverse(int n, GlyphTester glyphTester) throws IndexOutOfBoundsException {
        int n2 = 0;
        int n3 = 0;
        if (glyphTester == null) {
            n2 = n + 1;
        } else {
            for (int i = n; i >= 0; --i) {
                int n4 = this.getGlyph(i - this.index);
                if (n4 == 65535) {
                    ++n3;
                    continue;
                }
                if (glyphTester.test(n4, this.getLookupFlags())) {
                    ++n3;
                    continue;
                }
                ++n2;
            }
        }
        return new int[]{n2, n3};
    }

    public int[] getGlyphsAvailable(int n, boolean bl) throws IndexOutOfBoundsException {
        return this.getGlyphsAvailable(n, bl, this.ignoreDefault);
    }

    public int[] getGlyphsAvailable(int n) throws IndexOutOfBoundsException {
        return this.getGlyphsAvailable(n, n < 0);
    }

    public GlyphSequence.CharAssociation[] getAssociations(int n, int n2, boolean bl, GlyphTester glyphTester, GlyphSequence.CharAssociation[] charAssociationArray, int[] nArray) throws IndexOutOfBoundsException {
        int n3;
        if (n2 < 0) {
            n2 = this.getGlyphsAvailable(n, bl, glyphTester)[0];
        }
        if ((n3 = this.index + n) < 0) {
            throw new IndexOutOfBoundsException("will attempt index at " + n3);
        }
        if (!bl && n3 + n2 > this.indexLast) {
            throw new IndexOutOfBoundsException("will attempt index at " + (n3 + n2));
        }
        if (bl && n3 + 1 < n2) {
            throw new IndexOutOfBoundsException("will attempt index at " + (n3 - n2));
        }
        if (charAssociationArray == null) {
            charAssociationArray = new GlyphSequence.CharAssociation[n2];
        } else if (charAssociationArray.length != n2) {
            throw new IllegalArgumentException("associations array is non-null, but its length (" + charAssociationArray.length + "), is not equal to count (" + n2 + ")");
        }
        if (!bl) {
            return this.getAssociationsForward(n3, n2, glyphTester, charAssociationArray, nArray);
        }
        return this.getAssociationsReverse(n3, n2, glyphTester, charAssociationArray, nArray);
    }

    private GlyphSequence.CharAssociation[] getAssociationsForward(int n, int n2, GlyphTester glyphTester, GlyphSequence.CharAssociation[] charAssociationArray, int[] nArray) throws IndexOutOfBoundsException {
        int n3 = 0;
        int n4 = 0;
        int n5 = this.indexLast;
        int n6 = 0;
        for (int i = n; i < n5; ++i) {
            int n7 = this.getGlyph(i - this.index);
            if (n7 == 65535) {
                ++n4;
                continue;
            }
            if (glyphTester == null || !glyphTester.test(n7, this.getLookupFlags())) {
                if (n6 >= n2) break;
                charAssociationArray[n6++] = this.getAssociation(i - this.index);
                ++n3;
                continue;
            }
            ++n4;
        }
        if (nArray != null && nArray.length > 1) {
            nArray[0] = n3;
            nArray[1] = n4;
        }
        return charAssociationArray;
    }

    private GlyphSequence.CharAssociation[] getAssociationsReverse(int n, int n2, GlyphTester glyphTester, GlyphSequence.CharAssociation[] charAssociationArray, int[] nArray) throws IndexOutOfBoundsException {
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        for (int i = n; i >= 0; --i) {
            int n6 = this.getGlyph(i - this.index);
            if (n6 == 65535) {
                ++n4;
                continue;
            }
            if (glyphTester == null || !glyphTester.test(n6, this.getLookupFlags())) {
                if (n5 >= n2) break;
                charAssociationArray[n5++] = this.getAssociation(i - this.index);
                ++n3;
                continue;
            }
            ++n4;
        }
        if (nArray != null && nArray.length > 1) {
            nArray[0] = n3;
            nArray[1] = n4;
        }
        return charAssociationArray;
    }

    public GlyphSequence.CharAssociation[] getAssociations(int n, int n2) throws IndexOutOfBoundsException {
        return this.getAssociations(n, n2, n < 0, this.ignoreDefault, null, null);
    }

    public GlyphSequence.CharAssociation[] getIgnoredAssociations(int n, int n2, boolean bl, GlyphTester glyphTester, GlyphSequence.CharAssociation[] charAssociationArray, int[] nArray) throws IndexOutOfBoundsException {
        return this.getAssociations(n, n2, bl, new NotGlyphTester(glyphTester), charAssociationArray, nArray);
    }

    public GlyphSequence.CharAssociation[] getIgnoredAssociations(int n, int n2) throws IndexOutOfBoundsException {
        return this.getIgnoredAssociations(n, n2, n < 0, this.ignoreDefault, null, null);
    }

    public boolean replaceInput(int n, int n2, GlyphSequence glyphSequence, int n3, int n4) throws IndexOutOfBoundsException {
        int n5;
        int n6;
        int n7 = this.igs != null ? this.igs.getGlyphCount() : 0;
        int n8 = this.getPosition() + n;
        if (n8 < 0) {
            n8 = 0;
        } else if (n8 > n7) {
            n8 = n7;
        }
        if (n2 < 0 || n8 + n2 > n7) {
            n2 = n7 - n8;
        }
        int n9 = n6 = glyphSequence != null ? glyphSequence.getGlyphCount() : 0;
        if (n3 < 0) {
            n3 = 0;
        } else if (n3 > n6) {
            n3 = n6;
        }
        if (n4 < 0 || n3 + n4 > n6) {
            n4 = n6 - n3;
        }
        int n10 = n7 + n4 - n2;
        IntBuffer intBuffer = IntBuffer.allocate(n10);
        ArrayList<GlyphSequence.CharAssociation> arrayList = new ArrayList<GlyphSequence.CharAssociation>(n10);
        int n11 = n8;
        for (n5 = 0; n5 < n11; ++n5) {
            intBuffer.put(this.igs.getGlyph(n5));
            arrayList.add(this.igs.getAssociation(n5));
        }
        n11 = n3 + n4;
        for (n5 = n3; n5 < n11; ++n5) {
            intBuffer.put(glyphSequence.getGlyph(n5));
            arrayList.add(glyphSequence.getAssociation(n5));
        }
        n11 = n7;
        for (n5 = n8 + n2; n5 < n11; ++n5) {
            intBuffer.put(this.igs.getGlyph(n5));
            arrayList.add(this.igs.getAssociation(n5));
        }
        intBuffer.flip();
        if (this.igs.compareGlyphs(intBuffer) != 0) {
            this.igs = new GlyphSequence(this.igs.getCharacters(), intBuffer, arrayList);
            this.indexLast = intBuffer.limit();
            return true;
        }
        return false;
    }

    public boolean replaceInput(int n, int n2, GlyphSequence glyphSequence) throws IndexOutOfBoundsException {
        return this.replaceInput(n, n2, glyphSequence, 0, glyphSequence.getGlyphCount());
    }

    public int erase(int n, int[] nArray) throws IndexOutOfBoundsException {
        int n2 = this.index + n;
        if (n2 < 0 || n2 > this.indexLast) {
            throw new IndexOutOfBoundsException("will attempt index at " + n2);
        }
        int n3 = 0;
        int n4 = this.indexLast - n2;
        for (int i = n2 - this.index; i < n4; ++i) {
            int n5 = this.getGlyph(i);
            if (n5 != nArray[n3]) continue;
            this.setGlyph(i, 65535);
            ++n3;
        }
        return n3;
    }

    public boolean maybeApplicable() {
        if (this.gct == null) {
            return true;
        }
        return this.gct.test(this.script, this.language, this.feature, this.igs, this.index, this.getLookupFlags());
    }

    public void applyDefault() {
        ++this.consumed;
    }

    public boolean isBase(int n) {
        if (this.gdef != null) {
            return this.gdef.isGlyphClass(n, 1);
        }
        return false;
    }

    public boolean isIgnoredBase(int n, int n2) {
        return (n2 & 2) != 0 && this.isBase(n);
    }

    public boolean isLigature(int n) {
        if (this.gdef != null) {
            return this.gdef.isGlyphClass(n, 2);
        }
        return false;
    }

    public boolean isIgnoredLigature(int n, int n2) {
        return (n2 & 4) != 0 && this.isLigature(n);
    }

    public boolean isMark(int n) {
        if (this.gdef != null) {
            return this.gdef.isGlyphClass(n, 3);
        }
        return false;
    }

    public boolean isIgnoredMark(int n, int n2) {
        if ((n2 & 8) != 0) {
            return this.isMark(n);
        }
        if ((n2 & 0xFF00) != 0) {
            int n3 = (n2 & 0xFF00) >> 8;
            int n4 = this.gdef.getMarkAttachClass(n);
            return n4 != n3;
        }
        return false;
    }

    public GlyphTester getIgnoreTester(int n) {
        if ((n & 2) != 0) {
            if ((n & 0xC) == 0) {
                return this.ignoreBase;
            }
            return this.getCombinedIgnoreTester(n);
        }
        if ((n & 4) != 0) {
            if ((n & 0xA) == 0) {
                return this.ignoreLigature;
            }
            return this.getCombinedIgnoreTester(n);
        }
        if ((n & 8) != 0) {
            if ((n & 6) == 0) {
                return this.ignoreMark;
            }
            return this.getCombinedIgnoreTester(n);
        }
        return null;
    }

    public GlyphTester getCombinedIgnoreTester(int n) {
        GlyphTester[] glyphTesterArray = new GlyphTester[3];
        int n2 = 0;
        if ((n & 2) != 0) {
            glyphTesterArray[n2++] = this.ignoreBase;
        }
        if ((n & 4) != 0) {
            glyphTesterArray[n2++] = this.ignoreLigature;
        }
        if ((n & 8) != 0) {
            glyphTesterArray[n2++] = this.ignoreMark;
        }
        return this.getCombinedOrTester(glyphTesterArray, n2);
    }

    public GlyphTester getCombinedOrTester(GlyphTester[] glyphTesterArray, int n) {
        if (n > 0) {
            return new CombinedOrGlyphTester(glyphTesterArray, n);
        }
        return null;
    }

    public GlyphTester getCombinedAndTester(GlyphTester[] glyphTesterArray, int n) {
        if (n > 0) {
            return new CombinedAndGlyphTester(glyphTesterArray, n);
        }
        return null;
    }

    private static class NotGlyphTester
    implements GlyphTester {
        private GlyphTester gt;

        NotGlyphTester(GlyphTester glyphTester) {
            this.gt = glyphTester;
        }

        public boolean test(int n, int n2) {
            return this.gt == null || !this.gt.test(n, n2);
        }
    }

    private static class CombinedAndGlyphTester
    implements GlyphTester {
        private GlyphTester[] gta;
        private int ngt;

        CombinedAndGlyphTester(GlyphTester[] glyphTesterArray, int n) {
            this.gta = glyphTesterArray;
            this.ngt = n;
        }

        public boolean test(int n, int n2) {
            int n3 = this.ngt;
            for (int i = 0; i < n3; ++i) {
                GlyphTester glyphTester = this.gta[i];
                if (glyphTester == null || glyphTester.test(n, n2)) continue;
                return false;
            }
            return true;
        }
    }

    private static class CombinedOrGlyphTester
    implements GlyphTester {
        private GlyphTester[] gta;
        private int ngt;

        CombinedOrGlyphTester(GlyphTester[] glyphTesterArray, int n) {
            this.gta = glyphTesterArray;
            this.ngt = n;
        }

        public boolean test(int n, int n2) {
            int n3 = this.ngt;
            for (int i = 0; i < n3; ++i) {
                GlyphTester glyphTester = this.gta[i];
                if (glyphTester == null || !glyphTester.test(n, n2)) continue;
                return true;
            }
            return false;
        }
    }
}

