/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.complexscripts.util;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.fop.util.CharUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CharScript {
    public static final int SCRIPT_HEBREW = 125;
    public static final int SCRIPT_MONGOLIAN = 145;
    public static final int SCRIPT_ARABIC = 160;
    public static final int SCRIPT_GREEK = 200;
    public static final int SCRIPT_LATIN = 215;
    public static final int SCRIPT_CYRILLIC = 220;
    public static final int SCRIPT_GEORGIAN = 240;
    public static final int SCRIPT_BOPOMOFO = 285;
    public static final int SCRIPT_HANGUL = 286;
    public static final int SCRIPT_GURMUKHI = 310;
    public static final int SCRIPT_GURMUKHI_2 = 1310;
    public static final int SCRIPT_DEVANAGARI = 315;
    public static final int SCRIPT_DEVANAGARI_2 = 1315;
    public static final int SCRIPT_GUJARATI = 320;
    public static final int SCRIPT_GUJARATI_2 = 1320;
    public static final int SCRIPT_BENGALI = 326;
    public static final int SCRIPT_BENGALI_2 = 1326;
    public static final int SCRIPT_ORIYA = 327;
    public static final int SCRIPT_ORIYA_2 = 1327;
    public static final int SCRIPT_TIBETAN = 330;
    public static final int SCRIPT_TELUGU = 340;
    public static final int SCRIPT_TELUGU_2 = 1340;
    public static final int SCRIPT_KANNADA = 345;
    public static final int SCRIPT_KANNADA_2 = 1345;
    public static final int SCRIPT_TAMIL = 346;
    public static final int SCRIPT_TAMIL_2 = 1346;
    public static final int SCRIPT_MALAYALAM = 347;
    public static final int SCRIPT_MALAYALAM_2 = 1347;
    public static final int SCRIPT_SINHALESE = 348;
    public static final int SCRIPT_BURMESE = 350;
    public static final int SCRIPT_THAI = 352;
    public static final int SCRIPT_KHMER = 355;
    public static final int SCRIPT_LAO = 356;
    public static final int SCRIPT_HIRAGANA = 410;
    public static final int SCRIPT_ETHIOPIC = 430;
    public static final int SCRIPT_HAN = 500;
    public static final int SCRIPT_KATAKANA = 410;
    public static final int SCRIPT_MATH = 995;
    public static final int SCRIPT_SYMBOL = 996;
    public static final int SCRIPT_UNDETERMINED = 998;
    public static final int SCRIPT_UNCODED = 999;
    private static final boolean useV2Indic = true;
    private static Map<Integer, String> scriptTagsMap = null;
    private static Map<String, Integer> scriptCodeMap = null;

    private CharScript() {
    }

    public static boolean isPunctuation(int n) {
        if (n >= 33 && n <= 47) {
            return true;
        }
        if (n >= 58 && n <= 64) {
            return true;
        }
        if (n >= 95 && n <= 96) {
            return true;
        }
        if (n >= 126 && n <= 126) {
            return true;
        }
        if (n >= 126 && n <= 126) {
            return true;
        }
        if (n >= 161 && n <= 191) {
            return true;
        }
        if (n >= 215 && n <= 215) {
            return true;
        }
        if (n >= 247 && n <= 247) {
            return true;
        }
        return n >= 8192 && n <= 8303;
    }

    public static boolean isDigit(int n) {
        return n >= 48 && n <= 57;
    }

    public static boolean isHebrew(int n) {
        if (n >= 1424 && n <= 1535) {
            return true;
        }
        return n >= 64256 && n <= 64335;
    }

    public static boolean isMongolian(int n) {
        return n >= 6144 && n <= 6319;
    }

    public static boolean isArabic(int n) {
        if (n >= 1536 && n <= 1791) {
            return true;
        }
        if (n >= 1872 && n <= 1919) {
            return true;
        }
        if (n >= 64336 && n <= 65023) {
            return true;
        }
        return n >= 65136 && n <= 65279;
    }

    public static boolean isGreek(int n) {
        if (n >= 880 && n <= 1023) {
            return true;
        }
        return n >= 7936 && n <= 8191;
    }

    public static boolean isLatin(int n) {
        if (n >= 65 && n <= 90) {
            return true;
        }
        if (n >= 97 && n <= 122) {
            return true;
        }
        if (n >= 192 && n <= 214) {
            return true;
        }
        if (n >= 216 && n <= 223) {
            return true;
        }
        if (n >= 224 && n <= 246) {
            return true;
        }
        if (n >= 248 && n <= 255) {
            return true;
        }
        if (n >= 256 && n <= 383) {
            return true;
        }
        if (n >= 384 && n <= 591) {
            return true;
        }
        if (n >= 7680 && n <= 7935) {
            return true;
        }
        if (n >= 11360 && n <= 11391) {
            return true;
        }
        if (n >= 42784 && n <= 43007) {
            return true;
        }
        return n >= 64256 && n <= 64271;
    }

    public static boolean isCyrillic(int n) {
        if (n >= 1024 && n <= 1279) {
            return true;
        }
        if (n >= 1280 && n <= 1327) {
            return true;
        }
        if (n >= 11744 && n <= 11775) {
            return true;
        }
        return n >= 42560 && n <= 42655;
    }

    public static boolean isGeorgian(int n) {
        if (n >= 4256 && n <= 4351) {
            return true;
        }
        return n >= 11520 && n <= 11567;
    }

    public static boolean isHangul(int n) {
        if (n >= 4352 && n <= 4607) {
            return true;
        }
        if (n >= 12592 && n <= 12687) {
            return true;
        }
        if (n >= 43360 && n <= 43391) {
            return true;
        }
        if (n >= 44032 && n <= 55203) {
            return true;
        }
        return n >= 55216 && n <= 55295;
    }

    public static boolean isGurmukhi(int n) {
        return n >= 2560 && n <= 2687;
    }

    public static boolean isDevanagari(int n) {
        if (n >= 2304 && n <= 2431) {
            return true;
        }
        return n >= 43232 && n <= 43263;
    }

    public static boolean isGujarati(int n) {
        return n >= 2688 && n <= 2815;
    }

    public static boolean isBengali(int n) {
        return n >= 2432 && n <= 2559;
    }

    public static boolean isOriya(int n) {
        return n >= 2816 && n <= 2943;
    }

    public static boolean isTibetan(int n) {
        return n >= 3840 && n <= 4095;
    }

    public static boolean isTelugu(int n) {
        return n >= 3072 && n <= 3199;
    }

    public static boolean isKannada(int n) {
        return n >= 3072 && n <= 3199;
    }

    public static boolean isTamil(int n) {
        return n >= 2944 && n <= 3071;
    }

    public static boolean isMalayalam(int n) {
        return n >= 3328 && n <= 3455;
    }

    public static boolean isSinhalese(int n) {
        return n >= 3456 && n <= 3583;
    }

    public static boolean isBurmese(int n) {
        if (n >= 4096 && n <= 4255) {
            return true;
        }
        return n >= 43616 && n <= 43647;
    }

    public static boolean isThai(int n) {
        return n >= 3584 && n <= 3711;
    }

    public static boolean isKhmer(int n) {
        if (n >= 6016 && n <= 6143) {
            return true;
        }
        return n >= 6624 && n <= 6655;
    }

    public static boolean isLao(int n) {
        return n >= 3712 && n <= 3839;
    }

    public static boolean isEthiopic(int n) {
        if (n >= 4608 && n <= 4991) {
            return true;
        }
        if (n >= 4992 && n <= 5023) {
            return true;
        }
        if (n >= 11648 && n <= 11743) {
            return true;
        }
        return n >= 43776 && n <= 43823;
    }

    public static boolean isHan(int n) {
        if (n >= 13312 && n <= 19903) {
            return true;
        }
        if (n >= 19968 && n <= 40959) {
            return true;
        }
        if (n >= 63744 && n <= 64255) {
            return true;
        }
        if (n >= 131072 && n <= 173791) {
            return true;
        }
        if (n >= 173824 && n <= 177983) {
            return true;
        }
        return n >= 194560 && n <= 195103;
    }

    public static boolean isBopomofo(int n) {
        return n >= 12544 && n <= 12591;
    }

    public static boolean isHiragana(int n) {
        return n >= 12352 && n <= 12447;
    }

    public static boolean isKatakana(int n) {
        if (n >= 12448 && n <= 12543) {
            return true;
        }
        return n >= 12784 && n <= 12799;
    }

    public static int scriptOf(int n) {
        if (CharUtilities.isAnySpace(n)) {
            return 998;
        }
        if (CharScript.isPunctuation(n)) {
            return 998;
        }
        if (CharScript.isDigit(n)) {
            return 998;
        }
        if (CharScript.isLatin(n)) {
            return 215;
        }
        if (CharScript.isCyrillic(n)) {
            return 220;
        }
        if (CharScript.isGreek(n)) {
            return 200;
        }
        if (CharScript.isHan(n)) {
            return 500;
        }
        if (CharScript.isBopomofo(n)) {
            return 285;
        }
        if (CharScript.isKatakana(n)) {
            return 410;
        }
        if (CharScript.isHiragana(n)) {
            return 410;
        }
        if (CharScript.isHangul(n)) {
            return 286;
        }
        if (CharScript.isArabic(n)) {
            return 160;
        }
        if (CharScript.isHebrew(n)) {
            return 125;
        }
        if (CharScript.isMongolian(n)) {
            return 145;
        }
        if (CharScript.isGeorgian(n)) {
            return 240;
        }
        if (CharScript.isGurmukhi(n)) {
            return CharScript.useV2IndicRules(310);
        }
        if (CharScript.isDevanagari(n)) {
            return CharScript.useV2IndicRules(315);
        }
        if (CharScript.isGujarati(n)) {
            return CharScript.useV2IndicRules(320);
        }
        if (CharScript.isBengali(n)) {
            return CharScript.useV2IndicRules(326);
        }
        if (CharScript.isOriya(n)) {
            return CharScript.useV2IndicRules(327);
        }
        if (CharScript.isTibetan(n)) {
            return 330;
        }
        if (CharScript.isTelugu(n)) {
            return CharScript.useV2IndicRules(340);
        }
        if (CharScript.isKannada(n)) {
            return CharScript.useV2IndicRules(345);
        }
        if (CharScript.isTamil(n)) {
            return CharScript.useV2IndicRules(346);
        }
        if (CharScript.isMalayalam(n)) {
            return CharScript.useV2IndicRules(347);
        }
        if (CharScript.isSinhalese(n)) {
            return 348;
        }
        if (CharScript.isBurmese(n)) {
            return 350;
        }
        if (CharScript.isThai(n)) {
            return 352;
        }
        if (CharScript.isKhmer(n)) {
            return 355;
        }
        if (CharScript.isLao(n)) {
            return 356;
        }
        if (CharScript.isEthiopic(n)) {
            return 430;
        }
        return 998;
    }

    public static int useV2IndicRules(int n) {
        return n < 1000 ? n + 1000 : n;
    }

    public static int[] scriptsOf(CharSequence charSequence) {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        int n = charSequence.length();
        for (int i = 0; i < n; ++i) {
            hashSet.add(CharScript.scriptOf(charSequence.charAt(i)));
        }
        int[] nArray = new int[hashSet.size()];
        n = 0;
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            nArray[n++] = (Integer)iterator.next();
        }
        Arrays.sort(nArray);
        return nArray;
    }

    public static int dominantScript(CharSequence charSequence) {
        Integer n;
        int n2;
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        int n3 = charSequence.length();
        for (n2 = 0; n2 < n3; ++n2) {
            char c = charSequence.charAt(n2);
            int n4 = CharScript.scriptOf(c);
            n = n4;
            Integer n5 = (Integer)hashMap.get(n);
            if (n5 != null) {
                hashMap.put(n, n5 + 1);
                continue;
            }
            hashMap.put(n, 0);
        }
        n2 = -1;
        n3 = -1;
        block4: for (Map.Entry entry : hashMap.entrySet()) {
            n = (Integer)entry.getKey();
            int n6 = n;
            switch (n6) {
                case 998: 
                case 999: {
                    continue block4;
                }
            }
            Integer n7 = (Integer)entry.getValue();
            assert (n7 != null);
            int n8 = n7;
            if (n8 <= n3) continue;
            n3 = n8;
            n2 = n6;
        }
        if (n2 < 0) {
            n2 = 998;
        }
        return n2;
    }

    public static boolean isIndicScript(String string) {
        return CharScript.isIndicScript(CharScript.scriptCodeFromTag(string));
    }

    public static boolean isIndicScript(int n) {
        switch (n) {
            case 310: 
            case 315: 
            case 320: 
            case 326: 
            case 327: 
            case 340: 
            case 345: 
            case 346: 
            case 347: 
            case 350: 
            case 1310: 
            case 1315: 
            case 1320: 
            case 1326: 
            case 1327: 
            case 1340: 
            case 1345: 
            case 1346: 
            case 1347: {
                return true;
            }
        }
        return false;
    }

    public static String scriptTagFromCode(int n) {
        Map<Integer, String> map = CharScript.getScriptTagsMap();
        if (map != null) {
            String string = map.get(n);
            if (string != null) {
                return string;
            }
            return "";
        }
        return "";
    }

    public static int scriptCodeFromTag(String string) {
        Map<String, Integer> map = CharScript.getScriptCodeMap();
        if (map != null) {
            Integer n = map.get(string);
            if (n != null) {
                return n;
            }
            return 998;
        }
        return 998;
    }

    private static void putScriptTag(Map map, Map map2, int n, String string) {
        assert (string != null);
        assert (string.length() != 0);
        assert (n >= 0);
        assert (n < 2000);
        map.put(n, string);
        map2.put(string, n);
    }

    private static void makeScriptMaps() {
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        HashMap<String, Integer> hashMap2 = new HashMap<String, Integer>();
        CharScript.putScriptTag(hashMap, hashMap2, 125, "hebr");
        CharScript.putScriptTag(hashMap, hashMap2, 145, "mong");
        CharScript.putScriptTag(hashMap, hashMap2, 160, "arab");
        CharScript.putScriptTag(hashMap, hashMap2, 200, "grek");
        CharScript.putScriptTag(hashMap, hashMap2, 215, "latn");
        CharScript.putScriptTag(hashMap, hashMap2, 220, "cyrl");
        CharScript.putScriptTag(hashMap, hashMap2, 240, "geor");
        CharScript.putScriptTag(hashMap, hashMap2, 285, "bopo");
        CharScript.putScriptTag(hashMap, hashMap2, 286, "hang");
        CharScript.putScriptTag(hashMap, hashMap2, 310, "guru");
        CharScript.putScriptTag(hashMap, hashMap2, 1310, "gur2");
        CharScript.putScriptTag(hashMap, hashMap2, 315, "deva");
        CharScript.putScriptTag(hashMap, hashMap2, 1315, "dev2");
        CharScript.putScriptTag(hashMap, hashMap2, 320, "gujr");
        CharScript.putScriptTag(hashMap, hashMap2, 1320, "gjr2");
        CharScript.putScriptTag(hashMap, hashMap2, 326, "beng");
        CharScript.putScriptTag(hashMap, hashMap2, 1326, "bng2");
        CharScript.putScriptTag(hashMap, hashMap2, 327, "orya");
        CharScript.putScriptTag(hashMap, hashMap2, 1327, "ory2");
        CharScript.putScriptTag(hashMap, hashMap2, 330, "tibt");
        CharScript.putScriptTag(hashMap, hashMap2, 340, "telu");
        CharScript.putScriptTag(hashMap, hashMap2, 1340, "tel2");
        CharScript.putScriptTag(hashMap, hashMap2, 345, "knda");
        CharScript.putScriptTag(hashMap, hashMap2, 1345, "knd2");
        CharScript.putScriptTag(hashMap, hashMap2, 346, "taml");
        CharScript.putScriptTag(hashMap, hashMap2, 1346, "tml2");
        CharScript.putScriptTag(hashMap, hashMap2, 347, "mlym");
        CharScript.putScriptTag(hashMap, hashMap2, 1347, "mlm2");
        CharScript.putScriptTag(hashMap, hashMap2, 348, "sinh");
        CharScript.putScriptTag(hashMap, hashMap2, 350, "mymr");
        CharScript.putScriptTag(hashMap, hashMap2, 352, "thai");
        CharScript.putScriptTag(hashMap, hashMap2, 355, "khmr");
        CharScript.putScriptTag(hashMap, hashMap2, 356, "laoo");
        CharScript.putScriptTag(hashMap, hashMap2, 410, "hira");
        CharScript.putScriptTag(hashMap, hashMap2, 430, "ethi");
        CharScript.putScriptTag(hashMap, hashMap2, 500, "hani");
        CharScript.putScriptTag(hashMap, hashMap2, 410, "kana");
        CharScript.putScriptTag(hashMap, hashMap2, 995, "zmth");
        CharScript.putScriptTag(hashMap, hashMap2, 996, "zsym");
        CharScript.putScriptTag(hashMap, hashMap2, 998, "zyyy");
        CharScript.putScriptTag(hashMap, hashMap2, 999, "zzzz");
        scriptTagsMap = hashMap;
        scriptCodeMap = hashMap2;
    }

    private static Map<Integer, String> getScriptTagsMap() {
        if (scriptTagsMap == null) {
            CharScript.makeScriptMaps();
        }
        return scriptTagsMap;
    }

    private static Map<String, Integer> getScriptCodeMap() {
        if (scriptCodeMap == null) {
            CharScript.makeScriptMaps();
        }
        return scriptCodeMap;
    }
}

