/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.complexscripts.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.fop.complexscripts.util.UTF32;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumberConverter {
    public static final int LETTER_VALUE_ALPHABETIC = 1;
    public static final int LETTER_VALUE_TRADITIONAL = 2;
    private static final int TOKEN_NONE = 0;
    private static final int TOKEN_ALPHANUMERIC = 1;
    private static final int TOKEN_NONALPHANUMERIC = 2;
    private static final Integer[] DEFAULT_TOKEN = new Integer[]{49};
    private static final Integer[] DEFAULT_SEPARATOR = new Integer[]{46};
    private static final String DEFAULT_LANGUAGE = "eng";
    private Integer[] prefix;
    private Integer[] suffix;
    private Integer[][] tokens;
    private Integer[][] separators;
    private int groupingSeparator;
    private int groupingSize;
    private int letterValue;
    private String features;
    private String language;
    private String country;
    private static String[][] equivalentLanguages = new String[][]{{"eng", "en"}, {"fra", "fre", "fr"}, {"spa", "es"}};
    private static int[][] supportedAlphabeticSequences = new int[][]{{65, 26}, {97, 26}};
    private static int[][] supportedSpecials = new int[][]{{73}, {105}, {913}, {945}, {1488}, {1571}, {1575}, {3585}, {12354}, {12356}, {12450}, {12452}};
    private static String[] englishWordOnes = new String[]{"zero", "one", "two", "three", "four", "five", "six", "seven", "eight", "nine"};
    private static String[] englishWordTeens = new String[]{"ten", "eleven", "twelve", "thirteen", "fourteen", "fifteen", "sixteen", "seventeen", "eighteen", "nineteen"};
    private static String[] englishWordTens = new String[]{"", "ten", "twenty", "thirty", "forty", "fifty", "sixty", "seventy", "eighty", "ninety"};
    private static String[] englishWordOthers = new String[]{"hundred", "thousand", "million", "billion"};
    private static String[] englishWordOnesOrd = new String[]{"none", "first", "second", "third", "fourth", "fifth", "sixth", "seventh", "eighth", "ninth"};
    private static String[] englishWordTeensOrd = new String[]{"tenth", "eleventh", "twelfth", "thirteenth", "fourteenth", "fifteenth", "sixteenth", "seventeenth", "eighteenth", "nineteenth"};
    private static String[] englishWordTensOrd = new String[]{"", "tenth", "twentieth", "thirtieth", "fortieth", "fiftieth", "sixtieth", "seventieth", "eightieth", "ninetith"};
    private static String[] englishWordOthersOrd = new String[]{"hundredth", "thousandth", "millionth", "billionth"};
    private static String[] frenchWordOnes = new String[]{"z\u00e9ro", "un", "deux", "trois", "quatre", "cinq", "six", "sept", "huit", "neuf"};
    private static String[] frenchWordTeens = new String[]{"dix", "onze", "douze", "treize", "quatorze", "quinze", "seize", "dix-sept", "dix-huit", "dix-neuf"};
    private static String[] frenchWordTens = new String[]{"", "dix", "vingt", "trente", "quarante", "cinquante", "soixante", "soixante-dix", "quatre-vingt", "quatre-vingt-dix"};
    private static String[] frenchWordOthers = new String[]{"cent", "cents", "mille", "million", "millions", "milliard", "milliards"};
    private static String[] frenchWordOnesOrdMale = new String[]{"premier", "deuxi\u00e8me", "troisi\u00e8me", "quatri\u00e8me", "cinqui\u00e8me", "sixi\u00e8me", "septi\u00e8me", "huiti\u00e8me", "neuvi\u00e8me", "dixi\u00e8me"};
    private static String[] frenchWordOnesOrdFemale = new String[]{"premi\u00e8re", "deuxi\u00e8me", "troisi\u00e8me", "quatri\u00e8me", "cinqui\u00e8me", "sixi\u00e8me", "septi\u00e8me", "huiti\u00e8me", "neuvi\u00e8me", "dixi\u00e8me"};
    private static String[] spanishWordOnes = new String[]{"cero", "uno", "dos", "tres", "cuatro", "cinco", "seise", "siete", "ocho", "nueve"};
    private static String[] spanishWordTeens = new String[]{"diez", "once", "doce", "trece", "catorce", "quince", "diecis\u00e9is", "diecisiete", "dieciocho", "diecinueve"};
    private static String[] spanishWordTweens = new String[]{"veinte", "veintiuno", "veintid\u00f3s", "veintitr\u00e9s", "veinticuatro", "veinticinco", "veintis\u00e9is", "veintisiete", "veintiocho", "veintinueve"};
    private static String[] spanishWordTens = new String[]{"", "diez", "veinte", "treinta", "cuarenta", "cincuenta", "sesenta", "setenta", "ochenta", "noventa"};
    private static String[] spanishWordHundreds = new String[]{"", "ciento", "doscientos", "trescientos", "cuatrocientos", "quinientos", "seiscientos", "setecientos", "ochocientos", "novecientos"};
    private static String[] spanishWordOthers = new String[]{"un", "cien", "mil", "mill\u00f3n", "millones"};
    private static String[] spanishWordOnesOrdMale = new String[]{"ninguno", "primero", "segundo", "tercero", "cuarto", "quinto", "sexto", "s\u00e9ptimo", "octavo", "novento", "d\u00e9cimo"};
    private static String[] spanishWordOnesOrdFemale = new String[]{"ninguna", "primera", "segunda", "tercera", "cuarta", "quinta", "sexta", "s\u00e9ptima", "octava", "noventa", "d\u00e9cima"};
    private static int[] romanMapping = new int[]{100000, 90000, 50000, 40000, 10000, 9000, 5000, 4000, 1000, 900, 500, 400, 100, 90, 50, 40, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1};
    private static String[] romanStandardForms = new String[]{null, null, null, null, null, null, null, null, "m", "cm", "d", "cd", "c", "xc", "l", "xl", "x", "ix", null, null, null, "v", "iv", null, null, "i"};
    private static String[] romanLargeForms = new String[]{"\u2188", "\u2182\u2188", "\u2187", "\u2182\u2187", "\u2182", "\u2180\u2182", "\u2181", "\u2180\u2181", "m", "cm", "d", "cd", "c", "xc", "l", "xl", "x", "ix", null, null, null, "v", "iv", null, null, "i"};
    private static String[] romanNumberForms = new String[]{"\u2188", "\u2182\u2188", "\u2187", "\u2182\u2187", "\u2182", "\u2180\u2182", "\u2181", "\u2180\u2181", "\u216f", "\u216d\u216f", "\u216e", "\u216d\u216e", "\u216d", "\u2169\u216d", "\u216c", "\u2169\u216c", "\u2169", "\u2168", "\u2167", "\u2166", "\u2165", "\u2164", "\u2163", "\u2162", "\u2161", "\u2160"};
    private static int[] hebrewGematriaAlphabeticMap = new int[]{1488, 1489, 1490, 1491, 1492, 1493, 1494, 1495, 1496, 1497, 1499, 1500, 1502, 1504, 1505, 1506, 1508, 1510, 1511, 1512, 1513, 1514, 1498, 1501, 1503, 1507, 1509};
    private static int[] arabicAbjadiAlphabeticMap = new int[]{1571, 1576, 1580, 1583, 1607, 1608, 1586, 1581, 1591, 1609, 1603, 1604, 1605, 1606, 1587, 1593, 1601, 1589, 1602, 1585, 1588, 1578, 1579, 1582, 1584, 1590, 1592, 1594};
    private static int[] arabicHijaiAlphabeticMap = new int[]{1571, 1576, 1578, 1579, 1580, 1581, 1582, 1583, 1584, 1585, 1586, 1587, 1588, 1589, 1590, 1591, 1592, 1593, 1594, 1601, 1602, 1603, 1604, 1605, 1606, 1607, 1608, 1609};
    private static int[] hiraganaGojuonAlphabeticMap = new int[]{12354, 12356, 12358, 12360, 12362, 12363, 12365, 12367, 12369, 12371, 12373, 12375, 12377, 12379, 12381, 12383, 12385, 12388, 12390, 12392, 12394, 12395, 12396, 12397, 12398, 12399, 12402, 12405, 12408, 12411, 12414, 12415, 12416, 12417, 12418, 12420, 12422, 12424, 12425, 12426, 12427, 12428, 12429, 12431, 12432, 12433, 12434, 12435};
    private static int[] katakanaGojuonAlphabeticMap = new int[]{12450, 12452, 12454, 12456, 12458, 12459, 12461, 12463, 12465, 12467, 12469, 12471, 12473, 12475, 12477, 12479, 12481, 12484, 12486, 12488, 12490, 12491, 12492, 12493, 12494, 12495, 12498, 12501, 12504, 12507, 12510, 12511, 12512, 12513, 12514, 12516, 12518, 12520, 12521, 12522, 12523, 12524, 12525, 12527, 12528, 12529, 12530, 12531};
    private static int[] thaiAlphabeticMap = new int[]{3585, 3586, 3587, 3588, 3589, 3590, 3591, 3592, 3593, 3594, 3595, 3596, 3597, 3598, 3599, 3600, 3601, 3602, 3603, 3604, 3605, 3606, 3607, 3608, 3609, 3610, 3611, 3612, 3613, 3614, 3615, 3616, 3617, 3618, 3619, 3621, 3623, 3624, 3625, 3626, 3627, 3628, 3629, 3630};

    public NumberConverter(String string, int n, int n2, int n3, String string2, String string3, String string4) throws IllegalArgumentException {
        this.groupingSeparator = n;
        this.groupingSize = n2;
        this.letterValue = n3;
        this.features = string2;
        this.language = string3 != null ? string3.toLowerCase() : null;
        this.country = string4 != null ? string4.toLowerCase() : null;
        this.parseFormatTokens(string);
    }

    public String convert(long l) {
        ArrayList<Long> arrayList = new ArrayList<Long>();
        arrayList.add(l);
        return this.convert(arrayList);
    }

    public String convert(List<Long> list) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        if (this.prefix != null) {
            NumberConverter.appendScalars(arrayList, this.prefix);
        }
        this.convertNumbers(arrayList, list);
        if (this.suffix != null) {
            NumberConverter.appendScalars(arrayList, this.suffix);
        }
        return NumberConverter.scalarsToString(arrayList);
    }

    private void parseFormatTokens(String string) throws IllegalArgumentException {
        ArrayList<Integer[]> arrayList = new ArrayList<Integer[]>();
        ArrayList<Integer[]> arrayList2 = new ArrayList<Integer[]>();
        if (string == null || string.length() == 0) {
            string = "1";
        }
        int n = 0;
        ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
        Integer[] integerArray = UTF32.toUTF32(string, 0, true);
        int n2 = integerArray.length;
        for (int i = 0; i < n2; ++i) {
            int n3;
            int n4 = integerArray[i];
            int n5 = n3 = NumberConverter.isAlphaNumeric(n4) ? 1 : 2;
            if (n3 != n) {
                if (arrayList3.size() > 0) {
                    if (n == 1) {
                        arrayList.add(arrayList3.toArray(new Integer[arrayList3.size()]));
                    } else {
                        arrayList2.add(arrayList3.toArray(new Integer[arrayList3.size()]));
                    }
                    arrayList3.clear();
                }
                n = n3;
            }
            arrayList3.add(n4);
        }
        if (arrayList3.size() > 0) {
            if (n == 1) {
                arrayList.add(arrayList3.toArray(new Integer[arrayList3.size()]));
            } else {
                arrayList2.add(arrayList3.toArray(new Integer[arrayList3.size()]));
            }
        }
        if (!arrayList2.isEmpty()) {
            this.prefix = (Integer[])arrayList2.remove(0);
        }
        if (!arrayList2.isEmpty()) {
            this.suffix = (Integer[])arrayList2.remove(arrayList2.size() - 1);
        }
        this.separators = (Integer[][])arrayList2.toArray((T[])new Integer[arrayList2.size()][]);
        this.tokens = (Integer[][])arrayList.toArray((T[])new Integer[arrayList.size()][]);
    }

    private static boolean isAlphaNumeric(int n) {
        switch (Character.getType(n)) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: {
                return true;
            }
        }
        return false;
    }

    private void convertNumbers(List<Integer> list, List<Long> list2) {
        Integer[] integerArray = DEFAULT_TOKEN;
        int n = 0;
        int n2 = this.tokens.length;
        int n3 = 0;
        int n4 = this.separators.length;
        int n5 = 0;
        for (Long l : list2) {
            Integer[] integerArray2;
            Integer[] integerArray3 = null;
            if (n < n2) {
                if (n5 > 0) {
                    integerArray3 = n3 < n4 ? this.separators[n3++] : DEFAULT_SEPARATOR;
                }
                integerArray2 = this.tokens[n++];
            } else {
                integerArray2 = integerArray;
            }
            NumberConverter.appendScalars(list, this.convertNumber(l, integerArray3, integerArray2));
            integerArray = integerArray2;
            ++n5;
        }
    }

    private Integer[] convertNumber(long l, Integer[] integerArray, Integer[] integerArray2) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        if (integerArray != null) {
            NumberConverter.appendScalars(arrayList, integerArray);
        }
        if (integerArray2 != null) {
            NumberConverter.appendScalars(arrayList, this.formatNumber(l, integerArray2));
        }
        return arrayList.toArray(new Integer[arrayList.size()]);
    }

    private Integer[] formatNumber(long l, Integer[] integerArray) {
        Integer[] integerArray2 = null;
        assert (integerArray.length > 0);
        if (l < 0L) {
            throw new IllegalArgumentException("number must be non-negative");
        }
        if (integerArray.length == 1) {
            int n = integerArray[0];
            switch (n) {
                case 49: {
                    integerArray2 = this.formatNumberAsDecimal(l, 49, 1);
                    break;
                }
                case 87: 
                case 119: {
                    integerArray2 = this.formatNumberAsWord(l, n == 87 ? 1 : 2);
                    break;
                }
                default: {
                    if (NumberConverter.isStartOfDecimalSequence(n)) {
                        integerArray2 = this.formatNumberAsDecimal(l, n, 1);
                        break;
                    }
                    if (NumberConverter.isStartOfAlphabeticSequence(n)) {
                        integerArray2 = this.formatNumberAsSequence(l, n, NumberConverter.getSequenceBase(n), null);
                        break;
                    }
                    if (NumberConverter.isStartOfNumericSpecial(n)) {
                        integerArray2 = this.formatNumberAsSpecial(l, n);
                        break;
                    }
                    integerArray2 = null;
                    break;
                }
            }
        } else if (integerArray.length == 2 && integerArray[0] == 87 && integerArray[1] == 119) {
            integerArray2 = this.formatNumberAsWord(l, 3);
        } else if (NumberConverter.isPaddedOne(integerArray)) {
            int n = integerArray[integerArray.length - 1];
            integerArray2 = this.formatNumberAsDecimal(l, n, integerArray.length);
        } else {
            throw new IllegalArgumentException("invalid format token: \"" + UTF32.fromUTF32(integerArray) + "\"");
        }
        if (integerArray2 == null) {
            integerArray2 = this.formatNumber(l, DEFAULT_TOKEN);
        }
        assert (integerArray2 != null);
        return integerArray2;
    }

    private Integer[] formatNumberAsDecimal(long l, int n, int n2) {
        assert (Character.getNumericValue(n) == 1);
        assert (Character.getNumericValue(n - 1) == 0);
        assert (Character.getNumericValue(n + 8) == 9);
        List<Integer> list = new ArrayList<Integer>();
        int n3 = n - 1;
        while (l > 0L) {
            long l2 = l % 10L;
            list.add(0, n3 + (int)l2);
            l /= 10L;
        }
        while (n2 > list.size()) {
            list.add(0, n3);
        }
        if (this.groupingSize != 0 && this.groupingSeparator != 0) {
            list = NumberConverter.performGrouping(list, this.groupingSize, this.groupingSeparator);
        }
        return list.toArray(new Integer[list.size()]);
    }

    private static List<Integer> performGrouping(List<Integer> list, int n, int n2) {
        assert (n > 0);
        assert (n2 != 0);
        if (list.size() > n) {
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            int n3 = list.size();
            int n4 = 0;
            for (int i = 0; i < n3; ++i) {
                int n5 = n3 - i - 1;
                if (n4 == n) {
                    arrayList.add(0, n2);
                    n4 = 1;
                } else {
                    ++n4;
                }
                arrayList.add(0, list.get(n5));
            }
            return arrayList;
        }
        return list;
    }

    private Integer[] formatNumberAsSequence(long l, int n, int n2, int[] nArray) {
        assert (n2 > 1);
        assert (nArray == null || nArray.length >= n2);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        if (l == 0L) {
            return null;
        }
        long l2 = l;
        while (l2 > 0L) {
            int n3 = (int)((l2 - 1L) % (long)n2);
            int n4 = nArray != null ? nArray[n3] : n + n3;
            arrayList.add(0, n4);
            l2 = (l2 - 1L) / (long)n2;
        }
        return arrayList.toArray(new Integer[arrayList.size()]);
    }

    private Integer[] formatNumberAsSpecial(long l, int n) {
        SpecialNumberFormatter specialNumberFormatter = this.getSpecialFormatter(n, this.letterValue, this.features, this.language, this.country);
        if (specialNumberFormatter != null) {
            return specialNumberFormatter.format(l, n, this.letterValue, this.features, this.language, this.country);
        }
        return null;
    }

    private Integer[] formatNumberAsWord(long l, int n) {
        SpecialNumberFormatter specialNumberFormatter = null;
        specialNumberFormatter = this.isLanguage(DEFAULT_LANGUAGE) ? new EnglishNumberAsWordFormatter(n) : (this.isLanguage("spa") ? new SpanishNumberAsWordFormatter(n) : (this.isLanguage("fra") ? new FrenchNumberAsWordFormatter(n) : new EnglishNumberAsWordFormatter(n)));
        return specialNumberFormatter.format(l, 0, this.letterValue, this.features, this.language, this.country);
    }

    private boolean isLanguage(String string) {
        if (this.language == null) {
            return false;
        }
        if (this.language.equals(string)) {
            return true;
        }
        return NumberConverter.isSameLanguage(string, this.language);
    }

    private static boolean isSameLanguage(String string, String string2) {
        for (String[] stringArray : equivalentLanguages) {
            assert (stringArray.length >= 2);
            if (!stringArray[0].equals(string)) continue;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                if (!stringArray[i].equals(string2)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    private static boolean hasFeature(String string, String string2) {
        if (string != null) {
            String[] stringArray;
            assert (string2 != null);
            assert (string2.length() != 0);
            for (String string3 : stringArray = string.split(",")) {
                String string4;
                String[] stringArray2 = string3.split("=");
                assert (stringArray2.length > 0);
                String string5 = stringArray2[0];
                String string6 = string4 = stringArray2.length > 1 ? stringArray2[1] : "";
                if (!string5.equals(string2)) continue;
                return true;
            }
        }
        return false;
    }

    private static void appendScalars(List<Integer> list, Integer[] integerArray) {
        for (Integer n : integerArray) {
            list.add(n);
        }
    }

    private static String scalarsToString(List<Integer> list) {
        Integer[] integerArray = list.toArray(new Integer[list.size()]);
        return UTF32.fromUTF32(integerArray);
    }

    private static boolean isPaddedOne(Integer[] integerArray) {
        if (NumberConverter.getDecimalValue(integerArray[integerArray.length - 1]) != 1) {
            return false;
        }
        int n = integerArray.length - 1;
        for (int i = 0; i < n; ++i) {
            if (NumberConverter.getDecimalValue(integerArray[i]) == 0) continue;
            return false;
        }
        return true;
    }

    private static int getDecimalValue(Integer n) {
        int n2 = n;
        if (Character.getType(n2) == 9) {
            return Character.getNumericValue(n2);
        }
        return -1;
    }

    private static boolean isStartOfDecimalSequence(int n) {
        return Character.getNumericValue(n) == 1 && Character.getNumericValue(n - 1) == 0 && Character.getNumericValue(n + 8) == 9;
    }

    private static boolean isStartOfAlphabeticSequence(int n) {
        for (int[] nArray : supportedAlphabeticSequences) {
            assert (nArray.length >= 2);
            if (nArray[0] != n) continue;
            return true;
        }
        return false;
    }

    private static int getSequenceBase(int n) {
        for (int[] nArray : supportedAlphabeticSequences) {
            assert (nArray.length >= 2);
            if (nArray[0] != n) continue;
            return nArray[1];
        }
        return 0;
    }

    private static boolean isStartOfNumericSpecial(int n) {
        for (int[] nArray : supportedSpecials) {
            assert (nArray.length >= 1);
            if (nArray[0] != n) continue;
            return true;
        }
        return false;
    }

    private SpecialNumberFormatter getSpecialFormatter(int n, int n2, String string, String string2, String string3) {
        if (n == 73) {
            return new RomanNumeralsFormatter();
        }
        if (n == 105) {
            return new RomanNumeralsFormatter();
        }
        if (n == 913) {
            return new IsopsephryNumeralsFormatter();
        }
        if (n == 945) {
            return new IsopsephryNumeralsFormatter();
        }
        if (n == 1488) {
            return new GematriaNumeralsFormatter();
        }
        if (n == 1571) {
            return new ArabicNumeralsFormatter();
        }
        if (n == 1575) {
            return new ArabicNumeralsFormatter();
        }
        if (n == 3585) {
            return new ThaiNumeralsFormatter();
        }
        if (n == 12354) {
            return new KanaNumeralsFormatter();
        }
        if (n == 12356) {
            return new KanaNumeralsFormatter();
        }
        if (n == 12450) {
            return new KanaNumeralsFormatter();
        }
        if (n == 12452) {
            return new KanaNumeralsFormatter();
        }
        return null;
    }

    private static Integer[] toUpperCase(Integer[] integerArray) {
        assert (integerArray != null);
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            Integer n2 = integerArray[i];
            integerArray[i] = Character.toUpperCase(n2);
        }
        return integerArray;
    }

    private static Integer[] toLowerCase(Integer[] integerArray) {
        assert (integerArray != null);
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            Integer n2 = integerArray[i];
            integerArray[i] = Character.toLowerCase(n2);
        }
        return integerArray;
    }

    private static List<String> convertWordCase(List<String> list, int n) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : list) {
            arrayList.add(NumberConverter.convertWordCase(string, n));
        }
        return arrayList;
    }

    private static String convertWordCase(String string, int n) {
        if (n == 1) {
            return string.toUpperCase();
        }
        if (n == 2) {
            return string.toLowerCase();
        }
        if (n == 3) {
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = string.length();
            for (int i = 0; i < n2; ++i) {
                String string2 = string.substring(i, i + 1);
                if (i == 0) {
                    stringBuffer.append(string2.toUpperCase());
                    continue;
                }
                stringBuffer.append(string2.toLowerCase());
            }
            return stringBuffer.toString();
        }
        return string;
    }

    private static String joinWords(List<String> list, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (String string2 : list) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(string);
            }
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    private class ThaiNumeralsFormatter
    implements SpecialNumberFormatter {
        private ThaiNumeralsFormatter() {
        }

        public Integer[] format(long l, int n, int n2, String string, String string2, String string3) {
            if (n == 3585 && n2 == 1) {
                return NumberConverter.this.formatNumberAsSequence(l, n, thaiAlphabeticMap.length, thaiAlphabeticMap);
            }
            return null;
        }
    }

    private class KanaNumeralsFormatter
    implements SpecialNumberFormatter {
        private KanaNumeralsFormatter() {
        }

        public Integer[] format(long l, int n, int n2, String string, String string2, String string3) {
            if (n == 12354 && n2 == 1) {
                return NumberConverter.this.formatNumberAsSequence(l, n, hiraganaGojuonAlphabeticMap.length, hiraganaGojuonAlphabeticMap);
            }
            if (n == 12450 && n2 == 1) {
                return NumberConverter.this.formatNumberAsSequence(l, n, katakanaGojuonAlphabeticMap.length, katakanaGojuonAlphabeticMap);
            }
            return null;
        }
    }

    private class ArabicNumeralsFormatter
    implements SpecialNumberFormatter {
        private ArabicNumeralsFormatter() {
        }

        public Integer[] format(long l, int n, int n2, String string, String string2, String string3) {
            if (n == 1575) {
                int[] nArray = n2 == 2 ? arabicAbjadiAlphabeticMap : (n2 == 1 ? arabicHijaiAlphabeticMap : arabicAbjadiAlphabeticMap);
                return NumberConverter.this.formatNumberAsSequence(l, n, nArray.length, nArray);
            }
            if (n == 1571) {
                if (l == 0L || l > 1999L) {
                    return null;
                }
                return this.formatAsAbjadiNumber(l, string, string2, string3);
            }
            return null;
        }

        private Integer[] formatAsAbjadiNumber(long l, String string, String string2, String string3) {
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            assert (arabicAbjadiAlphabeticMap.length == 28);
            assert (arabicAbjadiAlphabeticMap[0] == 1571);
            assert (arabicAbjadiAlphabeticMap[27] == 1594);
            assert (l != 0L);
            assert (l < 2000L);
            int[] nArray = arabicAbjadiAlphabeticMap;
            int n = (int)(l / 1000L % 10L);
            int n2 = (int)(l / 100L % 10L);
            int n3 = (int)(l / 10L % 10L);
            int n4 = (int)(l / 1L % 10L);
            if (n > 0) {
                assert (n < 2);
                arrayList.add(nArray[27 + (n - 1)]);
            }
            if (n2 > 0) {
                assert (n < 10);
                arrayList.add(nArray[18 + (n2 - 1)]);
            }
            if (n3 > 0) {
                assert (n3 < 10);
                arrayList.add(nArray[9 + (n3 - 1)]);
            }
            if (n4 > 0) {
                assert (n4 < 10);
                arrayList.add(nArray[0 + (n4 - 1)]);
            }
            return arrayList.toArray(new Integer[arrayList.size()]);
        }
    }

    private class GematriaNumeralsFormatter
    implements SpecialNumberFormatter {
        private GematriaNumeralsFormatter() {
        }

        public Integer[] format(long l, int n, int n2, String string, String string2, String string3) {
            if (n == 1488) {
                if (n2 == 1) {
                    return NumberConverter.this.formatNumberAsSequence(l, n, hebrewGematriaAlphabeticMap.length, hebrewGematriaAlphabeticMap);
                }
                if (n2 == 2) {
                    if (l == 0L || l > 1999L) {
                        return null;
                    }
                    return this.formatAsGematriaNumber(l, string, string2, string3);
                }
                return null;
            }
            return null;
        }

        private Integer[] formatAsGematriaNumber(long l, String string, String string2, String string3) {
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            assert (hebrewGematriaAlphabeticMap.length == 27);
            assert (hebrewGematriaAlphabeticMap[0] == 1488);
            assert (hebrewGematriaAlphabeticMap[21] == 1514);
            assert (l != 0L);
            assert (l < 2000L);
            int[] nArray = hebrewGematriaAlphabeticMap;
            int n = (int)(l / 1000L % 10L);
            int n2 = (int)(l / 100L % 10L);
            int n3 = (int)(l / 10L % 10L);
            int n4 = (int)(l / 1L % 10L);
            if (n > 0) {
                arrayList.add(nArray[0 + (n - 1)]);
                arrayList.add(1523);
            }
            if (n2 > 0) {
                assert (n2 < 10);
                if (n2 < 5) {
                    arrayList.add(nArray[18 + (n2 - 1)]);
                } else if (n2 < 9) {
                    arrayList.add(nArray[21]);
                    arrayList.add(1524);
                    arrayList.add(nArray[18 + (n2 - 5)]);
                } else if (n2 == 9) {
                    arrayList.add(nArray[21]);
                    arrayList.add(nArray[21]);
                    arrayList.add(1524);
                    arrayList.add(nArray[18 + (n2 - 9)]);
                }
            }
            if (l == 15L) {
                arrayList.add(nArray[8]);
                arrayList.add(1524);
                arrayList.add(nArray[5]);
            } else if (l == 16L) {
                arrayList.add(nArray[8]);
                arrayList.add(1524);
                arrayList.add(nArray[6]);
            } else {
                if (n3 > 0) {
                    assert (n3 < 10);
                    arrayList.add(nArray[9 + (n3 - 1)]);
                }
                if (n4 > 0) {
                    assert (n4 < 10);
                    arrayList.add(nArray[0 + (n4 - 1)]);
                }
            }
            return arrayList.toArray(new Integer[arrayList.size()]);
        }
    }

    private static class IsopsephryNumeralsFormatter
    implements SpecialNumberFormatter {
        private IsopsephryNumeralsFormatter() {
        }

        public Integer[] format(long l, int n, int n2, String string, String string2, String string3) {
            return null;
        }
    }

    private static class RomanNumeralsFormatter
    implements SpecialNumberFormatter {
        private RomanNumeralsFormatter() {
        }

        public Integer[] format(long l, int n, int n2, String string, String string2, String string3) {
            int n3;
            String[] stringArray;
            ArrayList arrayList = new ArrayList();
            if (l == 0L) {
                return null;
            }
            if (NumberConverter.hasFeature(string, "unicode-number-forms")) {
                stringArray = romanNumberForms;
                n3 = 199999;
            } else if (NumberConverter.hasFeature(string, "large")) {
                stringArray = romanLargeForms;
                n3 = 199999;
            } else {
                stringArray = romanStandardForms;
                n3 = 4999;
            }
            if (l > (long)n3) {
                return null;
            }
            block0: while (l > 0L) {
                int n4 = romanMapping.length;
                for (int i = 0; i < n4; ++i) {
                    int n5 = romanMapping[i];
                    if (l < (long)n5 || stringArray[i] == null) continue;
                    NumberConverter.appendScalars(arrayList, UTF32.toUTF32(stringArray[i], 0, true));
                    l -= (long)n5;
                    continue block0;
                }
            }
            if (n == 73) {
                return NumberConverter.toUpperCase(arrayList.toArray(new Integer[arrayList.size()]));
            }
            if (n == 105) {
                return NumberConverter.toLowerCase(arrayList.toArray(new Integer[arrayList.size()]));
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SpanishNumberAsWordFormatter
    implements SpecialNumberFormatter {
        private int caseType = 1;

        SpanishNumberAsWordFormatter(int n) {
            this.caseType = n;
        }

        @Override
        public Integer[] format(long l, int n, int n2, String string, String string2, String string3) {
            List<String> list = new ArrayList<String>();
            if (l >= 1000000000000L) {
                return null;
            }
            boolean bl = NumberConverter.hasFeature(string, "ordinal");
            if (l == 0L) {
                list.add(spanishWordOnes[0]);
            } else if (bl && l <= 10L) {
                boolean bl2 = NumberConverter.hasFeature(string, "female");
                if (bl2) {
                    list.add(spanishWordOnesOrdFemale[(int)l]);
                } else {
                    list.add(spanishWordOnesOrdMale[(int)l]);
                }
            } else {
                int n3 = (int)(l % 1000L);
                int n4 = (int)(l / 1000L % 1000L);
                int n5 = (int)(l / 1000000L % 1000L);
                int n6 = (int)(l / 1000000000L % 1000L);
                if (n6 > 0) {
                    if (n6 > 1) {
                        list = this.formatOnesInThousand(list, n6);
                    }
                    list.add(spanishWordOthers[2]);
                    list.add(spanishWordOthers[4]);
                }
                if (n5 > 0) {
                    if (n5 == 1) {
                        list.add(spanishWordOthers[0]);
                    } else {
                        list = this.formatOnesInThousand(list, n5);
                    }
                    if (n5 > 1) {
                        list.add(spanishWordOthers[4]);
                    } else {
                        list.add(spanishWordOthers[3]);
                    }
                }
                if (n4 > 0) {
                    if (n4 > 1) {
                        list = this.formatOnesInThousand(list, n4);
                    }
                    list.add(spanishWordOthers[2]);
                }
                if (n3 > 0) {
                    list = this.formatOnesInThousand(list, n3);
                }
            }
            list = NumberConverter.convertWordCase(list, this.caseType);
            return UTF32.toUTF32(NumberConverter.joinWords(list, " "), 0, true);
        }

        private List<String> formatOnesInThousand(List<String> list, int n) {
            assert (n < 1000);
            int n2 = n % 10;
            int n3 = n / 10 % 10;
            int n4 = n / 100 % 10;
            if (n4 > 0) {
                if (n4 == 1 && n3 == 0 && n2 == 0) {
                    list.add(spanishWordOthers[1]);
                } else {
                    list.add(spanishWordHundreds[n4]);
                }
            }
            if (n3 > 0) {
                if (n3 == 1) {
                    list.add(spanishWordTeens[n2]);
                } else if (n3 == 2) {
                    list.add(spanishWordTweens[n2]);
                } else {
                    list.add(spanishWordTens[n3]);
                    if (n2 > 0) {
                        list.add("y");
                        list.add(spanishWordOnes[n2]);
                    }
                }
            } else if (n2 > 0) {
                list.add(spanishWordOnes[n2]);
            }
            return list;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FrenchNumberAsWordFormatter
    implements SpecialNumberFormatter {
        private int caseType = 1;

        FrenchNumberAsWordFormatter(int n) {
            this.caseType = n;
        }

        @Override
        public Integer[] format(long l, int n, int n2, String string, String string2, String string3) {
            List<String> list = new ArrayList<String>();
            if (l >= 1000000000000L) {
                return null;
            }
            boolean bl = NumberConverter.hasFeature(string, "ordinal");
            if (l == 0L) {
                list.add(frenchWordOnes[0]);
            } else if (bl && l <= 10L) {
                boolean bl2 = NumberConverter.hasFeature(string, "female");
                if (bl2) {
                    list.add(frenchWordOnesOrdFemale[(int)l]);
                } else {
                    list.add(frenchWordOnesOrdMale[(int)l]);
                }
            } else {
                int n3 = (int)(l % 1000L);
                int n4 = (int)(l / 1000L % 1000L);
                int n5 = (int)(l / 1000000L % 1000L);
                int n6 = (int)(l / 1000000000L % 1000L);
                if (n6 > 0) {
                    list = this.formatOnesInThousand(list, n6);
                    if (n6 == 1) {
                        list.add(frenchWordOthers[5]);
                    } else {
                        list.add(frenchWordOthers[6]);
                    }
                }
                if (n5 > 0) {
                    list = this.formatOnesInThousand(list, n5);
                    if (n5 == 1) {
                        list.add(frenchWordOthers[3]);
                    } else {
                        list.add(frenchWordOthers[4]);
                    }
                }
                if (n4 > 0) {
                    if (n4 > 1) {
                        list = this.formatOnesInThousand(list, n4);
                    }
                    list.add(frenchWordOthers[2]);
                }
                if (n3 > 0) {
                    list = this.formatOnesInThousand(list, n3);
                }
            }
            list = NumberConverter.convertWordCase(list, this.caseType);
            return UTF32.toUTF32(NumberConverter.joinWords(list, " "), 0, true);
        }

        private List<String> formatOnesInThousand(List<String> list, int n) {
            assert (n < 1000);
            int n2 = n % 10;
            int n3 = n / 10 % 10;
            int n4 = n / 100 % 10;
            if (n4 > 0) {
                if (n4 > 1) {
                    list.add(frenchWordOnes[n4]);
                }
                if (n4 > 1 && n3 == 0 && n2 == 0) {
                    list.add(frenchWordOthers[1]);
                } else {
                    list.add(frenchWordOthers[0]);
                }
            }
            if (n3 > 0) {
                if (n3 == 1) {
                    list.add(frenchWordTeens[n2]);
                } else if (n3 < 7) {
                    if (n2 == 1) {
                        list.add(frenchWordTens[n3]);
                        list.add("et");
                        list.add(frenchWordOnes[n2]);
                    } else {
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append(frenchWordTens[n3]);
                        if (n2 > 0) {
                            stringBuffer.append('-');
                            stringBuffer.append(frenchWordOnes[n2]);
                        }
                        list.add(stringBuffer.toString());
                    }
                } else if (n3 == 7) {
                    if (n2 == 1) {
                        list.add(frenchWordTens[6]);
                        list.add("et");
                        list.add(frenchWordTeens[n2]);
                    } else {
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append(frenchWordTens[6]);
                        stringBuffer.append('-');
                        stringBuffer.append(frenchWordTeens[n2]);
                        list.add(stringBuffer.toString());
                    }
                } else if (n3 == 8) {
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append(frenchWordTens[n3]);
                    if (n2 > 0) {
                        stringBuffer.append('-');
                        stringBuffer.append(frenchWordOnes[n2]);
                    } else {
                        stringBuffer.append('s');
                    }
                    list.add(stringBuffer.toString());
                } else if (n3 == 9) {
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append(frenchWordTens[8]);
                    stringBuffer.append('-');
                    stringBuffer.append(frenchWordTeens[n2]);
                    list.add(stringBuffer.toString());
                }
            } else if (n2 > 0) {
                list.add(frenchWordOnes[n2]);
            }
            return list;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EnglishNumberAsWordFormatter
    implements SpecialNumberFormatter {
        private int caseType = 1;

        EnglishNumberAsWordFormatter(int n) {
            this.caseType = n;
        }

        @Override
        public Integer[] format(long l, int n, int n2, String string, String string2, String string3) {
            List<Object> list = new ArrayList<String>();
            if (l >= 1000000000000L) {
                return null;
            }
            boolean bl = NumberConverter.hasFeature(string, "ordinal");
            if (l == 0L) {
                list.add(englishWordOnes[0]);
            } else if (bl && l < 10L) {
                list.add(englishWordOnesOrd[(int)l]);
            } else {
                int n3 = (int)(l % 1000L);
                int n4 = (int)(l / 1000L % 1000L);
                int n5 = (int)(l / 1000000L % 1000L);
                int n6 = (int)(l / 1000000000L % 1000L);
                if (n6 > 0) {
                    list = this.formatOnesInThousand(list, n6);
                    if (bl && l % 1000000000L == 0L) {
                        list.add(englishWordOthersOrd[3]);
                    } else {
                        list.add(englishWordOthers[3]);
                    }
                }
                if (n5 > 0) {
                    list = this.formatOnesInThousand(list, n5);
                    if (bl && l % 1000000L == 0L) {
                        list.add(englishWordOthersOrd[2]);
                    } else {
                        list.add(englishWordOthers[2]);
                    }
                }
                if (n4 > 0) {
                    list = this.formatOnesInThousand(list, n4);
                    if (bl && l % 1000L == 0L) {
                        list.add(englishWordOthersOrd[1]);
                    } else {
                        list.add(englishWordOthers[1]);
                    }
                }
                if (n3 > 0) {
                    list = this.formatOnesInThousand(list, n3, bl);
                }
            }
            list = NumberConverter.convertWordCase(list, this.caseType);
            return UTF32.toUTF32(NumberConverter.joinWords(list, " "), 0, true);
        }

        private List<String> formatOnesInThousand(List<String> list, int n) {
            return this.formatOnesInThousand(list, n, false);
        }

        private List<String> formatOnesInThousand(List<String> list, int n, boolean bl) {
            assert (n < 1000);
            int n2 = n % 10;
            int n3 = n / 10 % 10;
            int n4 = n / 100 % 10;
            if (n4 > 0) {
                list.add(englishWordOnes[n4]);
                if (bl && n % 100 == 0) {
                    list.add(englishWordOthersOrd[0]);
                } else {
                    list.add(englishWordOthers[0]);
                }
            }
            if (n3 > 0) {
                if (n3 == 1) {
                    if (bl) {
                        list.add(englishWordTeensOrd[n2]);
                    } else {
                        list.add(englishWordTeens[n2]);
                    }
                } else {
                    if (bl && n2 == 0) {
                        list.add(englishWordTensOrd[n3]);
                    } else {
                        list.add(englishWordTens[n3]);
                    }
                    if (n2 > 0) {
                        if (bl) {
                            list.add(englishWordOnesOrd[n2]);
                        } else {
                            list.add(englishWordOnes[n2]);
                        }
                    }
                }
            } else if (n2 > 0) {
                if (bl) {
                    list.add(englishWordOnesOrd[n2]);
                } else {
                    list.add(englishWordOnes[n2]);
                }
            }
            return list;
        }
    }

    static interface SpecialNumberFormatter {
        public Integer[] format(long var1, int var3, int var4, String var5, String var6, String var7);
    }
}

