/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.events;

import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.fop.events.model.EventSeverity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Event
extends EventObject {
    private static final long serialVersionUID = -1310594422868258083L;
    private String eventGroupID;
    private String eventKey;
    private EventSeverity severity;
    private Locale locale;
    private Map<String, Object> params;

    public Event(Object object, String string, EventSeverity eventSeverity, Map<String, Object> map) {
        this(object, string, eventSeverity, Locale.getDefault(), map);
    }

    public Event(Object object, String string, EventSeverity eventSeverity, Locale locale, Map<String, Object> map) {
        super(object);
        int n = string.lastIndexOf(46);
        if (n < 0 || n == string.length() - 1) {
            this.eventKey = string;
        } else {
            this.eventGroupID = string.substring(0, n);
            this.eventKey = string.substring(n + 1);
        }
        this.setSeverity(eventSeverity);
        this.locale = locale;
        this.params = map;
    }

    public String getEventID() {
        if (this.eventGroupID == null) {
            return this.eventKey;
        }
        return this.eventGroupID + '.' + this.eventKey;
    }

    public String getEventGroupID() {
        return this.eventGroupID;
    }

    public String getEventKey() {
        return this.eventKey;
    }

    public EventSeverity getSeverity() {
        return this.severity;
    }

    public void setSeverity(EventSeverity eventSeverity) {
        this.severity = eventSeverity;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Object getParam(String string) {
        if (this.params != null) {
            return this.params.get(string);
        }
        return null;
    }

    public Map<String, Object> getParams() {
        return Collections.unmodifiableMap(this.params);
    }

    public static ParamsBuilder paramsBuilder() {
        return new ParamsBuilder();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ParamsBuilder {
        private Map<String, Object> params;

        public ParamsBuilder param(String string, Object object) {
            if (this.params == null) {
                this.params = new HashMap<String, Object>();
            }
            this.params.put(string, object);
            return this;
        }

        public Map<String, Object> build() {
            return this.params;
        }
    }
}

