/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.events;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.fop.events.Event;
import org.apache.fop.events.EventFormatter;
import org.apache.xmlgraphics.util.Service;

public final class EventExceptionManager {
    private static final Map<String, ExceptionFactory> EXCEPTION_FACTORIES = new HashMap<String, ExceptionFactory>();

    private EventExceptionManager() {
    }

    public static void throwException(Event event, String string) throws Throwable {
        if (string != null) {
            ExceptionFactory exceptionFactory = EXCEPTION_FACTORIES.get(string);
            if (exceptionFactory != null) {
                throw exceptionFactory.createException(event);
            }
            throw new IllegalArgumentException("No such ExceptionFactory available: " + string);
        }
        String string2 = EventFormatter.format(event);
        Throwable throwable = null;
        for (Object object : event.getParams().values()) {
            if (!(object instanceof Throwable)) continue;
            throwable = (Throwable)object;
            break;
        }
        if (throwable != null) {
            throw new RuntimeException(string2, throwable);
        }
        throw new RuntimeException(string2);
    }

    static {
        Iterator iterator = Service.providers(ExceptionFactory.class);
        while (iterator.hasNext()) {
            ExceptionFactory exceptionFactory = (ExceptionFactory)iterator.next();
            EXCEPTION_FACTORIES.put(exceptionFactory.getExceptionClass().getName(), exceptionFactory);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ExceptionFactory {
        public Throwable createException(Event var1);

        public Class<? extends Exception> getExceptionClass();
    }
}

