/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.events.model;

import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.fop.events.model.EventMethodModel;
import org.apache.xmlgraphics.util.XMLizable;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class EventProducerModel
implements Serializable,
XMLizable {
    private static final long serialVersionUID = 122267104123721902L;
    private String interfaceName;
    private Map methods = new LinkedHashMap();

    public EventProducerModel(String string) {
        this.interfaceName = string;
    }

    public String getInterfaceName() {
        return this.interfaceName;
    }

    public void setInterfaceName(String string) {
        this.interfaceName = string;
    }

    public void addMethod(EventMethodModel eventMethodModel) {
        this.methods.put(eventMethodModel.getMethodName(), eventMethodModel);
    }

    public EventMethodModel getMethod(String string) {
        return (EventMethodModel)this.methods.get(string);
    }

    public Iterator getMethods() {
        return this.methods.values().iterator();
    }

    public void toSAX(ContentHandler contentHandler) throws SAXException {
        AttributesImpl attributesImpl = new AttributesImpl();
        attributesImpl.addAttribute("", "name", "name", "CDATA", this.getInterfaceName());
        String string = "producer";
        contentHandler.startElement("", string, string, attributesImpl);
        Iterator iterator = this.getMethods();
        while (iterator.hasNext()) {
            ((XMLizable)iterator.next()).toSAX(contentHandler);
        }
        contentHandler.endElement("", string, string);
    }
}

