/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.fop.apps.FOPException;
import org.apache.fop.fo.Constants;
import org.apache.fop.fo.FOEventHandler;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FOPropertyMapping;
import org.apache.fop.fo.FOText;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.ValidationException;
import org.apache.fop.fo.extensions.ExtensionAttachment;
import org.apache.fop.fo.flow.Marker;
import org.apache.fop.fo.properties.PropertyMaker;
import org.apache.xmlgraphics.util.QName;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;

public abstract class FObj
extends FONode
implements Constants {
    private static final PropertyMaker[] PROPERTY_LIST_TABLE = FOPropertyMapping.getGenericMappings();
    protected FONode firstChild;
    protected FONode lastChild;
    private List<ExtensionAttachment> extensionAttachments = null;
    private Map<QName, String> foreignAttributes = null;
    private boolean isOutOfLineFODescendant = false;
    private Map markers = null;
    private int bidiLevel = -1;
    private String id = null;

    public FObj(FONode fONode) {
        super(fONode);
        if (fONode != null && fONode instanceof FObj) {
            if (((FObj)fONode).getIsOutOfLineFODescendant()) {
                this.isOutOfLineFODescendant = true;
            } else {
                int n = this.getNameId();
                if (n == 15 || n == 24 || n == 25) {
                    this.isOutOfLineFODescendant = true;
                }
            }
        }
    }

    public FONode clone(FONode fONode, boolean bl) throws FOPException {
        FObj fObj = (FObj)super.clone(fONode, bl);
        if (bl) {
            fObj.firstChild = null;
        }
        return fObj;
    }

    public static PropertyMaker getPropertyMakerFor(int n) {
        return PROPERTY_LIST_TABLE[n];
    }

    public void processNode(String string, Locator locator, Attributes attributes, PropertyList propertyList) throws FOPException {
        this.setLocator(locator);
        propertyList.addAttributesToList(attributes);
        if (!this.inMarker() || "marker".equals(string)) {
            this.bind(propertyList);
        }
    }

    protected PropertyList createPropertyList(PropertyList propertyList, FOEventHandler fOEventHandler) throws FOPException {
        return this.getBuilderContext().getPropertyListMaker().make(this, propertyList);
    }

    public void bind(PropertyList propertyList) throws FOPException {
        this.id = propertyList.get(122).getString();
    }

    protected void startOfNode() throws FOPException {
        if (this.id != null) {
            this.checkId(this.id);
        }
    }

    private void checkId(String string) throws ValidationException {
        if (!this.inMarker() && !string.equals("")) {
            Set set = this.getBuilderContext().getIDReferences();
            if (!set.contains(string)) {
                set.add(string);
            } else {
                this.getFOValidationEventProducer().idNotUnique(this, this.getName(), string, true, this.locator);
            }
        }
    }

    boolean getIsOutOfLineFODescendant() {
        return this.isOutOfLineFODescendant;
    }

    protected void addChildNode(FONode fONode) throws FOPException {
        if (fONode.getNameId() == 44) {
            this.addMarker((Marker)fONode);
        } else {
            ExtensionAttachment extensionAttachment = fONode.getExtensionAttachment();
            if (extensionAttachment != null) {
                this.addExtensionAttachment(extensionAttachment);
            } else if (this.firstChild == null) {
                this.firstChild = fONode;
                this.lastChild = fONode;
            } else if (this.lastChild == null) {
                FONode fONode2 = this.firstChild;
                while (fONode2.siblings != null && fONode2.siblings[1] != null) {
                    fONode2 = fONode2.siblings[1];
                }
                FONode.attachSiblings(fONode2, fONode);
            } else {
                FONode.attachSiblings(this.lastChild, fONode);
                this.lastChild = fONode;
            }
        }
    }

    protected static void addChildTo(FONode fONode, FONode fONode2) throws FOPException {
        fONode2.addChildNode(fONode);
    }

    public void removeChild(FONode fONode) {
        FONode fONode2 = null;
        if (fONode.siblings != null) {
            fONode2 = fONode.siblings[1];
        }
        if (fONode == this.firstChild) {
            this.firstChild = fONode2;
            if (this.firstChild != null) {
                this.firstChild.siblings[0] = null;
            }
        } else {
            FONode fONode3 = fONode.siblings[0];
            fONode3.siblings[1] = fONode2;
            if (fONode2 != null) {
                fONode2.siblings[0] = fONode3;
            }
        }
        if (fONode == this.lastChild) {
            this.lastChild = fONode.siblings != null ? this.siblings[0] : null;
        }
    }

    public FObj findNearestAncestorFObj() {
        FONode fONode = this.parent;
        while (fONode != null && !(fONode instanceof FObj)) {
            fONode = fONode.parent;
        }
        return (FObj)fONode;
    }

    public boolean generatesReferenceAreas() {
        return false;
    }

    public FONode.FONodeIterator getChildNodes() {
        if (this.hasChildren()) {
            return new FObjIterator(this);
        }
        return null;
    }

    public boolean hasChildren() {
        return this.firstChild != null;
    }

    public FONode.FONodeIterator getChildNodes(FONode fONode) {
        FONode.FONodeIterator fONodeIterator = this.getChildNodes();
        if (fONodeIterator != null) {
            if (this.firstChild == fONode) {
                return fONodeIterator;
            }
            while (fONodeIterator.hasNext() && fONodeIterator.nextNode().siblings[1] != fONode) {
            }
            if (fONodeIterator.hasNext()) {
                return fONodeIterator;
            }
            return null;
        }
        return null;
    }

    void notifyChildRemoval(FONode fONode) {
    }

    protected void addMarker(Marker marker) {
        String string = marker.getMarkerClassName();
        if (this.firstChild != null) {
            FONode.FONodeIterator fONodeIterator = this.getChildNodes();
            while (fONodeIterator.hasNext()) {
                FONode fONode = (FONode)fONodeIterator.next();
                if (fONode instanceof FObj || fONode instanceof FOText && ((FOText)fONode).willCreateArea()) {
                    this.getFOValidationEventProducer().markerNotInitialChild(this, this.getName(), string, this.locator);
                    return;
                }
                if (!(fONode instanceof FOText)) continue;
                fONodeIterator.remove();
                this.notifyChildRemoval(fONode);
            }
        }
        if (this.markers == null) {
            this.markers = new HashMap();
        }
        if (!this.markers.containsKey(string)) {
            this.markers.put(string, marker);
        } else {
            this.getFOValidationEventProducer().markerNotUniqueForSameParent(this, this.getName(), string, this.locator);
        }
    }

    public boolean hasMarkers() {
        return this.markers != null && !this.markers.isEmpty();
    }

    public Map getMarkers() {
        return this.markers;
    }

    protected String getContextInfoAlt() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getLocalName() != null) {
            stringBuffer.append(this.getName());
            stringBuffer.append(", ");
        }
        if (this.hasId()) {
            stringBuffer.append("id=").append(this.getId());
            return stringBuffer.toString();
        }
        String string = this.gatherContextInfo();
        if (string != null) {
            stringBuffer.append("\"");
            if (string.length() < 32) {
                stringBuffer.append(string);
            } else {
                stringBuffer.append(string.substring(0, 32));
                stringBuffer.append("...");
            }
            stringBuffer.append("\"");
            return stringBuffer.toString();
        }
        return null;
    }

    protected String gatherContextInfo() {
        if (this.getLocator() != null) {
            return super.gatherContextInfo();
        }
        FONode.FONodeIterator fONodeIterator = this.getChildNodes();
        if (fONodeIterator == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        while (fONodeIterator.hasNext()) {
            FONode fONode = (FONode)fONodeIterator.next();
            String string = fONode.gatherContextInfo();
            if (string == null) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(string);
        }
        return stringBuffer.length() > 0 ? stringBuffer.toString() : null;
    }

    protected boolean isBlockItem(String string, String string2) {
        return "http://www.w3.org/1999/XSL/Format".equals(string) && ("block".equals(string2) || "table".equals(string2) || "table-and-caption".equals(string2) || "block-container".equals(string2) || "list-block".equals(string2) || "float".equals(string2) || this.isNeutralItem(string, string2));
    }

    protected boolean isInlineItem(String string, String string2) {
        return "http://www.w3.org/1999/XSL/Format".equals(string) && ("bidi-override".equals(string2) || "character".equals(string2) || "external-graphic".equals(string2) || "instream-foreign-object".equals(string2) || "inline".equals(string2) || "inline-container".equals(string2) || "leader".equals(string2) || "page-number".equals(string2) || "page-number-citation".equals(string2) || "page-number-citation-last".equals(string2) || "basic-link".equals(string2) || "multi-toggle".equals(string2) && (this.getNameId() == 45 || this.findAncestor(45) > 0) || "footnote".equals(string2) && !this.isOutOfLineFODescendant || this.isNeutralItem(string, string2));
    }

    protected boolean isBlockOrInlineItem(String string, String string2) {
        return this.isBlockItem(string, string2) || this.isInlineItem(string, string2);
    }

    protected boolean isNeutralItem(String string, String string2) {
        return "http://www.w3.org/1999/XSL/Format".equals(string) && ("multi-switch".equals(string2) || "multi-properties".equals(string2) || "wrapper".equals(string2) || !this.isOutOfLineFODescendant && "float".equals(string2) || "retrieve-marker".equals(string2) || "retrieve-table-marker".equals(string2));
    }

    protected int findAncestor(int n) {
        int n2 = 1;
        for (FONode fONode = this.getParent(); fONode != null; fONode = fONode.getParent()) {
            if (fONode.getNameId() == n) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public void clearChildNodes() {
        this.firstChild = null;
    }

    public String getId() {
        return this.id;
    }

    public boolean hasId() {
        return this.id != null && this.id.length() > 0;
    }

    public String getNamespaceURI() {
        return "http://www.w3.org/1999/XSL/Format";
    }

    public String getNormalNamespacePrefix() {
        return "fo";
    }

    public boolean isBidiRangeBlockItem() {
        String string;
        String string2 = this.getNamespaceURI();
        return !this.isNeutralItem(string2, string = this.getLocalName()) && this.isBlockItem(string2, string);
    }

    public void setBidiLevel(int n) {
        assert (n >= 0);
        if (n >= 0 && (this.bidiLevel < 0 || n < this.bidiLevel)) {
            FObj fObj;
            int n2;
            this.bidiLevel = n;
            if (this.parent != null && ((n2 = (fObj = (FObj)this.parent).getBidiLevel()) < 0 || n < n2)) {
                fObj.setBidiLevel(n);
            }
        }
    }

    public int getBidiLevel() {
        return this.bidiLevel;
    }

    public int getBidiLevelRecursive() {
        for (FONode fONode = this; fONode != null; fONode = fONode.getParent()) {
            int n;
            if (!(fONode instanceof FObj) || (n = fONode.getBidiLevel()) < 0) continue;
            return n;
        }
        return -1;
    }

    void addExtensionAttachment(ExtensionAttachment extensionAttachment) {
        if (extensionAttachment == null) {
            throw new NullPointerException("Parameter attachment must not be null");
        }
        if (this.extensionAttachments == null) {
            this.extensionAttachments = new ArrayList<ExtensionAttachment>();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("ExtensionAttachment of category " + extensionAttachment.getCategory() + " added to " + this.getName() + ": " + extensionAttachment));
        }
        this.extensionAttachments.add(extensionAttachment);
    }

    public List getExtensionAttachments() {
        if (this.extensionAttachments == null) {
            return Collections.EMPTY_LIST;
        }
        return this.extensionAttachments;
    }

    public boolean hasExtensionAttachments() {
        return this.extensionAttachments != null;
    }

    public void addForeignAttribute(QName qName, String string) {
        if (qName == null) {
            throw new NullPointerException("Parameter attributeName must not be null");
        }
        if (this.foreignAttributes == null) {
            this.foreignAttributes = new HashMap<QName, String>();
        }
        this.foreignAttributes.put(qName, string);
    }

    public Map getForeignAttributes() {
        if (this.foreignAttributes == null) {
            return Collections.EMPTY_MAP;
        }
        return this.foreignAttributes;
    }

    public String toString() {
        return super.toString() + "[@id=" + this.id + "]";
    }

    public static class FObjIterator
    implements FONode.FONodeIterator {
        private static final int F_NONE_ALLOWED = 0;
        private static final int F_SET_ALLOWED = 1;
        private static final int F_REMOVE_ALLOWED = 2;
        private FONode currentNode;
        private final FObj parentNode;
        private int currentIndex;
        private int flags = 0;

        FObjIterator(FObj fObj) {
            this.parentNode = fObj;
            this.currentNode = fObj.firstChild;
            this.currentIndex = 0;
            this.flags = 0;
        }

        public FObj parentNode() {
            return this.parentNode;
        }

        public Object next() {
            if (this.currentNode != null) {
                if (this.currentIndex != 0) {
                    if (this.currentNode.siblings != null && this.currentNode.siblings[1] != null) {
                        this.currentNode = this.currentNode.siblings[1];
                    } else {
                        throw new NoSuchElementException();
                    }
                }
                ++this.currentIndex;
                this.flags |= 3;
                return this.currentNode;
            }
            throw new NoSuchElementException();
        }

        public Object previous() {
            if (this.currentNode.siblings != null && this.currentNode.siblings[0] != null) {
                --this.currentIndex;
                this.currentNode = this.currentNode.siblings[0];
                this.flags |= 3;
                return this.currentNode;
            }
            throw new NoSuchElementException();
        }

        public void set(Object object) {
            if ((this.flags & 1) == 1) {
                FONode fONode = (FONode)object;
                if (this.currentNode == this.parentNode.firstChild) {
                    this.parentNode.firstChild = fONode;
                } else {
                    FONode.attachSiblings(this.currentNode.siblings[0], fONode);
                }
                if (this.currentNode.siblings != null && this.currentNode.siblings[1] != null) {
                    FONode.attachSiblings(fONode, this.currentNode.siblings[1]);
                }
                if (this.currentNode == this.parentNode.lastChild) {
                    this.parentNode.lastChild = fONode;
                }
            } else {
                throw new IllegalStateException();
            }
        }

        public void add(Object object) {
            FONode fONode = (FONode)object;
            if (this.currentIndex == -1) {
                if (this.currentNode != null) {
                    FONode.attachSiblings(fONode, this.currentNode);
                }
                this.parentNode.firstChild = fONode;
                this.currentIndex = 0;
                this.currentNode = fONode;
                if (this.parentNode.lastChild == null) {
                    this.parentNode.lastChild = fONode;
                }
            } else {
                if (this.currentNode.siblings != null && this.currentNode.siblings[1] != null) {
                    FONode.attachSiblings((FONode)object, this.currentNode.siblings[1]);
                }
                FONode.attachSiblings(this.currentNode, (FONode)object);
                if (this.currentNode == this.parentNode.lastChild) {
                    this.parentNode.lastChild = fONode;
                }
            }
            this.flags &= 0;
        }

        public boolean hasNext() {
            return this.currentNode != null && (this.currentIndex == 0 || this.currentNode.siblings != null && this.currentNode.siblings[1] != null);
        }

        public boolean hasPrevious() {
            return this.currentIndex != 0 || this.currentNode.siblings != null && this.currentNode.siblings[0] != null;
        }

        public int nextIndex() {
            return this.currentIndex + 1;
        }

        public int previousIndex() {
            return this.currentIndex - 1;
        }

        public void remove() {
            if ((this.flags & 2) == 2) {
                this.parentNode.removeChild(this.currentNode);
                if (this.currentIndex == 0) {
                    this.currentNode = this.parentNode.firstChild;
                } else if (this.currentNode.siblings != null && this.currentNode.siblings[0] != null) {
                    this.currentNode = this.currentNode.siblings[0];
                    --this.currentIndex;
                } else {
                    this.currentNode = null;
                }
                this.flags &= 0;
            } else {
                throw new IllegalStateException();
            }
        }

        public FONode lastNode() {
            while (this.currentNode != null && this.currentNode.siblings != null && this.currentNode.siblings[1] != null) {
                this.currentNode = this.currentNode.siblings[1];
                ++this.currentIndex;
            }
            return this.currentNode;
        }

        public FONode firstNode() {
            this.currentNode = this.parentNode.firstChild;
            this.currentIndex = 0;
            return this.currentNode;
        }

        public FONode nextNode() {
            return (FONode)this.next();
        }

        public FONode previousNode() {
            return (FONode)this.previous();
        }
    }
}

