/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.apps.FopFactory;
import org.apache.fop.fo.ElementMapping;
import org.apache.fop.fo.FOPropertyMapping;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.ValidationException;
import org.apache.fop.fo.expr.PropertyException;
import org.apache.fop.fo.properties.CommonAbsolutePosition;
import org.apache.fop.fo.properties.CommonAural;
import org.apache.fop.fo.properties.CommonBorderPaddingBackground;
import org.apache.fop.fo.properties.CommonFont;
import org.apache.fop.fo.properties.CommonHyphenation;
import org.apache.fop.fo.properties.CommonMarginBlock;
import org.apache.fop.fo.properties.CommonMarginInline;
import org.apache.fop.fo.properties.CommonRelativePosition;
import org.apache.fop.fo.properties.CommonTextDecoration;
import org.apache.fop.fo.properties.Property;
import org.apache.fop.fo.properties.PropertyMaker;
import org.apache.xmlgraphics.util.QName;
import org.xml.sax.Attributes;

public abstract class PropertyList {
    private static boolean[] inheritableProperty;
    protected PropertyList parentPropertyList = null;
    private FObj fobj = null;
    private static Log log;

    public PropertyList(FObj fObj, PropertyList propertyList) {
        this.fobj = fObj;
        this.parentPropertyList = propertyList;
    }

    public FObj getFObj() {
        return this.fobj;
    }

    public FObj getParentFObj() {
        if (this.parentPropertyList != null) {
            return this.parentPropertyList.getFObj();
        }
        return null;
    }

    public PropertyList getParentPropertyList() {
        return this.parentPropertyList;
    }

    public Property getExplicitOrShorthand(int n) throws PropertyException {
        Property property = this.getExplicit(n);
        if (property == null) {
            property = this.getShorthand(n);
        }
        return property;
    }

    public abstract Property getExplicit(int var1);

    public abstract void putExplicit(int var1, Property var2);

    public Property getInherited(int n) throws PropertyException {
        if (this.isInherited(n)) {
            return this.getFromParent(n);
        }
        return this.makeProperty(n);
    }

    public Property get(int n) throws PropertyException {
        return this.get(n, true, true);
    }

    public Property get(int n, boolean bl, boolean bl2) throws PropertyException {
        PropertyMaker propertyMaker = this.findMaker(n & 0x1FF);
        if (propertyMaker != null) {
            return propertyMaker.get(n & 0xFFFFFE00, this, bl, bl2);
        }
        return null;
    }

    public Property getNearestSpecified(int n) throws PropertyException {
        Property property = null;
        PropertyList propertyList = this.parentPropertyList;
        while (propertyList != null) {
            property = propertyList.getExplicit(n);
            if (property != null) {
                return property;
            }
            propertyList = propertyList.parentPropertyList;
        }
        return this.makeProperty(n);
    }

    public Property getFromParent(int n) throws PropertyException {
        if (this.parentPropertyList != null) {
            return this.parentPropertyList.get(n);
        }
        return this.makeProperty(n);
    }

    public int selectFromWritingMode(int n, int n2, int n3, int n4) {
        int n5;
        try {
            switch (this.get(267).getEnum()) {
                case 79: {
                    n5 = n;
                    break;
                }
                case 121: {
                    n5 = n2;
                    break;
                }
                case 140: {
                    n5 = n3;
                    break;
                }
                case 205: {
                    n5 = n4;
                    break;
                }
                default: {
                    n5 = -1;
                    break;
                }
            }
        }
        catch (PropertyException propertyException) {
            n5 = -1;
        }
        return n5;
    }

    private String addAttributeToList(Attributes attributes, String string) throws ValidationException {
        String string2 = attributes.getValue(string);
        if (string2 != null) {
            this.convertAttributeToProperty(attributes, string, string2);
        }
        return string2;
    }

    public void addAttributesToList(Attributes attributes) throws ValidationException {
        this.addAttributeToList(attributes, "writing-mode");
        this.addAttributeToList(attributes, "column-number");
        this.addAttributeToList(attributes, "number-columns-spanned");
        String string = this.addAttributeToList(attributes, "font");
        if (string == null || "".equals(string)) {
            this.addAttributeToList(attributes, "font-size");
        }
        FopFactory fopFactory = this.getFObj().getUserAgent().getFactory();
        for (int i = 0; i < attributes.getLength(); ++i) {
            String string2 = attributes.getURI(i);
            String string3 = attributes.getQName(i);
            String string4 = attributes.getValue(i);
            if (string2 == null || string2.length() == 0 || "xml:lang".equals(string3) || "xml:base".equals(string3)) {
                this.convertAttributeToProperty(attributes, string3, string4);
                continue;
            }
            if (fopFactory.isNamespaceIgnored(string2)) continue;
            ElementMapping elementMapping = fopFactory.getElementMappingRegistry().getElementMapping(string2);
            QName qName = new QName(string2, string3);
            if (elementMapping != null) {
                if (elementMapping.isAttributeProperty(qName) && elementMapping.getStandardPrefix() != null) {
                    this.convertAttributeToProperty(attributes, elementMapping.getStandardPrefix() + ":" + qName.getLocalName(), string4);
                    continue;
                }
                this.getFObj().addForeignAttribute(qName, string4);
                continue;
            }
            this.handleInvalidProperty(qName);
        }
    }

    protected boolean isValidPropertyName(String string) {
        int n = FOPropertyMapping.getPropertyId(PropertyList.findBasePropertyName(string));
        int n2 = FOPropertyMapping.getSubPropertyId(PropertyList.findSubPropertyName(string));
        return n != -1 && (n2 != -1 || PropertyList.findSubPropertyName(string) == null);
    }

    private void convertAttributeToProperty(Attributes attributes, String string, String string2) throws ValidationException {
        if (string.startsWith("xmlns:") || "xmlns".equals(string)) {
            return;
        }
        if (string2 != null) {
            String string3 = PropertyList.findBasePropertyName(string);
            String string4 = PropertyList.findSubPropertyName(string);
            int n = FOPropertyMapping.getPropertyId(string3);
            int n2 = FOPropertyMapping.getSubPropertyId(string4);
            if (n == -1 || n2 == -1 && string4 != null) {
                this.handleInvalidProperty(new QName(null, string));
            }
            FObj fObj = this.fobj.findNearestAncestorFObj();
            PropertyMaker propertyMaker = this.findMaker(n);
            if (propertyMaker == null) {
                log.warn((Object)("No PropertyMaker registered for " + string + ". Ignoring property."));
                return;
            }
            try {
                Property property = null;
                if (string4 == null) {
                    if (this.getExplicit(n) != null) {
                        return;
                    }
                    property = propertyMaker.make(this, string2, fObj);
                } else {
                    Property property2 = this.findBaseProperty(attributes, fObj, n, string3, propertyMaker);
                    property = propertyMaker.make(property2, n2, this, string2, fObj);
                }
                if (property != null) {
                    this.putExplicit(n, property);
                }
            }
            catch (PropertyException propertyException) {
                this.fobj.getFOValidationEventProducer().invalidPropertyValue(this, this.fobj.getName(), string, string2, propertyException, this.fobj.locator);
            }
        }
    }

    private Property findBaseProperty(Attributes attributes, FObj fObj, int n, String string, PropertyMaker propertyMaker) throws PropertyException {
        Property property = this.getExplicit(n);
        if (property != null) {
            return property;
        }
        String string2 = attributes.getValue(string);
        if (string2 != null && propertyMaker != null) {
            property = propertyMaker.make(this, string2, fObj);
            return property;
        }
        return null;
    }

    protected void handleInvalidProperty(QName qName) throws ValidationException {
        if (!qName.getQName().startsWith("xmlns")) {
            this.fobj.getFOValidationEventProducer().invalidProperty(this, this.fobj.getName(), qName, true, this.fobj.locator);
        }
    }

    protected static String findBasePropertyName(String string) {
        int n = string.indexOf(46);
        String string2 = string;
        if (n > -1) {
            string2 = string.substring(0, n);
        }
        return string2;
    }

    protected static String findSubPropertyName(String string) {
        int n = string.indexOf(46);
        String string2 = null;
        if (n > -1) {
            string2 = string.substring(n + 1);
        }
        return string2;
    }

    private Property getShorthand(int n) throws PropertyException {
        PropertyMaker propertyMaker = this.findMaker(n);
        if (propertyMaker != null) {
            return propertyMaker.getShorthand(this);
        }
        return null;
    }

    private Property makeProperty(int n) throws PropertyException {
        PropertyMaker propertyMaker = this.findMaker(n);
        if (propertyMaker != null) {
            return propertyMaker.make(this);
        }
        return null;
    }

    private boolean isInherited(int n) {
        if (inheritableProperty == null) {
            inheritableProperty = new boolean[277];
            PropertyMaker propertyMaker = null;
            for (int i = 1; i <= 276; ++i) {
                propertyMaker = this.findMaker(i);
                PropertyList.inheritableProperty[i] = propertyMaker != null && propertyMaker.isInherited();
            }
        }
        return inheritableProperty[n];
    }

    private PropertyMaker findMaker(int n) {
        if (n < 1 || n > 276) {
            return null;
        }
        return FObj.getPropertyMakerFor(n);
    }

    public CommonBorderPaddingBackground getBorderPaddingBackgroundProps() throws PropertyException {
        return CommonBorderPaddingBackground.getInstance(this);
    }

    public CommonHyphenation getHyphenationProps() throws PropertyException {
        return CommonHyphenation.getInstance(this);
    }

    public CommonMarginBlock getMarginBlockProps() throws PropertyException {
        return new CommonMarginBlock(this);
    }

    public CommonMarginInline getMarginInlineProps() throws PropertyException {
        return new CommonMarginInline(this);
    }

    public CommonAural getAuralProps() throws PropertyException {
        CommonAural commonAural = new CommonAural(this);
        return commonAural;
    }

    public CommonRelativePosition getRelativePositionProps() throws PropertyException {
        return new CommonRelativePosition(this);
    }

    public CommonAbsolutePosition getAbsolutePositionProps() throws PropertyException {
        return new CommonAbsolutePosition(this);
    }

    public CommonFont getFontProps() throws PropertyException {
        return CommonFont.getInstance(this);
    }

    public CommonTextDecoration getTextDecorationProps() throws PropertyException {
        return CommonTextDecoration.createFromPropertyList(this);
    }

    static {
        log = LogFactory.getLog(PropertyList.class);
    }
}

