/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.apache.fop.fo.CharIterator;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObjMixed;
import org.apache.fop.fo.RecursiveCharIterator;
import org.apache.fop.fo.flow.Block;
import org.apache.fop.util.CharUtilities;

public class XMLWhiteSpaceHandler {
    private boolean inWhiteSpace = false;
    private boolean afterLinefeed = true;
    private int nonWhiteSpaceCount;
    private int linefeedTreatment;
    private int whiteSpaceTreatment;
    private int whiteSpaceCollapse;
    private boolean endOfBlock;
    private boolean nextChildIsBlockLevel;
    private RecursiveCharIterator charIter;
    private List pendingInlines;
    private Stack nestedBlockStack = new Stack();
    private CharIterator firstWhiteSpaceInSeq;

    public void handleWhiteSpace(FObjMixed fObjMixed, FONode fONode, FONode fONode2) {
        int n;
        Block block = null;
        int n2 = fObjMixed.getNameId();
        switch (n2) {
            case 3: {
                block = (Block)fObjMixed;
                if (this.nestedBlockStack.empty() || fObjMixed != this.nestedBlockStack.peek()) {
                    if (fONode2 == null) break;
                    this.nestedBlockStack.push(block);
                    break;
                }
                if (fONode2 != null) break;
                this.nestedBlockStack.pop();
                break;
            }
            case 64: {
                FONode fONode3 = fObjMixed;
                while ((fONode3 = fONode3.getParent()).getNameId() != 3 && fONode3.getNameId() != 70) {
                }
                if (fONode3.getNameId() != 3) break;
                block = (Block)fONode3;
                this.nestedBlockStack.push(block);
                break;
            }
            default: {
                if (this.nestedBlockStack.empty()) break;
                block = (Block)this.nestedBlockStack.peek();
            }
        }
        if (block != null) {
            this.linefeedTreatment = block.getLinefeedTreatment();
            this.whiteSpaceCollapse = block.getWhitespaceCollapse();
            this.whiteSpaceTreatment = block.getWhitespaceTreatment();
        } else {
            this.linefeedTreatment = 147;
            this.whiteSpaceCollapse = 149;
            this.whiteSpaceTreatment = 63;
        }
        boolean bl = this.endOfBlock = fONode2 == null && fObjMixed == block;
        if (fONode == null) {
            this.afterLinefeed = fObjMixed == block && fObjMixed.firstChild == null;
            this.nonWhiteSpaceCount = 0;
            if (this.endOfBlock) {
                this.handlePendingInlines();
            }
            return;
        }
        this.charIter = new RecursiveCharIterator(fObjMixed, fONode);
        this.inWhiteSpace = false;
        if (fObjMixed == block || block == null || n2 == 64 && fObjMixed.getParent() == block) {
            if (fONode == fObjMixed.firstChild) {
                this.afterLinefeed = true;
            } else {
                int n3 = fONode.siblings[0].getNameId();
                boolean bl2 = this.afterLinefeed = n3 == 3 || n3 == 72 || n3 == 71 || n3 == 40 || n3 == 4;
            }
        }
        if (n2 == 81) {
            FONode fONode4 = fObjMixed.parent;
            int n4 = fONode4.getNameId();
            while (n4 == 81) {
                fONode4 = fONode4.parent;
                n4 = fONode4.getNameId();
            }
            if (n4 == 16 || n4 == 70 || n4 == 4 || n4 == 75) {
                boolean bl3 = this.endOfBlock = fONode2 == null;
            }
        }
        this.nextChildIsBlockLevel = fONode2 != null ? (n = fONode2.getNameId()) == 3 || n == 72 || n == 71 || n == 40 || n == 4 : false;
        this.handleWhiteSpace();
        if (fObjMixed == block && (this.endOfBlock || this.nextChildIsBlockLevel)) {
            this.handlePendingInlines();
        }
        if (fONode2 == null) {
            if (fObjMixed != block) {
                if (this.nonWhiteSpaceCount > 0 && this.pendingInlines != null) {
                    this.pendingInlines.clear();
                }
                if (this.inWhiteSpace) {
                    this.addPendingInline(fObjMixed);
                }
            } else {
                if (!this.nestedBlockStack.empty()) {
                    this.nestedBlockStack.pop();
                }
                this.charIter = null;
                this.firstWhiteSpaceInSeq = null;
            }
        }
    }

    protected final void reset() {
        if (this.pendingInlines != null) {
            this.pendingInlines.clear();
        }
        this.nestedBlockStack.clear();
        this.charIter = null;
        this.firstWhiteSpaceInSeq = null;
    }

    public void handleWhiteSpace(FObjMixed fObjMixed, FONode fONode) {
        this.handleWhiteSpace(fObjMixed, fONode, null);
    }

    private void handleWhiteSpace() {
        EOLchecker eOLchecker = new EOLchecker(this.charIter);
        this.nonWhiteSpaceCount = 0;
        block16: while (this.charIter.hasNext()) {
            int n;
            int n2;
            if (!this.inWhiteSpace) {
                this.firstWhiteSpaceInSeq = this.charIter.mark();
            }
            if ((n2 = CharUtilities.classOf(n = this.charIter.nextChar())) == 1 && this.linefeedTreatment == 147) {
                n = 32;
                this.charIter.replaceChar(' ');
                n2 = CharUtilities.classOf(n);
            }
            block0 : switch (CharUtilities.classOf(n)) {
                case 4: {
                    if (this.inWhiteSpace && this.whiteSpaceCollapse == 149) {
                        this.charIter.remove();
                        break;
                    }
                    boolean bl = false;
                    switch (this.whiteSpaceTreatment) {
                        case 60: {
                            bl = true;
                            break;
                        }
                        case 62: {
                            bl = eOLchecker.beforeLinefeed();
                            break;
                        }
                        case 63: {
                            bl = this.afterLinefeed || eOLchecker.beforeLinefeed();
                            break;
                        }
                        case 61: {
                            bl = this.afterLinefeed;
                            break;
                        }
                        case 108: {
                            break;
                        }
                    }
                    if (bl) {
                        this.charIter.remove();
                        break;
                    }
                    this.inWhiteSpace = true;
                    if (n == 32) continue block16;
                    this.charIter.replaceChar(' ');
                    break;
                }
                case 1: {
                    switch (this.linefeedTreatment) {
                        case 60: {
                            this.charIter.remove();
                            break block0;
                        }
                        case 148: {
                            this.charIter.replaceChar('\u200b');
                            this.inWhiteSpace = false;
                            break block0;
                        }
                        case 108: {
                            eOLchecker.reset();
                            this.inWhiteSpace = false;
                            this.afterLinefeed = true;
                            break block0;
                        }
                    }
                    break;
                }
                default: {
                    this.inWhiteSpace = false;
                    this.afterLinefeed = false;
                    ++this.nonWhiteSpaceCount;
                    eOLchecker.reset();
                }
            }
        }
    }

    private void addPendingInline(FObjMixed fObjMixed) {
        if (this.pendingInlines == null) {
            this.pendingInlines = new ArrayList(5);
        }
        this.pendingInlines.add(new PendingInline(fObjMixed, this.firstWhiteSpaceInSeq));
    }

    private void handlePendingInlines() {
        if (this.pendingInlines != null && !this.pendingInlines.isEmpty()) {
            if (this.nonWhiteSpaceCount == 0) {
                int n = this.pendingInlines.size();
                while (--n >= 0) {
                    PendingInline pendingInline = (PendingInline)this.pendingInlines.get(n);
                    this.charIter = (RecursiveCharIterator)pendingInline.firstTrailingWhiteSpace;
                    this.handleWhiteSpace();
                    this.pendingInlines.remove(pendingInline);
                }
            } else {
                this.pendingInlines.clear();
            }
        }
    }

    private class PendingInline {
        protected FObjMixed fo;
        protected CharIterator firstTrailingWhiteSpace;

        PendingInline(FObjMixed fObjMixed, CharIterator charIterator) {
            this.fo = fObjMixed;
            this.firstTrailingWhiteSpace = charIterator;
        }
    }

    private class EOLchecker {
        private boolean nextIsEOL = false;
        private RecursiveCharIterator charIter;

        EOLchecker(CharIterator charIterator) {
            this.charIter = (RecursiveCharIterator)charIterator;
        }

        boolean beforeLinefeed() {
            if (!this.nextIsEOL) {
                CharIterator charIterator = this.charIter.mark();
                while (charIterator.hasNext()) {
                    int n = CharUtilities.classOf(charIterator.nextChar());
                    if (n == 1) {
                        if (XMLWhiteSpaceHandler.this.linefeedTreatment != 108) continue;
                        this.nextIsEOL = true;
                        return this.nextIsEOL;
                    }
                    if (n == 4) continue;
                    return this.nextIsEOL;
                }
                this.nextIsEOL = XMLWhiteSpaceHandler.this.nextChildIsBlockLevel || XMLWhiteSpaceHandler.this.endOfBlock;
            }
            return this.nextIsEOL;
        }

        void reset() {
            this.nextIsEOL = false;
        }
    }
}

