/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.expr;

import org.apache.fop.datatypes.Numeric;
import org.apache.fop.datatypes.PercentBaseContext;
import org.apache.fop.fo.expr.NumericProperty;
import org.apache.fop.fo.expr.PropertyException;
import org.apache.fop.fo.expr.RelativeNumericProperty;

public final class NumericOp {
    private NumericOp() {
    }

    public static Numeric addition(Numeric numeric, Numeric numeric2) throws PropertyException {
        if (numeric.isAbsolute() && numeric2.isAbsolute()) {
            return NumericOp.addition2(numeric, numeric2, null);
        }
        return new RelativeNumericProperty(1, numeric, numeric2);
    }

    public static Numeric addition2(Numeric numeric, Numeric numeric2, PercentBaseContext percentBaseContext) throws PropertyException {
        if (numeric.getDimension() != numeric2.getDimension()) {
            throw new PropertyException("Can't subtract Numerics of different dimensions");
        }
        return NumericOp.numeric(numeric.getNumericValue(percentBaseContext) + numeric2.getNumericValue(percentBaseContext), numeric.getDimension());
    }

    public static Numeric subtraction(Numeric numeric, Numeric numeric2) throws PropertyException {
        if (numeric.isAbsolute() && numeric2.isAbsolute()) {
            return NumericOp.subtraction2(numeric, numeric2, null);
        }
        return new RelativeNumericProperty(2, numeric, numeric2);
    }

    public static Numeric subtraction2(Numeric numeric, Numeric numeric2, PercentBaseContext percentBaseContext) throws PropertyException {
        if (numeric.getDimension() != numeric2.getDimension()) {
            throw new PropertyException("Can't subtract Numerics of different dimensions");
        }
        return NumericOp.numeric(numeric.getNumericValue(percentBaseContext) - numeric2.getNumericValue(percentBaseContext), numeric.getDimension());
    }

    public static Numeric multiply(Numeric numeric, Numeric numeric2) throws PropertyException {
        if (numeric.isAbsolute() && numeric2.isAbsolute()) {
            return NumericOp.multiply2(numeric, numeric2, null);
        }
        return new RelativeNumericProperty(3, numeric, numeric2);
    }

    public static Numeric multiply2(Numeric numeric, Numeric numeric2, PercentBaseContext percentBaseContext) throws PropertyException {
        return NumericOp.numeric(numeric.getNumericValue(percentBaseContext) * numeric2.getNumericValue(percentBaseContext), numeric.getDimension() + numeric2.getDimension());
    }

    public static Numeric divide(Numeric numeric, Numeric numeric2) throws PropertyException {
        if (numeric.isAbsolute() && numeric2.isAbsolute()) {
            return NumericOp.divide2(numeric, numeric2, null);
        }
        return new RelativeNumericProperty(4, numeric, numeric2);
    }

    public static Numeric divide2(Numeric numeric, Numeric numeric2, PercentBaseContext percentBaseContext) throws PropertyException {
        return NumericOp.numeric(numeric.getNumericValue(percentBaseContext) / numeric2.getNumericValue(percentBaseContext), numeric.getDimension() - numeric2.getDimension());
    }

    public static Numeric modulo(Numeric numeric, Numeric numeric2) throws PropertyException {
        if (numeric.isAbsolute() && numeric2.isAbsolute()) {
            return NumericOp.modulo2(numeric, numeric2, null);
        }
        return new RelativeNumericProperty(5, numeric, numeric2);
    }

    public static Numeric modulo2(Numeric numeric, Numeric numeric2, PercentBaseContext percentBaseContext) throws PropertyException {
        return NumericOp.numeric(numeric.getNumericValue(percentBaseContext) % numeric2.getNumericValue(percentBaseContext), numeric.getDimension());
    }

    public static Numeric abs(Numeric numeric) throws PropertyException {
        if (numeric.isAbsolute()) {
            return NumericOp.abs2(numeric, null);
        }
        return new RelativeNumericProperty(7, numeric);
    }

    public static Numeric abs2(Numeric numeric, PercentBaseContext percentBaseContext) throws PropertyException {
        return NumericOp.numeric(Math.abs(numeric.getNumericValue(percentBaseContext)), numeric.getDimension());
    }

    public static Numeric negate(Numeric numeric) throws PropertyException {
        if (numeric.isAbsolute()) {
            return NumericOp.negate2(numeric, null);
        }
        return new RelativeNumericProperty(6, numeric);
    }

    public static Numeric negate2(Numeric numeric, PercentBaseContext percentBaseContext) throws PropertyException {
        return NumericOp.numeric(-numeric.getNumericValue(percentBaseContext), numeric.getDimension());
    }

    public static Numeric max(Numeric numeric, Numeric numeric2) throws PropertyException {
        if (numeric.isAbsolute() && numeric2.isAbsolute()) {
            return NumericOp.max2(numeric, numeric2, null);
        }
        return new RelativeNumericProperty(8, numeric, numeric2);
    }

    public static Numeric max2(Numeric numeric, Numeric numeric2, PercentBaseContext percentBaseContext) throws PropertyException {
        if (numeric.getDimension() != numeric2.getDimension()) {
            throw new PropertyException("Arguments to max() must have same dimensions");
        }
        return numeric.getNumericValue(percentBaseContext) > numeric2.getNumericValue(percentBaseContext) ? numeric : numeric2;
    }

    public static Numeric min(Numeric numeric, Numeric numeric2) throws PropertyException {
        if (numeric.isAbsolute() && numeric2.isAbsolute()) {
            return NumericOp.min2(numeric, numeric2, null);
        }
        return new RelativeNumericProperty(9, numeric, numeric2);
    }

    public static Numeric min2(Numeric numeric, Numeric numeric2, PercentBaseContext percentBaseContext) throws PropertyException {
        if (numeric.getDimension() != numeric2.getDimension()) {
            throw new PropertyException("Arguments to min() must have same dimensions");
        }
        return numeric.getNumericValue(percentBaseContext) <= numeric2.getNumericValue(percentBaseContext) ? numeric : numeric2;
    }

    private static Numeric numeric(double d, int n) {
        return new NumericProperty(d, n);
    }
}

