/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.expr;

import org.apache.fop.datatypes.PercentBase;
import org.apache.fop.datatypes.PercentBaseContext;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.expr.FunctionBase;
import org.apache.fop.fo.expr.PropertyException;
import org.apache.fop.fo.expr.PropertyInfo;
import org.apache.fop.fo.flow.table.Table;
import org.apache.fop.fo.properties.Property;
import org.apache.fop.fo.properties.TableColLength;

public class ProportionalColumnWidthFunction
extends FunctionBase {
    public int getRequiredArgsCount() {
        return 1;
    }

    public PercentBase getPercentBase() {
        return new ProportionalColumnWidthPercentBase();
    }

    public Property eval(Property[] propertyArray, PropertyInfo propertyInfo) throws PropertyException {
        Number number = propertyArray[0].getNumber();
        if (number == null) {
            throw new PropertyException("Non numeric operand to proportional-column-width() function.");
        }
        PropertyList propertyList = propertyInfo.getPropertyList();
        if (!"fo:table-column".equals(propertyList.getFObj().getName())) {
            throw new PropertyException("proportional-column-width() function may only be used on fo:table-column.");
        }
        Table table = (Table)propertyList.getParentFObj();
        if (table.isAutoLayout()) {
            throw new PropertyException("proportional-column-width() function may only be used when fo:table has table-layout=\"fixed\".");
        }
        return new TableColLength(number.doubleValue(), propertyInfo.getFO());
    }

    private static class ProportionalColumnWidthPercentBase
    implements PercentBase {
        private ProportionalColumnWidthPercentBase() {
        }

        public int getBaseLength(PercentBaseContext percentBaseContext) throws PropertyException {
            return 0;
        }

        public double getBaseValue() {
            return 1.0;
        }

        public int getDimension() {
            return 0;
        }
    }
}

