/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.expr;

import org.apache.fop.datatypes.PercentBase;
import org.apache.fop.datatypes.PercentBaseContext;
import org.apache.fop.fo.expr.FunctionBase;
import org.apache.fop.fo.expr.PropertyException;
import org.apache.fop.fo.expr.PropertyInfo;
import org.apache.fop.fo.expr.RGBColorFunction;
import org.apache.fop.fo.pagination.ColorProfile;
import org.apache.fop.fo.pagination.Declarations;
import org.apache.fop.fo.properties.ColorProperty;
import org.apache.fop.fo.properties.Property;
import org.apache.fop.util.ColorUtil;

class RGBICCColorFunction
extends FunctionBase {
    RGBICCColorFunction() {
    }

    public int getRequiredArgsCount() {
        return 4;
    }

    public boolean hasVariableArgs() {
        return true;
    }

    public PercentBase getPercentBase() {
        return new ICCPercentBase();
    }

    public Property eval(Property[] propertyArray, PropertyInfo propertyInfo) throws PropertyException {
        String string = propertyArray[3].getString();
        Declarations declarations = propertyInfo.getFO() != null ? propertyInfo.getFO().getRoot().getDeclarations() : null;
        ColorProfile colorProfile = null;
        if (declarations == null) {
            if (!ColorUtil.isPseudoProfile(string)) {
                Property[] propertyArray2 = new Property[3];
                System.arraycopy(propertyArray, 0, propertyArray2, 0, 3);
                return new RGBColorFunction().eval(propertyArray2, propertyInfo);
            }
        } else {
            colorProfile = declarations.getColorProfile(string);
            if (colorProfile == null && !ColorUtil.isPseudoProfile(string)) {
                PropertyException propertyException = new PropertyException("The " + string + " color profile was not declared");
                propertyException.setPropertyInfo(propertyInfo);
                throw propertyException;
            }
        }
        String string2 = colorProfile != null ? colorProfile.getSrc() : "";
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        f = propertyArray[0].getNumber().floatValue();
        f2 = propertyArray[1].getNumber().floatValue();
        f3 = propertyArray[2].getNumber().floatValue();
        if (f < 0.0f || f > 255.0f || f2 < 0.0f || f2 > 255.0f || f3 < 0.0f || f3 > 255.0f) {
            throw new PropertyException("Color values out of range. Arguments to rgb-icc() must be [0..255] or [0%..100%]");
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("fop-rgb-icc(");
        stringBuffer.append(f / 255.0f);
        stringBuffer.append(',').append(f2 / 255.0f);
        stringBuffer.append(',').append(f3 / 255.0f);
        for (int i = 3; i < propertyArray.length; ++i) {
            if (i == 3) {
                stringBuffer.append(',').append(string);
                stringBuffer.append(',').append(string2);
                continue;
            }
            stringBuffer.append(',').append(propertyArray[i]);
        }
        stringBuffer.append(")");
        return ColorProperty.getInstance(propertyInfo.getUserAgent(), stringBuffer.toString());
    }

    private static final class ICCPercentBase
    implements PercentBase {
        private ICCPercentBase() {
        }

        public int getBaseLength(PercentBaseContext percentBaseContext) throws PropertyException {
            return 0;
        }

        public double getBaseValue() {
            return 255.0;
        }

        public int getDimension() {
            return 0;
        }
    }
}

