/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import java.util.Stack;
import org.apache.fop.apps.FOPException;
import org.apache.fop.complexscripts.bidi.DelimitedTextRange;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.flow.Inline;
import org.apache.fop.fo.properties.Property;

public class BidiOverride
extends Inline {
    private Property letterSpacing;
    private Property wordSpacing;
    private int direction;
    private int unicodeBidi;

    public BidiOverride(FONode fONode) {
        super(fONode);
    }

    public void bind(PropertyList propertyList) throws FOPException {
        super.bind(propertyList);
        this.letterSpacing = propertyList.get(141);
        this.wordSpacing = propertyList.get(265);
        this.direction = propertyList.get(86).getEnum();
        this.unicodeBidi = propertyList.get(255).getEnum();
    }

    public Property getLetterSpacing() {
        return this.letterSpacing;
    }

    public Property getWordSpacing() {
        return this.wordSpacing;
    }

    public int getDirection() {
        return this.direction;
    }

    public int getUnicodeBidi() {
        return this.unicodeBidi;
    }

    public String getLocalName() {
        return "bidi-override";
    }

    public int getNameId() {
        return 2;
    }

    protected Stack collectDelimitedTextRanges(Stack stack, DelimitedTextRange delimitedTextRange) {
        char c = '\u0000';
        char c2 = '\u0000';
        int n = this.getUnicodeBidi();
        int n2 = this.getDirection();
        if (n == 15) {
            c = n2 == 122 ? (char)'\u202e' : '\u202d';
            c2 = '\u202c';
        } else if (n == 38) {
            c = n2 == 122 ? (char)'\u202b' : '\u202a';
            c2 = '\u202c';
        }
        if (delimitedTextRange != null) {
            if (c != '\u0000') {
                delimitedTextRange.append(c, (FONode)this);
            }
            FONode.FONodeIterator fONodeIterator = this.getChildNodes();
            while (fONodeIterator != null && fONodeIterator.hasNext()) {
                stack = ((FONode)fONodeIterator.next()).collectDelimitedTextRanges(stack);
            }
            if (c2 != '\u0000') {
                delimitedTextRange.append(c2, (FONode)this);
            }
        }
        return stack;
    }
}

