/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.fop.ResourceEventProducer;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.datatypes.Length;
import org.apache.fop.datatypes.URISpecification;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.ValidationException;
import org.apache.fop.fo.flow.AbstractGraphics;
import org.apache.fop.fo.properties.FixedLength;
import org.apache.xmlgraphics.image.loader.ImageException;
import org.apache.xmlgraphics.image.loader.ImageInfo;
import org.apache.xmlgraphics.image.loader.ImageManager;
import org.xml.sax.Locator;

public class ExternalGraphic
extends AbstractGraphics {
    private String src;
    private String url;
    private int intrinsicWidth;
    private int intrinsicHeight;
    private Length intrinsicAlignmentAdjust;

    public ExternalGraphic(FONode fONode) {
        super(fONode);
    }

    public void bind(PropertyList propertyList) throws FOPException {
        super.bind(propertyList);
        this.src = propertyList.get(232).getString();
        this.url = URISpecification.getURL(this.src);
        FOUserAgent fOUserAgent = this.getUserAgent();
        ImageManager imageManager = fOUserAgent.getFactory().getImageManager();
        ImageInfo imageInfo = null;
        try {
            imageInfo = imageManager.getImageInfo(this.url, fOUserAgent.getImageSessionContext());
        }
        catch (ImageException imageException) {
            ResourceEventProducer resourceEventProducer = ResourceEventProducer.Provider.get(this.getUserAgent().getEventBroadcaster());
            resourceEventProducer.imageError(this, this.url, imageException, this.getLocator());
        }
        catch (FileNotFoundException fileNotFoundException) {
            ResourceEventProducer resourceEventProducer = ResourceEventProducer.Provider.get(this.getUserAgent().getEventBroadcaster());
            resourceEventProducer.imageNotFound(this, this.url, fileNotFoundException, this.getLocator());
        }
        catch (IOException iOException) {
            ResourceEventProducer resourceEventProducer = ResourceEventProducer.Provider.get(this.getUserAgent().getEventBroadcaster());
            resourceEventProducer.imageIOError(this, this.url, iOException, this.getLocator());
        }
        if (imageInfo != null) {
            this.intrinsicWidth = imageInfo.getSize().getWidthMpt();
            this.intrinsicHeight = imageInfo.getSize().getHeightMpt();
            int n = imageInfo.getSize().getBaselinePositionFromBottom();
            if (n != 0) {
                this.intrinsicAlignmentAdjust = FixedLength.getInstance(-n);
            }
        }
    }

    protected void startOfNode() throws FOPException {
        super.startOfNode();
        this.getFOEventHandler().image(this);
    }

    protected void validateChildNode(Locator locator, String string, String string2) throws ValidationException {
        if ("http://www.w3.org/1999/XSL/Format".equals(string)) {
            this.invalidChildError(locator, string, string2);
        }
    }

    public String getSrc() {
        return this.src;
    }

    public String getURL() {
        return this.url;
    }

    public String getLocalName() {
        return "external-graphic";
    }

    public int getNameId() {
        return 14;
    }

    public int getIntrinsicWidth() {
        return this.intrinsicWidth;
    }

    public int getIntrinsicHeight() {
        return this.intrinsicHeight;
    }

    public Length getIntrinsicAlignmentAdjust() {
        return this.intrinsicAlignmentAdjust;
    }
}

