/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import java.util.Stack;
import org.apache.fop.apps.FOPException;
import org.apache.fop.complexscripts.bidi.DelimitedTextRange;
import org.apache.fop.datatypes.Length;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.ValidationException;
import org.apache.fop.fo.flow.InlineLevel;
import org.apache.fop.fo.properties.LengthRangeProperty;
import org.xml.sax.Locator;

public class Leader
extends InlineLevel {
    private Length alignmentAdjust;
    private int alignmentBaseline;
    private Length baselineShift;
    private int dominantBaseline;
    private int leaderAlignment;
    private LengthRangeProperty leaderLength;
    private int leaderPattern;
    private Length leaderPatternWidth;
    private int ruleStyle;
    private Length ruleThickness;

    public Leader(FONode fONode) {
        super(fONode);
    }

    public void bind(PropertyList propertyList) throws FOPException {
        super.bind(propertyList);
        this.alignmentAdjust = propertyList.get(3).getLength();
        this.alignmentBaseline = propertyList.get(4).getEnum();
        this.baselineShift = propertyList.get(15).getLength();
        this.dominantBaseline = propertyList.get(88).getEnum();
        this.leaderAlignment = propertyList.get(136).getEnum();
        this.leaderLength = propertyList.get(137).getLengthRange();
        this.leaderPattern = propertyList.get(138).getEnum();
        this.leaderPatternWidth = propertyList.get(139).getLength();
        this.ruleThickness = Leader.getPropertyMakerFor(214).make(propertyList).getLength();
        switch (this.leaderPattern) {
            case 134: {
                break;
            }
            case 123: {
                this.ruleStyle = propertyList.get(213).getEnum();
                this.ruleThickness = propertyList.get(214).getLength();
                break;
            }
            case 35: {
                break;
            }
            case 158: {
                break;
            }
            default: {
                throw new RuntimeException("Invalid leader pattern: " + this.leaderPattern);
            }
        }
    }

    protected void validateChildNode(Locator locator, String string, String string2) throws ValidationException {
        if ("http://www.w3.org/1999/XSL/Format".equals(string) && (string2.equals("leader") || string2.equals("inline-container") || string2.equals("block-container") || string2.equals("float") || string2.equals("marker") || !this.isInlineItem(string, string2))) {
            this.invalidChildError(locator, string, string2);
        }
    }

    public int getRuleStyle() {
        return this.ruleStyle;
    }

    public Length getRuleThickness() {
        return this.ruleThickness;
    }

    public int getLeaderAlignment() {
        return this.leaderAlignment;
    }

    public LengthRangeProperty getLeaderLength() {
        return this.leaderLength;
    }

    public int getLeaderPattern() {
        return this.leaderPattern;
    }

    public Length getLeaderPatternWidth() {
        return this.leaderPatternWidth;
    }

    public Length getAlignmentAdjust() {
        return this.alignmentAdjust;
    }

    public int getAlignmentBaseline() {
        return this.alignmentBaseline;
    }

    public Length getBaselineShift() {
        return this.baselineShift;
    }

    public int getDominantBaseline() {
        return this.dominantBaseline;
    }

    public String getLocalName() {
        return "leader";
    }

    public int getNameId() {
        return 39;
    }

    protected void startOfNode() throws FOPException {
        super.startOfNode();
        this.getFOEventHandler().startLeader(this);
    }

    protected void endOfNode() throws FOPException {
        super.endOfNode();
        this.getFOEventHandler().endLeader(this);
    }

    protected Stack collectDelimitedTextRanges(Stack stack, DelimitedTextRange delimitedTextRange) {
        if (delimitedTextRange != null) {
            if (this.leaderPattern == 158) {
                stack = super.collectDelimitedTextRanges(stack, delimitedTextRange);
            } else {
                delimitedTextRange.append('\ufffc', (FONode)this);
            }
        }
        return stack;
    }
}

