/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import org.apache.fop.apps.FOPException;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FOText;
import org.apache.fop.fo.FObjMixed;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.ValidationException;
import org.apache.fop.fo.properties.CommonAccessibility;
import org.apache.fop.fo.properties.CommonAccessibilityHolder;
import org.xml.sax.Locator;

public class Wrapper
extends FObjMixed
implements CommonAccessibilityHolder {
    private boolean blockOrInlineItemFound = false;
    private CommonAccessibility commonAccessibility;

    public Wrapper(FONode fONode) {
        super(fONode);
    }

    public void bind(PropertyList propertyList) throws FOPException {
        super.bind(propertyList);
        this.commonAccessibility = CommonAccessibility.getInstance(propertyList);
    }

    protected void startOfNode() throws FOPException {
        super.startOfNode();
        this.getFOEventHandler().startWrapper(this);
    }

    protected void endOfNode() throws FOPException {
        super.endOfNode();
        this.getFOEventHandler().endWrapper(this);
    }

    protected void validateChildNode(Locator locator, String string, String string2) throws ValidationException {
        if ("http://www.w3.org/1999/XSL/Format".equals(string)) {
            if ("marker".equals(string2)) {
                if (this.blockOrInlineItemFound) {
                    this.nodesOutOfOrderError(locator, "fo:marker", "(#PCDATA|%inline;|%block;)");
                }
            } else if (this.isBlockOrInlineItem(string, string2)) {
                try {
                    FONode.validateChildNode(this.parent, locator, string, string2);
                }
                catch (ValidationException validationException) {
                    this.invalidChildError(locator, this.getName(), "http://www.w3.org/1999/XSL/Format", string2, "rule.wrapperInvalidChildForParent");
                }
                this.blockOrInlineItemFound = true;
            } else {
                this.invalidChildError(locator, string, string2);
            }
        }
    }

    protected void addChildNode(FONode fONode) throws FOPException {
        super.addChildNode(fONode);
        if (fONode instanceof FOText && ((FOText)fONode).willCreateArea()) {
            FONode fONode2 = this.parent;
            while (fONode2.getNameId() == 81) {
                fONode2 = fONode2.getParent();
            }
            if (!(fONode2 instanceof FObjMixed)) {
                this.invalidChildError(this.getLocator(), this.getLocalName(), "http://www.w3.org/1999/XSL/Format", "#PCDATA", "rule.wrapperInvalidChildForParent");
            }
        }
    }

    public String getLocalName() {
        return "wrapper";
    }

    public int getNameId() {
        return 81;
    }

    public CommonAccessibility getCommonAccessibility() {
        return this.commonAccessibility;
    }

    public boolean isDelimitedTextRangeBoundary(int n) {
        return false;
    }
}

