/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow.table;

import java.util.BitSet;
import java.util.List;
import org.apache.fop.fo.flow.table.PendingSpan;

public class ColumnNumberManager {
    private int columnNumber = 1;
    private BitSet usedColumnIndices = new BitSet();

    int getCurrentColumnNumber() {
        return this.columnNumber;
    }

    void signalUsedColumnNumbers(int n, int n2) {
        for (int i = n - 1; i < n2; ++i) {
            this.usedColumnIndices.set(i);
        }
        this.columnNumber = n2 + 1;
        while (this.usedColumnIndices.get(this.columnNumber - 1)) {
            ++this.columnNumber;
        }
    }

    void prepareForNextRow(List list) {
        this.usedColumnIndices.clear();
        for (int i = 0; i < list.size(); ++i) {
            PendingSpan pendingSpan = (PendingSpan)list.get(i);
            if (pendingSpan == null) continue;
            if (pendingSpan.decrRowsLeft() == 0) {
                list.set(i, null);
                continue;
            }
            this.usedColumnIndices.set(i);
        }
        this.columnNumber = 1;
        while (this.usedColumnIndices.get(this.columnNumber - 1)) {
            ++this.columnNumber;
        }
    }

    public boolean isColumnNumberUsed(int n) {
        return this.usedColumnIndices.get(n - 1);
    }
}

