/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow.table;

import org.apache.fop.fo.flow.table.BorderSpecification;
import org.apache.fop.layoutmgr.table.CollapsingBorderModel;

public class ConditionalBorder {
    public static final int NORMAL = 0;
    public static final int LEADING_TRAILING = 1;
    public static final int REST = 2;
    BorderSpecification normal;
    BorderSpecification leadingTrailing;
    BorderSpecification rest;
    private CollapsingBorderModel collapsingBorderModel;

    private ConditionalBorder(BorderSpecification borderSpecification, BorderSpecification borderSpecification2, BorderSpecification borderSpecification3, CollapsingBorderModel collapsingBorderModel) {
        assert (collapsingBorderModel != null);
        this.normal = borderSpecification;
        this.leadingTrailing = borderSpecification2;
        this.rest = borderSpecification3;
        this.collapsingBorderModel = collapsingBorderModel;
    }

    ConditionalBorder(BorderSpecification borderSpecification, CollapsingBorderModel collapsingBorderModel) {
        this(borderSpecification, borderSpecification, borderSpecification.getBorderInfo().getWidth().isDiscard() ? BorderSpecification.getDefaultBorder() : borderSpecification, collapsingBorderModel);
    }

    void resolve(ConditionalBorder conditionalBorder, boolean bl, boolean bl2, boolean bl3) {
        BorderSpecification borderSpecification;
        if (bl && (borderSpecification = this.collapsingBorderModel.determineWinner(this.normal, conditionalBorder.normal)) != null) {
            this.normal = borderSpecification;
            conditionalBorder.normal = borderSpecification;
        }
        if (bl2 && (borderSpecification = this.collapsingBorderModel.determineWinner(this.leadingTrailing, conditionalBorder.leadingTrailing)) != null) {
            this.leadingTrailing = borderSpecification;
            conditionalBorder.leadingTrailing = borderSpecification;
        }
        if (bl3 && (borderSpecification = this.collapsingBorderModel.determineWinner(this.rest, conditionalBorder.rest)) != null) {
            this.rest = borderSpecification;
            conditionalBorder.rest = borderSpecification;
        }
    }

    void integrateCompetingSegment(ConditionalBorder conditionalBorder, boolean bl, boolean bl2, boolean bl3) {
        BorderSpecification borderSpecification;
        if (bl && (borderSpecification = this.collapsingBorderModel.determineWinner(this.normal, conditionalBorder.normal)) != null) {
            this.normal = borderSpecification;
        }
        if (bl2 && (borderSpecification = this.collapsingBorderModel.determineWinner(this.leadingTrailing, conditionalBorder.leadingTrailing)) != null) {
            this.leadingTrailing = borderSpecification;
        }
        if (bl3 && (borderSpecification = this.collapsingBorderModel.determineWinner(this.rest, conditionalBorder.rest)) != null) {
            this.rest = borderSpecification;
        }
    }

    void integrateSegment(ConditionalBorder conditionalBorder, boolean bl, boolean bl2, boolean bl3) {
        if (bl) {
            this.normal = this.collapsingBorderModel.determineWinner(this.normal, conditionalBorder.normal);
            assert (this.normal != null);
        }
        if (bl2) {
            this.leadingTrailing = this.collapsingBorderModel.determineWinner(this.leadingTrailing, conditionalBorder.leadingTrailing);
            assert (this.leadingTrailing != null);
        }
        if (bl3) {
            this.rest = this.collapsingBorderModel.determineWinner(this.rest, conditionalBorder.rest);
            assert (this.rest != null);
        }
    }

    ConditionalBorder copy() {
        return new ConditionalBorder(this.normal, this.leadingTrailing, this.rest, this.collapsingBorderModel);
    }

    public String toString() {
        return "{normal: " + this.normal + ", leading: " + this.leadingTrailing + ", rest: " + this.rest + "}";
    }

    static ConditionalBorder getDefaultBorder(CollapsingBorderModel collapsingBorderModel) {
        BorderSpecification borderSpecification = BorderSpecification.getDefaultBorder();
        return new ConditionalBorder(borderSpecification, borderSpecification, borderSpecification, collapsingBorderModel);
    }
}

