/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow.table;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.fop.apps.FOPException;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.ValidationException;
import org.apache.fop.fo.flow.table.ColumnNumberManager;
import org.apache.fop.fo.flow.table.RowGroupBuilder;
import org.apache.fop.fo.flow.table.Table;
import org.apache.fop.fo.flow.table.TableCell;
import org.apache.fop.fo.flow.table.TableCellContainer;
import org.apache.fop.fo.flow.table.TableEventProducer;
import org.apache.fop.fo.flow.table.TableRow;
import org.apache.fop.fo.properties.CommonBorderPaddingBackground;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;

public abstract class TablePart
extends TableCellContainer {
    private CommonBorderPaddingBackground commonBorderPaddingBackground;
    protected boolean tableRowsFound = false;
    protected boolean tableCellsFound = false;
    private boolean firstRow = true;
    private boolean rowsStarted = false;
    private boolean lastCellEndsRow = true;
    private List rowGroups = new LinkedList();

    public TablePart(FONode fONode) {
        super(fONode);
    }

    protected Object clone() {
        TablePart tablePart = (TablePart)super.clone();
        tablePart.rowGroups = new LinkedList(this.rowGroups);
        return tablePart;
    }

    public void bind(PropertyList propertyList) throws FOPException {
        this.commonBorderPaddingBackground = propertyList.getBorderPaddingBackgroundProps();
        super.bind(propertyList);
    }

    public void processNode(String string, Locator locator, Attributes attributes, PropertyList propertyList) throws FOPException {
        super.processNode(string, locator, attributes, propertyList);
        if (!this.inMarker()) {
            Table table = this.getTable();
            if (table.hasExplicitColumns()) {
                int n = table.getNumberOfColumns();
                this.pendingSpans = new ArrayList(n);
                for (int i = 0; i < n; ++i) {
                    this.pendingSpans.add(null);
                }
            } else {
                this.pendingSpans = new ArrayList();
            }
            this.columnNumberManager = new ColumnNumberManager();
        }
    }

    public void finalizeNode() throws FOPException {
        if (!this.inMarker()) {
            this.pendingSpans = null;
            this.columnNumberManager = null;
        }
        if (!this.tableRowsFound && !this.tableCellsFound) {
            this.missingChildElementError("marker* (table-row+|table-cell+)", true);
            this.getParent().removeChild(this);
        } else {
            this.finishLastRowGroup();
        }
    }

    TablePart getTablePart() {
        return this;
    }

    protected void finishLastRowGroup() throws ValidationException {
        if (!this.inMarker()) {
            RowGroupBuilder rowGroupBuilder = this.getTable().getRowGroupBuilder();
            if (this.tableRowsFound) {
                rowGroupBuilder.endTableRow();
            } else if (!this.lastCellEndsRow) {
                rowGroupBuilder.endRow(this);
            }
            try {
                rowGroupBuilder.endTablePart();
            }
            catch (ValidationException validationException) {
                validationException.setLocator(this.locator);
                throw validationException;
            }
        }
    }

    protected void validateChildNode(Locator locator, String string, String string2) throws ValidationException {
        if ("http://www.w3.org/1999/XSL/Format".equals(string)) {
            if (string2.equals("marker")) {
                if (this.tableRowsFound || this.tableCellsFound) {
                    this.nodesOutOfOrderError(locator, "fo:marker", "(table-row+|table-cell+)");
                }
            } else if (string2.equals("table-row")) {
                this.tableRowsFound = true;
                if (this.tableCellsFound) {
                    TableEventProducer tableEventProducer = TableEventProducer.Provider.get(this.getUserAgent().getEventBroadcaster());
                    tableEventProducer.noMixRowsAndCells(this, this.getName(), this.getLocator());
                }
            } else if (string2.equals("table-cell")) {
                this.tableCellsFound = true;
                if (this.tableRowsFound) {
                    TableEventProducer tableEventProducer = TableEventProducer.Provider.get(this.getUserAgent().getEventBroadcaster());
                    tableEventProducer.noMixRowsAndCells(this, this.getName(), this.getLocator());
                }
            } else {
                this.invalidChildError(locator, string, string2);
            }
        }
    }

    protected void addChildNode(FONode fONode) throws FOPException {
        if (!this.inMarker()) {
            switch (fONode.getNameId()) {
                case 79: {
                    if (!this.rowsStarted) {
                        this.getTable().getRowGroupBuilder().startTablePart(this);
                    } else {
                        this.columnNumberManager.prepareForNextRow(this.pendingSpans);
                        this.getTable().getRowGroupBuilder().endTableRow();
                    }
                    this.rowsStarted = true;
                    this.getTable().getRowGroupBuilder().startTableRow((TableRow)fONode);
                    break;
                }
                case 75: {
                    if (!this.rowsStarted) {
                        this.getTable().getRowGroupBuilder().startTablePart(this);
                    }
                    this.rowsStarted = true;
                    TableCell tableCell = (TableCell)fONode;
                    this.addTableCellChild(tableCell, this.firstRow);
                    this.lastCellEndsRow = tableCell.endsRow();
                    if (!this.lastCellEndsRow) break;
                    this.firstRow = false;
                    this.columnNumberManager.prepareForNextRow(this.pendingSpans);
                    this.getTable().getRowGroupBuilder().endRow(this);
                    break;
                }
            }
        }
        super.addChildNode(fONode);
    }

    void addRowGroup(List list) {
        this.rowGroups.add(list);
    }

    public List getRowGroups() {
        return this.rowGroups;
    }

    public CommonBorderPaddingBackground getCommonBorderPaddingBackground() {
        return this.commonBorderPaddingBackground;
    }

    public boolean isFirst(TableRow tableRow) {
        return this.firstChild == null || this.firstChild == tableRow;
    }

    void signalNewRow() {
        if (this.rowsStarted) {
            this.firstRow = false;
            if (!this.lastCellEndsRow) {
                this.columnNumberManager.prepareForNextRow(this.pendingSpans);
                this.getTable().getRowGroupBuilder().endRow(this);
            }
        }
    }
}

