/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.pagination;

import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.Numeric;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.pagination.PageNumberGenerator;
import org.apache.fop.fo.pagination.Root;
import org.apache.fop.fo.properties.CommonAccessibility;
import org.apache.fop.fo.properties.CommonAccessibilityHolder;

public abstract class AbstractPageSequence
extends FObj
implements CommonAccessibilityHolder {
    protected Numeric initialPageNumber;
    protected int forcePageCount;
    private String format;
    private int letterValue;
    private char groupingSeparator;
    private int groupingSize;
    private Numeric referenceOrientation;
    private String language;
    private String country;
    private String numberConversionFeatures;
    private CommonAccessibility commonAccessibility;
    private PageNumberGenerator pageNumberGenerator;
    protected int startingPageNumber = 0;

    public AbstractPageSequence(FONode fONode) {
        super(fONode);
    }

    public void bind(PropertyList propertyList) throws FOPException {
        super.bind(propertyList);
        this.initialPageNumber = propertyList.get(126).getNumeric();
        this.forcePageCount = propertyList.get(109).getEnum();
        this.format = propertyList.get(110).getString();
        this.letterValue = propertyList.get(142).getEnum();
        this.groupingSeparator = propertyList.get(113).getCharacter();
        this.groupingSize = propertyList.get(114).getNumber().intValue();
        this.referenceOrientation = propertyList.get(197).getNumeric();
        this.language = propertyList.get(134).getString();
        this.country = propertyList.get(81).getString();
        this.numberConversionFeatures = propertyList.get(276).getString();
        this.commonAccessibility = CommonAccessibility.getInstance(propertyList);
    }

    protected void startOfNode() throws FOPException {
        this.pageNumberGenerator = new PageNumberGenerator(this.format, this.groupingSeparator, this.groupingSize, this.letterValue, this.numberConversionFeatures, this.language, this.country);
    }

    public void initPageNumber() {
        int n = 0;
        if (this.initialPageNumber.getEnum() != 0) {
            this.startingPageNumber = this.getRoot().getEndingPageNumberOfPreviousSequence() + 1;
            n = this.initialPageNumber.getEnum();
            if (n == 11) {
                if (this.startingPageNumber % 2 == 0) {
                    ++this.startingPageNumber;
                }
            } else if (n == 10 && this.startingPageNumber % 2 == 1) {
                ++this.startingPageNumber;
            }
        } else {
            int n2 = this.initialPageNumber.getValue();
            this.startingPageNumber = n2 > 0 ? n2 : 1;
        }
    }

    public int getStartingPageNumber() {
        return this.startingPageNumber;
    }

    public String makeFormattedPageNumber(int n) {
        return this.pageNumberGenerator.makeFormattedPageNumber(n);
    }

    public CommonAccessibility getCommonAccessibility() {
        return this.commonAccessibility;
    }

    public Root getRoot() {
        return (Root)this.getParent();
    }

    public int getForcePageCount() {
        return this.forcePageCount;
    }

    public Numeric getInitialPageNumber() {
        return this.initialPageNumber;
    }

    public int getReferenceOrientation() {
        return this.referenceOrientation.getValue();
    }
}

