/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.pagination;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.apache.fop.apps.FOPException;
import org.apache.fop.complexscripts.bidi.DelimitedTextRange;
import org.apache.fop.datatypes.Numeric;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.ValidationException;
import org.apache.fop.fo.pagination.AbstractPageSequence;
import org.apache.fop.fo.pagination.Flow;
import org.apache.fop.fo.pagination.PageProductionException;
import org.apache.fop.fo.pagination.PageSequenceMaster;
import org.apache.fop.fo.pagination.SimplePageMaster;
import org.apache.fop.fo.pagination.StaticContent;
import org.apache.fop.fo.pagination.Title;
import org.apache.fop.traits.Direction;
import org.apache.fop.traits.WritingMode;
import org.apache.fop.traits.WritingModeTraits;
import org.apache.fop.traits.WritingModeTraitsGetter;
import org.xml.sax.Locator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageSequence
extends AbstractPageSequence
implements WritingModeTraitsGetter {
    private String country;
    private String language;
    private String masterReference;
    private Numeric referenceOrientation;
    private WritingModeTraits writingModeTraits;
    private Map<String, FONode> flowMap;
    private SimplePageMaster simplePageMaster;
    private PageSequenceMaster pageSequenceMaster;
    private Title titleFO;
    private Flow mainFlow = null;

    public PageSequence(FONode fONode) {
        super(fONode);
    }

    @Override
    public void bind(PropertyList propertyList) throws FOPException {
        super.bind(propertyList);
        this.country = propertyList.get(81).getString();
        this.language = propertyList.get(134).getString();
        this.masterReference = propertyList.get(154).getString();
        this.referenceOrientation = propertyList.get(197).getNumeric();
        this.writingModeTraits = new WritingModeTraits(WritingMode.valueOf(propertyList.get(267).getEnum()));
        if (this.masterReference == null || this.masterReference.equals("")) {
            this.missingPropertyError("master-reference");
        }
    }

    @Override
    protected void startOfNode() throws FOPException {
        super.startOfNode();
        this.flowMap = new HashMap<String, FONode>();
        this.simplePageMaster = this.getRoot().getLayoutMasterSet().getSimplePageMaster(this.masterReference);
        if (this.simplePageMaster == null) {
            this.pageSequenceMaster = this.getRoot().getLayoutMasterSet().getPageSequenceMaster(this.masterReference);
            if (this.pageSequenceMaster == null) {
                this.getFOValidationEventProducer().masterNotFound(this, this.getName(), this.masterReference, this.getLocator());
            }
        }
        this.getFOEventHandler().startPageSequence(this);
    }

    @Override
    protected void endOfNode() throws FOPException {
        if (this.mainFlow == null) {
            this.missingChildElementError("(title?,static-content*,flow)");
        }
        this.getFOEventHandler().endPageSequence(this);
    }

    @Override
    protected void validateChildNode(Locator locator, String string, String string2) throws ValidationException {
        if ("http://www.w3.org/1999/XSL/Format".equals(string)) {
            if ("title".equals(string2)) {
                if (this.titleFO != null) {
                    this.tooManyNodesError(locator, "fo:title");
                } else if (!this.flowMap.isEmpty()) {
                    this.nodesOutOfOrderError(locator, "fo:title", "fo:static-content");
                } else if (this.mainFlow != null) {
                    this.nodesOutOfOrderError(locator, "fo:title", "fo:flow");
                }
            } else if ("static-content".equals(string2)) {
                if (this.mainFlow != null) {
                    this.nodesOutOfOrderError(locator, "fo:static-content", "fo:flow");
                }
            } else if ("flow".equals(string2)) {
                if (this.mainFlow != null) {
                    this.tooManyNodesError(locator, "fo:flow");
                }
            } else {
                this.invalidChildError(locator, string, string2);
            }
        }
    }

    @Override
    public void addChildNode(FONode fONode) throws FOPException {
        int n = fONode.getNameId();
        switch (n) {
            case 80: {
                this.titleFO = (Title)fONode;
                break;
            }
            case 16: {
                this.mainFlow = (Flow)fONode;
                this.addFlow(this.mainFlow);
                break;
            }
            case 70: {
                this.addFlow((StaticContent)fONode);
                this.flowMap.put(((Flow)fONode).getFlowName(), (Flow)fONode);
                break;
            }
            default: {
                super.addChildNode(fONode);
            }
        }
    }

    private void addFlow(Flow flow) throws ValidationException {
        String string = flow.getFlowName();
        if (this.hasFlowName(string)) {
            this.getFOValidationEventProducer().duplicateFlowNameInPageSequence(this, flow.getName(), string, flow.getLocator());
        }
        if (!(this.getRoot().getLayoutMasterSet().regionNameExists(string) || string.equals("xsl-before-float-separator") || string.equals("xsl-footnote-separator"))) {
            this.getFOValidationEventProducer().flowNameNotMapped(this, flow.getName(), string, flow.getLocator());
        }
    }

    public StaticContent getStaticContent(String string) {
        return (StaticContent)this.flowMap.get(string);
    }

    public Title getTitleFO() {
        return this.titleFO;
    }

    public Flow getMainFlow() {
        return this.mainFlow;
    }

    public boolean hasFlowName(String string) {
        return this.flowMap.containsKey(string);
    }

    public Map<String, FONode> getFlowMap() {
        return this.flowMap;
    }

    public SimplePageMaster getNextSimplePageMaster(int n, boolean bl, boolean bl2, boolean bl3) throws PageProductionException {
        boolean bl4;
        if (this.pageSequenceMaster == null) {
            return this.simplePageMaster;
        }
        boolean bl5 = bl4 = n % 2 == 1;
        if (log.isDebugEnabled()) {
            log.debug((Object)("getNextSimplePageMaster(page=" + n + " isOdd=" + bl4 + " isFirst=" + bl + " isLast=" + bl2 + " isBlank=" + bl3 + ")"));
        }
        return this.pageSequenceMaster.getNextSimplePageMaster(bl4, bl, bl2, bl3, this.getMainFlow().getFlowName());
    }

    public boolean goToPreviousSimplePageMaster() {
        return this.pageSequenceMaster == null || this.pageSequenceMaster.goToPreviousSimplePageMaster();
    }

    public boolean hasPagePositionLast() {
        return this.pageSequenceMaster != null && this.pageSequenceMaster.hasPagePositionLast();
    }

    public boolean hasPagePositionOnly() {
        return this.pageSequenceMaster != null && this.pageSequenceMaster.hasPagePositionOnly();
    }

    public String getMasterReference() {
        return this.masterReference;
    }

    @Override
    public String getLocalName() {
        return "page-sequence";
    }

    @Override
    public int getNameId() {
        return 53;
    }

    public String getCountry() {
        return this.country;
    }

    public String getLanguage() {
        return this.language;
    }

    @Override
    public int getReferenceOrientation() {
        if (this.referenceOrientation != null) {
            return this.referenceOrientation.getValue();
        }
        return 0;
    }

    @Override
    public Direction getInlineProgressionDirection() {
        if (this.writingModeTraits != null) {
            return this.writingModeTraits.getInlineProgressionDirection();
        }
        return Direction.LR;
    }

    @Override
    public Direction getBlockProgressionDirection() {
        if (this.writingModeTraits != null) {
            return this.writingModeTraits.getBlockProgressionDirection();
        }
        return Direction.TB;
    }

    @Override
    public Direction getColumnProgressionDirection() {
        if (this.writingModeTraits != null) {
            return this.writingModeTraits.getColumnProgressionDirection();
        }
        return Direction.LR;
    }

    @Override
    public Direction getRowProgressionDirection() {
        if (this.writingModeTraits != null) {
            return this.writingModeTraits.getRowProgressionDirection();
        }
        return Direction.TB;
    }

    @Override
    public Direction getShiftDirection() {
        if (this.writingModeTraits != null) {
            return this.writingModeTraits.getShiftDirection();
        }
        return Direction.TB;
    }

    @Override
    public WritingMode getWritingMode() {
        if (this.writingModeTraits != null) {
            return this.writingModeTraits.getWritingMode();
        }
        return WritingMode.LR_TB;
    }

    @Override
    protected Stack collectDelimitedTextRanges(Stack stack, DelimitedTextRange delimitedTextRange) {
        Object object;
        Map<String, FONode> map = this.getFlowMap();
        if (map != null) {
            object = map.values().iterator();
            while (object.hasNext()) {
                FONode fONode = (FONode)object.next();
                if (!(fONode instanceof StaticContent)) continue;
                stack = ((StaticContent)fONode).collectDelimitedTextRanges(stack);
            }
        }
        if ((object = this.getMainFlow()) != null) {
            stack = ((FONode)object).collectDelimitedTextRanges(stack);
        }
        return stack;
    }

    public void releasePageSequence() {
        this.mainFlow = null;
        this.flowMap.clear();
    }
}

