/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.pagination;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.fop.apps.FOPException;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.ValidationException;
import org.apache.fop.fo.pagination.LayoutMasterSet;
import org.apache.fop.fo.pagination.PageProductionException;
import org.apache.fop.fo.pagination.SimplePageMaster;
import org.apache.fop.fo.pagination.SubSequenceSpecifier;
import org.apache.fop.layoutmgr.BlockLevelEventProducer;
import org.xml.sax.Locator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageSequenceMaster
extends FObj {
    private String masterName;
    private LayoutMasterSet layoutMasterSet;
    private List<SubSequenceSpecifier> subSequenceSpecifiers;
    private SubSequenceSpecifier currentSubSequence;
    private int currentSubSequenceNumber = -1;
    private BlockLevelEventProducer blockLevelEventProducer;

    public PageSequenceMaster(FONode fONode, BlockLevelEventProducer blockLevelEventProducer) {
        super(fONode);
        this.blockLevelEventProducer = blockLevelEventProducer;
    }

    @Override
    public void bind(PropertyList propertyList) throws FOPException {
        this.masterName = propertyList.get(153).getString();
        if (this.masterName == null || this.masterName.equals("")) {
            this.missingPropertyError("master-name");
        }
    }

    @Override
    protected void startOfNode() throws FOPException {
        this.subSequenceSpecifiers = new ArrayList<SubSequenceSpecifier>();
        this.layoutMasterSet = this.parent.getRoot().getLayoutMasterSet();
        this.layoutMasterSet.addPageSequenceMaster(this.masterName, this);
    }

    @Override
    protected void endOfNode() throws FOPException {
        if (this.firstChild == null) {
            this.missingChildElementError("(single-page-master-reference|repeatable-page-master-reference|repeatable-page-master-alternatives)+");
        }
    }

    @Override
    protected void validateChildNode(Locator locator, String string, String string2) throws ValidationException {
        if ("http://www.w3.org/1999/XSL/Format".equals(string) && !"single-page-master-reference".equals(string2) && !"repeatable-page-master-reference".equals(string2) && !"repeatable-page-master-alternatives".equals(string2)) {
            this.invalidChildError(locator, string, string2);
        }
    }

    protected void addSubsequenceSpecifier(SubSequenceSpecifier subSequenceSpecifier) {
        this.subSequenceSpecifiers.add(subSequenceSpecifier);
    }

    private SubSequenceSpecifier getNextSubSequence() {
        ++this.currentSubSequenceNumber;
        if (this.currentSubSequenceNumber >= 0 && this.currentSubSequenceNumber < this.subSequenceSpecifiers.size()) {
            return this.subSequenceSpecifiers.get(this.currentSubSequenceNumber);
        }
        return null;
    }

    List<SubSequenceSpecifier> getSubSequenceSpecifier() {
        return Collections.unmodifiableList(this.subSequenceSpecifiers);
    }

    public void reset() {
        this.currentSubSequenceNumber = -1;
        this.currentSubSequence = null;
        if (this.subSequenceSpecifiers != null) {
            for (SubSequenceSpecifier subSequenceSpecifier : this.subSequenceSpecifiers) {
                subSequenceSpecifier.reset();
            }
        }
    }

    public boolean goToPreviousSimplePageMaster() {
        boolean bl;
        if (this.currentSubSequence != null && !(bl = this.currentSubSequence.goToPrevious())) {
            if (this.currentSubSequenceNumber > 0) {
                --this.currentSubSequenceNumber;
                this.currentSubSequence = this.subSequenceSpecifiers.get(this.currentSubSequenceNumber);
            } else {
                this.currentSubSequence = null;
            }
        }
        return this.currentSubSequence != null;
    }

    public boolean hasPagePositionLast() {
        return this.currentSubSequence != null && this.currentSubSequence.hasPagePositionLast();
    }

    public boolean hasPagePositionOnly() {
        return this.currentSubSequence != null && this.currentSubSequence.hasPagePositionOnly();
    }

    public SimplePageMaster getNextSimplePageMaster(boolean bl, boolean bl2, boolean bl3, boolean bl4, String string) throws PageProductionException {
        if (this.currentSubSequence == null) {
            this.currentSubSequence = this.getNextSubSequence();
            if (this.currentSubSequence == null) {
                this.blockLevelEventProducer.missingSubsequencesInPageSequenceMaster(this, this.masterName, this.getLocator());
            }
            if (this.currentSubSequence.isInfinite() && !this.currentSubSequence.canProcess(string)) {
                throw new PageProductionException("The current sub-sequence will not terminate whilst processing then main flow");
            }
        }
        SimplePageMaster simplePageMaster = this.currentSubSequence.getNextPageMaster(bl, bl2, bl3, bl4);
        boolean bl5 = true;
        while (simplePageMaster == null) {
            SubSequenceSpecifier subSequenceSpecifier = this.getNextSubSequence();
            if (subSequenceSpecifier == null) {
                this.blockLevelEventProducer.pageSequenceMasterExhausted(this, this.masterName, bl5 & this.currentSubSequence.isReusable(), this.getLocator());
                this.currentSubSequence.reset();
                if (!this.currentSubSequence.canProcess(string)) {
                    throw new PageProductionException("The last simple-page-master does not reference the main flow");
                }
                bl5 = false;
            } else {
                this.currentSubSequence = subSequenceSpecifier;
            }
            simplePageMaster = this.currentSubSequence.getNextPageMaster(bl, bl2, bl3, bl4);
        }
        return simplePageMaster;
    }

    @Override
    public String getLocalName() {
        return "page-sequence-master";
    }

    @Override
    public int getNameId() {
        return 54;
    }
}

