/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.pagination;

import java.util.HashMap;
import java.util.Map;
import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.Length;
import org.apache.fop.datatypes.Numeric;
import org.apache.fop.datatypes.PercentBaseContext;
import org.apache.fop.datatypes.SimplePercentBaseContext;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.ValidationException;
import org.apache.fop.fo.pagination.LayoutMasterSet;
import org.apache.fop.fo.pagination.Region;
import org.apache.fop.fo.properties.CommonMarginBlock;
import org.apache.fop.traits.WritingMode;
import org.xml.sax.Locator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimplePageMaster
extends FObj {
    private CommonMarginBlock commonMarginBlock;
    private String masterName;
    private Length pageHeight;
    private Length pageWidth;
    private Numeric referenceOrientation;
    private WritingMode writingMode;
    private Map<String, Region> regions;
    private boolean hasRegionBody = false;
    private boolean hasRegionBefore = false;
    private boolean hasRegionAfter = false;
    private boolean hasRegionStart = false;
    private boolean hasRegionEnd = false;

    public SimplePageMaster(FONode fONode) {
        super(fONode);
    }

    @Override
    public void bind(PropertyList propertyList) throws FOPException {
        this.commonMarginBlock = propertyList.getMarginBlockProps();
        this.masterName = propertyList.get(153).getString();
        this.pageHeight = propertyList.get(183).getLength();
        this.pageWidth = propertyList.get(186).getLength();
        this.referenceOrientation = propertyList.get(197).getNumeric();
        this.writingMode = WritingMode.valueOf(propertyList.get(267).getEnum());
        if (this.masterName == null || this.masterName.equals("")) {
            this.missingPropertyError("master-name");
        }
    }

    @Override
    protected void startOfNode() throws FOPException {
        LayoutMasterSet layoutMasterSet = (LayoutMasterSet)this.parent;
        if (this.masterName == null) {
            this.missingPropertyError("master-name");
        } else {
            layoutMasterSet.addSimplePageMaster(this);
        }
        this.regions = new HashMap<String, Region>(5);
    }

    @Override
    protected void endOfNode() throws FOPException {
        if (!this.hasRegionBody) {
            this.missingChildElementError("(region-body, region-before?, region-after?, region-start?, region-end?)");
        }
    }

    @Override
    protected void validateChildNode(Locator locator, String string, String string2) throws ValidationException {
        if ("http://www.w3.org/1999/XSL/Format".equals(string)) {
            if (string2.equals("region-body")) {
                if (this.hasRegionBody) {
                    this.tooManyNodesError(locator, "fo:region-body");
                } else {
                    this.hasRegionBody = true;
                }
            } else if (string2.equals("region-before")) {
                if (!this.hasRegionBody) {
                    this.nodesOutOfOrderError(locator, "fo:region-body", "fo:region-before");
                } else if (this.hasRegionBefore) {
                    this.tooManyNodesError(locator, "fo:region-before");
                } else if (this.hasRegionAfter) {
                    this.nodesOutOfOrderError(locator, "fo:region-before", "fo:region-after");
                } else if (this.hasRegionStart) {
                    this.nodesOutOfOrderError(locator, "fo:region-before", "fo:region-start");
                } else if (this.hasRegionEnd) {
                    this.nodesOutOfOrderError(locator, "fo:region-before", "fo:region-end");
                } else {
                    this.hasRegionBefore = true;
                }
            } else if (string2.equals("region-after")) {
                if (!this.hasRegionBody) {
                    this.nodesOutOfOrderError(locator, "fo:region-body", "fo:region-after");
                } else if (this.hasRegionAfter) {
                    this.tooManyNodesError(locator, "fo:region-after");
                } else if (this.hasRegionStart) {
                    this.nodesOutOfOrderError(locator, "fo:region-after", "fo:region-start");
                } else if (this.hasRegionEnd) {
                    this.nodesOutOfOrderError(locator, "fo:region-after", "fo:region-end");
                } else {
                    this.hasRegionAfter = true;
                }
            } else if (string2.equals("region-start")) {
                if (!this.hasRegionBody) {
                    this.nodesOutOfOrderError(locator, "fo:region-body", "fo:region-start");
                } else if (this.hasRegionStart) {
                    this.tooManyNodesError(locator, "fo:region-start");
                } else if (this.hasRegionEnd) {
                    this.nodesOutOfOrderError(locator, "fo:region-start", "fo:region-end");
                } else {
                    this.hasRegionStart = true;
                }
            } else if (string2.equals("region-end")) {
                if (!this.hasRegionBody) {
                    this.nodesOutOfOrderError(locator, "fo:region-body", "fo:region-end");
                } else if (this.hasRegionEnd) {
                    this.tooManyNodesError(locator, "fo:region-end");
                } else {
                    this.hasRegionEnd = true;
                }
            } else {
                this.invalidChildError(locator, string, string2);
            }
        }
    }

    @Override
    public boolean generatesReferenceAreas() {
        return true;
    }

    @Override
    protected void addChildNode(FONode fONode) throws FOPException {
        if (fONode instanceof Region) {
            this.addRegion((Region)fONode);
        } else {
            super.addChildNode(fONode);
        }
    }

    protected void addRegion(Region region) {
        this.regions.put(String.valueOf(region.getNameId()), region);
    }

    protected final PercentBaseContext getPageWidthContext(int n) {
        return this.referenceOrientation.getValue() % 180 == 0 ? new SimplePercentBaseContext(null, n, this.getPageWidth().getValue()) : new SimplePercentBaseContext(null, n, this.getPageHeight().getValue());
    }

    protected final PercentBaseContext getPageHeightContext(int n) {
        return this.referenceOrientation.getValue() % 180 == 0 ? new SimplePercentBaseContext(null, n, this.getPageHeight().getValue()) : new SimplePercentBaseContext(null, n, this.getPageWidth().getValue());
    }

    public Region getRegion(int n) {
        return this.regions.get(String.valueOf(n));
    }

    public Map<String, Region> getRegions() {
        return this.regions;
    }

    protected boolean regionNameExists(String string) {
        for (Region region : this.regions.values()) {
            if (!region.getRegionName().equals(string)) continue;
            return true;
        }
        return false;
    }

    public CommonMarginBlock getCommonMarginBlock() {
        return this.commonMarginBlock;
    }

    public String getMasterName() {
        return this.masterName;
    }

    public Length getPageWidth() {
        return this.pageWidth;
    }

    public Length getPageHeight() {
        return this.pageHeight;
    }

    public int getReferenceOrientation() {
        return this.referenceOrientation.getValue();
    }

    public WritingMode getWritingMode() {
        return this.writingMode;
    }

    @Override
    public String getLocalName() {
        return "simple-page-master";
    }

    @Override
    public int getNameId() {
        return 68;
    }
}

