/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.properties;

import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.properties.Property;
import org.apache.fop.fo.properties.PropertyCache;
import org.apache.fop.fo.properties.PropertyMaker;

public final class CharacterProperty
extends Property {
    private static final PropertyCache<CharacterProperty> CACHE = new PropertyCache();
    private final char character;

    private CharacterProperty(char c) {
        this.character = c;
    }

    public static CharacterProperty getInstance(char c) {
        return CACHE.fetch(new CharacterProperty(c));
    }

    public Object getObject() {
        return new Character(this.character);
    }

    public char getCharacter() {
        return this.character;
    }

    public String getString() {
        return new Character(this.character).toString();
    }

    public boolean equals(Object object) {
        if (object instanceof CharacterProperty) {
            return this.character == ((CharacterProperty)object).character;
        }
        return false;
    }

    public int hashCode() {
        return this.character;
    }

    public static class Maker
    extends PropertyMaker {
        public Maker(int n) {
            super(n);
        }

        public Property make(PropertyList propertyList, String string, FObj fObj) {
            char c = string.charAt(0);
            return CharacterProperty.getInstance(c);
        }
    }
}

