/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.properties;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.expr.PropertyException;
import org.apache.fop.fo.properties.CharacterProperty;
import org.apache.fop.fo.properties.EnumProperty;
import org.apache.fop.fo.properties.NumberProperty;
import org.apache.fop.fo.properties.PropertyCache;
import org.apache.fop.fo.properties.StringProperty;
import org.apache.fop.fonts.Font;
import org.apache.fop.fonts.FontMetrics;
import org.apache.fop.fonts.Typeface;

public final class CommonHyphenation {
    private static final Log LOG = LogFactory.getLog(CommonHyphenation.class);
    private static final PropertyCache<CommonHyphenation> CACHE = new PropertyCache();
    private int hash = 0;
    public final StringProperty language;
    public final StringProperty country;
    public final StringProperty script;
    public final EnumProperty hyphenate;
    public final CharacterProperty hyphenationCharacter;
    public final NumberProperty hyphenationPushCharacterCount;
    public final NumberProperty hyphenationRemainCharacterCount;
    private static final char HYPHEN_MINUS = '-';
    private static final char MINUS_SIGN = '\u2212';

    private CommonHyphenation(StringProperty stringProperty, StringProperty stringProperty2, StringProperty stringProperty3, EnumProperty enumProperty, CharacterProperty characterProperty, NumberProperty numberProperty, NumberProperty numberProperty2) {
        this.language = stringProperty;
        this.country = stringProperty2;
        this.script = stringProperty3;
        this.hyphenate = enumProperty;
        this.hyphenationCharacter = characterProperty;
        this.hyphenationPushCharacterCount = numberProperty;
        this.hyphenationRemainCharacterCount = numberProperty2;
    }

    public static CommonHyphenation getInstance(PropertyList propertyList) throws PropertyException {
        StringProperty stringProperty = (StringProperty)propertyList.get(134);
        StringProperty stringProperty2 = (StringProperty)propertyList.get(81);
        StringProperty stringProperty3 = (StringProperty)propertyList.get(218);
        EnumProperty enumProperty = (EnumProperty)propertyList.get(116);
        CharacterProperty characterProperty = (CharacterProperty)propertyList.get(117);
        NumberProperty numberProperty = (NumberProperty)propertyList.get(120);
        NumberProperty numberProperty2 = (NumberProperty)propertyList.get(121);
        CommonHyphenation commonHyphenation = new CommonHyphenation(stringProperty, stringProperty2, stringProperty3, enumProperty, characterProperty, numberProperty, numberProperty2);
        return CACHE.fetch(commonHyphenation);
    }

    public char getHyphChar(Font font) {
        char c = this.hyphenationCharacter.getCharacter();
        if (font.hasChar(c)) {
            return c;
        }
        char c2 = c;
        boolean bl = false;
        if (font.hasChar('-')) {
            c2 = '-';
            bl = true;
        } else if (font.hasChar('\u2212')) {
            Typeface typeface;
            c2 = '\u2212';
            FontMetrics fontMetrics = font.getFontMetrics();
            if (fontMetrics instanceof Typeface && !"SymbolEncoding".equals((typeface = (Typeface)fontMetrics).getEncodingName())) {
                bl = true;
            }
        } else {
            Typeface typeface;
            c2 = ' ';
            FontMetrics fontMetrics = font.getFontMetrics();
            if (fontMetrics instanceof Typeface && !"ZapfDingbatsEncoding".equals((typeface = (Typeface)fontMetrics).getEncodingName())) {
                bl = true;
            }
        }
        if (bl) {
            LOG.warn((Object)("Substituted specified hyphenation character (0x" + Integer.toHexString(c) + ") with 0x" + Integer.toHexString(c2) + " because the font doesn't have the specified hyphenation character: " + font.getFontTriplet()));
        }
        return c2;
    }

    public int getHyphIPD(Font font) {
        char c = this.getHyphChar(font);
        return font.getCharWidth(c);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof CommonHyphenation) {
            CommonHyphenation commonHyphenation = (CommonHyphenation)object;
            return commonHyphenation.language == this.language && commonHyphenation.country == this.country && commonHyphenation.script == this.script && commonHyphenation.hyphenate == this.hyphenate && commonHyphenation.hyphenationCharacter == this.hyphenationCharacter && commonHyphenation.hyphenationPushCharacterCount == this.hyphenationPushCharacterCount && commonHyphenation.hyphenationRemainCharacterCount == this.hyphenationRemainCharacterCount;
        }
        return false;
    }

    public int hashCode() {
        if (this.hash == 0) {
            int n = 17;
            n = 37 * n + (this.language == null ? 0 : this.language.hashCode());
            n = 37 * n + (this.script == null ? 0 : this.script.hashCode());
            n = 37 * n + (this.country == null ? 0 : this.country.hashCode());
            n = 37 * n + (this.hyphenate == null ? 0 : this.hyphenate.hashCode());
            n = 37 * n + (this.hyphenationCharacter == null ? 0 : this.hyphenationCharacter.hashCode());
            n = 37 * n + (this.hyphenationPushCharacterCount == null ? 0 : this.hyphenationPushCharacterCount.hashCode());
            this.hash = n = 37 * n + (this.hyphenationRemainCharacterCount == null ? 0 : this.hyphenationRemainCharacterCount.hashCode());
        }
        return this.hash;
    }
}

