/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.properties;

import org.apache.fop.datatypes.PercentBaseContext;
import org.apache.fop.fo.properties.LengthProperty;
import org.apache.fop.fo.properties.PropertyCache;

public final class FixedLength
extends LengthProperty {
    public static final String PICA = "pc";
    public static final String POINT = "pt";
    public static final String MM = "mm";
    public static final String CM = "cm";
    public static final String INCH = "in";
    public static final String MPT = "mpt";
    private static final PropertyCache<FixedLength> CACHE = new PropertyCache();
    public static final FixedLength ZERO_FIXED_LENGTH = new FixedLength(0.0, "mpt", 1.0f);
    private int millipoints;

    private FixedLength(double d, String string, float f) {
        this.millipoints = FixedLength.convert(d, string, f);
    }

    public static FixedLength getInstance(double d, String string, float f) {
        if (d == 0.0) {
            return ZERO_FIXED_LENGTH;
        }
        return CACHE.fetch(new FixedLength(d, string, f));
    }

    public static FixedLength getInstance(double d, String string) {
        return FixedLength.getInstance(d, string, 1.0f);
    }

    public static FixedLength getInstance(double d) {
        return FixedLength.getInstance(d, MPT, 1.0f);
    }

    private static int convert(double d, String string, float f) {
        if ("px".equals(string)) {
            d *= (double)(f * 1000.0f);
        } else if (INCH.equals(string)) {
            d *= 72000.0;
        } else if (CM.equals(string)) {
            d *= 28346.4567;
        } else if (MM.equals(string)) {
            d *= 2834.64567;
        } else if (POINT.equals(string)) {
            d *= 1000.0;
        } else if (PICA.equals(string)) {
            d *= 12000.0;
        } else if (!MPT.equals(string)) {
            d = 0.0;
            log.error((Object)("Unknown length unit '" + string + "'"));
        }
        return (int)d;
    }

    public int getValue() {
        return this.millipoints;
    }

    public int getValue(PercentBaseContext percentBaseContext) {
        return this.millipoints;
    }

    public double getNumericValue() {
        return this.millipoints;
    }

    public double getNumericValue(PercentBaseContext percentBaseContext) {
        return this.millipoints;
    }

    public boolean isAbsolute() {
        return true;
    }

    public String toString() {
        return this.millipoints + MPT;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof FixedLength) {
            return ((FixedLength)object).millipoints == this.millipoints;
        }
        return false;
    }

    public int hashCode() {
        return this.millipoints;
    }
}

