/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.properties;

import org.apache.fop.fo.Constants;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.expr.PropertyException;
import org.apache.fop.fo.properties.FixedLength;
import org.apache.fop.fo.properties.LengthProperty;
import org.apache.fop.fo.properties.PercentLength;
import org.apache.fop.fo.properties.Property;

public class FontSizePropertyMaker
extends LengthProperty.Maker
implements Constants {
    private static final int FONT_SIZE_NORMAL = 12000;
    private static final double FONT_SIZE_GROWTH_FACTOR = 1.2;

    public FontSizePropertyMaker(int n) {
        super(n);
    }

    public Property make(PropertyList propertyList, String string, FObj fObj) throws PropertyException {
        Property property = super.make(propertyList, string, fObj);
        if (property instanceof PercentLength) {
            Property property2 = propertyList.getFromParent(this.propId);
            property = FixedLength.getInstance((double)property2.getLength().getValue() * ((PercentLength)property).getPercentage() / 100.0);
        }
        return property;
    }

    public Property convertProperty(Property property, PropertyList propertyList, FObj fObj) throws PropertyException {
        if (property.getEnum() == 71 || property.getEnum() == 132) {
            Property property2 = propertyList.getFromParent(this.propId);
            int n = this.computeClosestAbsoluteFontSize(property2.getLength().getValue());
            if (property.getEnum() == 71) {
                return FixedLength.getInstance(Math.round((double)n * 1.2));
            }
            return FixedLength.getInstance(Math.round((double)n / 1.2));
        }
        return super.convertProperty(property, propertyList, fObj);
    }

    private int computeClosestAbsoluteFontSize(int n) {
        double d = 1.2;
        int n2 = 12000;
        if (n < 12000) {
            d = 0.8333333333333334;
        }
        int n3 = (int)Math.round((double)n2 * d);
        while (d < 1.0 && n3 > n || d > 1.0 && n3 < n) {
            n2 = n3;
            n3 = (int)Math.round((double)n2 * d);
        }
        if (Math.abs(n2 - n) <= Math.abs(n - n3)) {
            return n2;
        }
        return n3;
    }
}

