/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.properties;

import org.apache.fop.datatypes.CompoundDatatype;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.expr.PropertyException;
import org.apache.fop.fo.properties.CompoundPropertyMaker;
import org.apache.fop.fo.properties.Property;
import org.apache.fop.fo.properties.PropertyCache;

public final class KeepProperty
extends Property
implements CompoundDatatype {
    private static final PropertyCache<KeepProperty> CACHE = new PropertyCache();
    private boolean isCachedValue = false;
    private Property withinLine;
    private Property withinColumn;
    private Property withinPage;

    public void setComponent(int n, Property property, boolean bl) {
        if (this.isCachedValue) {
            log.warn((Object)"KeepProperty.setComponent() called on cached value. Ignoring...");
            return;
        }
        if (n == 5120) {
            this.setWithinLine(property, bl);
        } else if (n == 4608) {
            this.setWithinColumn(property, bl);
        } else if (n == 5632) {
            this.setWithinPage(property, bl);
        }
    }

    public Property getComponent(int n) {
        if (n == 5120) {
            return this.getWithinLine();
        }
        if (n == 4608) {
            return this.getWithinColumn();
        }
        if (n == 5632) {
            return this.getWithinPage();
        }
        return null;
    }

    public void setWithinLine(Property property, boolean bl) {
        this.withinLine = property;
    }

    protected void setWithinColumn(Property property, boolean bl) {
        this.withinColumn = property;
    }

    public void setWithinPage(Property property, boolean bl) {
        this.withinPage = property;
    }

    public Property getWithinLine() {
        return this.withinLine;
    }

    public Property getWithinColumn() {
        return this.withinColumn;
    }

    public Property getWithinPage() {
        return this.withinPage;
    }

    public String toString() {
        return "Keep[withinLine:" + this.getWithinLine().getObject() + ", withinColumn:" + this.getWithinColumn().getObject() + ", withinPage:" + this.getWithinPage().getObject() + "]";
    }

    public KeepProperty getKeep() {
        KeepProperty keepProperty = CACHE.fetch(this);
        keepProperty.isCachedValue = true;
        return keepProperty;
    }

    public Object getObject() {
        return this;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof KeepProperty) {
            KeepProperty keepProperty = (KeepProperty)object;
            return keepProperty.withinColumn == this.withinColumn && keepProperty.withinLine == this.withinLine && keepProperty.withinPage == this.withinPage;
        }
        return false;
    }

    public int hashCode() {
        int n = 17;
        n = 37 * n + (this.withinColumn == null ? 0 : this.withinColumn.hashCode());
        n = 37 * n + (this.withinLine == null ? 0 : this.withinLine.hashCode());
        n = 37 * n + (this.withinPage == null ? 0 : this.withinPage.hashCode());
        return n;
    }

    public static class Maker
    extends CompoundPropertyMaker {
        public Maker(int n) {
            super(n);
        }

        public Property makeNewProperty() {
            return new KeepProperty();
        }

        public Property convertProperty(Property property, PropertyList propertyList, FObj fObj) throws PropertyException {
            if (property instanceof KeepProperty) {
                return property;
            }
            return super.convertProperty(property, propertyList, fObj);
        }
    }
}

