/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.properties;

import org.apache.fop.datatypes.CompoundDatatype;
import org.apache.fop.datatypes.Length;
import org.apache.fop.datatypes.PercentBaseContext;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.expr.PropertyException;
import org.apache.fop.fo.properties.CompoundPropertyMaker;
import org.apache.fop.fo.properties.FixedLength;
import org.apache.fop.fo.properties.PercentLength;
import org.apache.fop.fo.properties.Property;
import org.apache.fop.traits.MinOptMax;
import org.apache.fop.util.CompareUtil;

public class LengthRangeProperty
extends Property
implements CompoundDatatype {
    private Property minimum;
    private Property optimum;
    private Property maximum;
    private static final int MINSET = 1;
    private static final int OPTSET = 2;
    private static final int MAXSET = 4;
    private int bfSet = 0;
    private boolean consistent = false;

    public MinOptMax toMinOptMax(PercentBaseContext percentBaseContext) {
        int n = this.getMinimum(percentBaseContext).isAuto() ? 0 : this.getMinimum(percentBaseContext).getLength().getValue(percentBaseContext);
        int n2 = this.getOptimum(percentBaseContext).isAuto() ? n : this.getOptimum(percentBaseContext).getLength().getValue(percentBaseContext);
        int n3 = this.getMaximum(percentBaseContext).isAuto() ? Integer.MAX_VALUE : this.getMaximum(percentBaseContext).getLength().getValue(percentBaseContext);
        return MinOptMax.getInstance(n, n2, n3);
    }

    public void setComponent(int n, Property property, boolean bl) {
        if (n == 3072) {
            this.setMinimum(property, bl);
        } else if (n == 3584) {
            this.setOptimum(property, bl);
        } else if (n == 2560) {
            this.setMaximum(property, bl);
        }
    }

    public Property getComponent(int n) {
        if (n == 3072) {
            return this.getMinimum(null);
        }
        if (n == 3584) {
            return this.getOptimum(null);
        }
        if (n == 2560) {
            return this.getMaximum(null);
        }
        return null;
    }

    protected void setMinimum(Property property, boolean bl) {
        this.minimum = property;
        if (!bl) {
            this.bfSet |= 1;
        }
        this.consistent = false;
    }

    protected void setMaximum(Property property, boolean bl) {
        this.maximum = property;
        if (!bl) {
            this.bfSet |= 4;
        }
        this.consistent = false;
    }

    protected void setOptimum(Property property, boolean bl) {
        this.optimum = property;
        if (!bl) {
            this.bfSet |= 2;
        }
        this.consistent = false;
    }

    private void checkConsistency(PercentBaseContext percentBaseContext) {
        if (this.consistent) {
            return;
        }
        if (percentBaseContext == null) {
            return;
        }
        if (!this.minimum.isAuto() && !this.maximum.isAuto() && this.minimum.getLength().getValue(percentBaseContext) > this.maximum.getLength().getValue(percentBaseContext)) {
            if ((this.bfSet & 1) != 0) {
                if ((this.bfSet & 4) != 0) {
                    log.error((Object)"forcing max to min in LengthRange");
                }
                this.maximum = this.minimum;
            } else {
                this.minimum = this.maximum;
            }
        }
        if (!this.optimum.isAuto() && !this.maximum.isAuto() && this.optimum.getLength().getValue(percentBaseContext) > this.maximum.getLength().getValue(percentBaseContext)) {
            if ((this.bfSet & 2) != 0) {
                if ((this.bfSet & 4) != 0) {
                    log.error((Object)"forcing opt to max in LengthRange");
                    this.optimum = this.maximum;
                } else {
                    this.maximum = this.optimum;
                }
            } else {
                this.optimum = this.maximum;
            }
        } else if (!this.optimum.isAuto() && !this.minimum.isAuto() && this.optimum.getLength().getValue(percentBaseContext) < this.minimum.getLength().getValue(percentBaseContext)) {
            if ((this.bfSet & 1) != 0) {
                if ((this.bfSet & 2) != 0) {
                    log.error((Object)"forcing opt to min in LengthRange");
                }
                this.optimum = this.minimum;
            } else {
                this.minimum = this.optimum;
            }
        }
        this.consistent = true;
    }

    public Property getMinimum(PercentBaseContext percentBaseContext) {
        this.checkConsistency(percentBaseContext);
        return this.minimum;
    }

    public Property getMaximum(PercentBaseContext percentBaseContext) {
        this.checkConsistency(percentBaseContext);
        return this.maximum;
    }

    public Property getOptimum(PercentBaseContext percentBaseContext) {
        this.checkConsistency(percentBaseContext);
        return this.optimum;
    }

    public String toString() {
        return "LengthRange[min:" + this.getMinimum(null).getObject() + ", max:" + this.getMaximum(null).getObject() + ", opt:" + this.getOptimum(null).getObject() + "]";
    }

    public LengthRangeProperty getLengthRange() {
        return this;
    }

    public Object getObject() {
        return this;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.bfSet;
        n = 31 * n + (this.consistent ? 1231 : 1237);
        n = 31 * n + CompareUtil.getHashCode(this.minimum);
        n = 31 * n + CompareUtil.getHashCode(this.optimum);
        n = 31 * n + CompareUtil.getHashCode(this.maximum);
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof LengthRangeProperty)) {
            return false;
        }
        LengthRangeProperty lengthRangeProperty = (LengthRangeProperty)object;
        return this.bfSet == lengthRangeProperty.bfSet && this.consistent == lengthRangeProperty.consistent && CompareUtil.equal(this.minimum, lengthRangeProperty.minimum) && CompareUtil.equal(this.optimum, lengthRangeProperty.optimum) && CompareUtil.equal(this.maximum, lengthRangeProperty.maximum);
    }

    public static class Maker
    extends CompoundPropertyMaker {
        public Maker(int n) {
            super(n);
        }

        public Property makeNewProperty() {
            return new LengthRangeProperty();
        }

        private boolean isNegativeLength(Length length) {
            return length instanceof PercentLength && ((PercentLength)length).getPercentage() < 0.0 || length.isAbsolute() && length.getValue() < 0;
        }

        public Property convertProperty(Property property, PropertyList propertyList, FObj fObj) throws PropertyException {
            Length length;
            if (property instanceof LengthRangeProperty) {
                return property;
            }
            if ((this.propId == 17 || this.propId == 127) && (length = property.getLength()) != null && this.isNegativeLength(length)) {
                Property.log.warn((Object)FObj.decorateWithContextInfo("Replaced negative value (" + length + ") for " + this.getName() + " with 0mpt", fObj));
                property = FixedLength.ZERO_FIXED_LENGTH;
            }
            return super.convertProperty(property, propertyList, fObj);
        }

        protected Property setSubprop(Property property, int n, Property property2) {
            Length length;
            CompoundDatatype compoundDatatype = (CompoundDatatype)property.getObject();
            if ((this.propId == 17 || this.propId == 127) && (length = property2.getLength()) != null && this.isNegativeLength(length)) {
                Property.log.warn((Object)("Replaced negative value (" + length + ") for " + this.getName() + " with 0mpt"));
                compoundDatatype.setComponent(n, FixedLength.ZERO_FIXED_LENGTH, false);
                return property;
            }
            compoundDatatype.setComponent(n, property2, false);
            return property;
        }
    }
}

