/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.fonts.CustomFont;
import org.apache.fop.fonts.EmbeddingMode;
import org.apache.fop.fonts.EncodingMode;
import org.apache.fop.fonts.FontResolver;
import org.apache.fop.fonts.truetype.TTFFontLoader;
import org.apache.fop.fonts.type1.Type1FontLoader;

public abstract class FontLoader {
    protected static final Log log = LogFactory.getLog(FontLoader.class);
    protected String fontFileURI;
    protected FontResolver resolver;
    protected CustomFont returnFont;
    protected boolean loaded;
    protected boolean embedded;
    protected boolean useKerning;
    protected boolean useAdvanced;

    public FontLoader(String string, boolean bl, boolean bl2, boolean bl3, FontResolver fontResolver) {
        this.fontFileURI = string;
        this.embedded = bl;
        this.useKerning = bl2;
        this.useAdvanced = bl3;
        this.resolver = fontResolver;
    }

    private static boolean isType1(String string) {
        return string.toLowerCase().endsWith(".pfb");
    }

    public static CustomFont loadFont(File file, String string, boolean bl, EmbeddingMode embeddingMode, EncodingMode encodingMode, FontResolver fontResolver) throws IOException {
        return FontLoader.loadFont(file.toURI().toURL(), string, bl, embeddingMode, encodingMode, fontResolver);
    }

    public static CustomFont loadFont(URL uRL, String string, boolean bl, EmbeddingMode embeddingMode, EncodingMode encodingMode, FontResolver fontResolver) throws IOException {
        return FontLoader.loadFont(uRL.toExternalForm(), string, bl, embeddingMode, encodingMode, true, true, fontResolver);
    }

    public static CustomFont loadFont(String string, String string2, boolean bl, EmbeddingMode embeddingMode, EncodingMode encodingMode, boolean bl2, boolean bl3, FontResolver fontResolver) throws IOException {
        FontLoader fontLoader;
        boolean bl4 = FontLoader.isType1(string = string.trim());
        if (bl4) {
            if (encodingMode == EncodingMode.CID) {
                throw new IllegalArgumentException("CID encoding mode not supported for Type 1 fonts");
            }
            if (embeddingMode == EmbeddingMode.SUBSET) {
                throw new IllegalArgumentException("Subset embedding for Type 1 fonts is not supported");
            }
            fontLoader = new Type1FontLoader(string, bl, bl2, fontResolver);
        } else {
            fontLoader = new TTFFontLoader(string, string2, bl, embeddingMode, encodingMode, bl2, bl3, fontResolver);
        }
        return fontLoader.getFont();
    }

    public static InputStream openFontUri(FontResolver fontResolver, String string) throws IOException, MalformedURLException {
        InputStream inputStream = null;
        if (fontResolver != null) {
            Source source = fontResolver.resolve(string);
            if (source == null) {
                String string2 = "Cannot load font: failed to create Source for font file " + string;
                throw new IOException(string2);
            }
            if (source instanceof StreamSource) {
                inputStream = ((StreamSource)source).getInputStream();
            }
            if (inputStream == null && source.getSystemId() != null) {
                inputStream = new URL(source.getSystemId()).openStream();
            }
            if (inputStream == null) {
                String string3 = "Cannot load font: failed to create InputStream from Source for font file " + string;
                throw new IOException(string3);
            }
        } else {
            inputStream = new URL(string).openStream();
        }
        return inputStream;
    }

    protected abstract void read() throws IOException;

    public CustomFont getFont() throws IOException {
        if (!this.loaded) {
            this.read();
        }
        return this.returnFont;
    }
}

