/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.apps.FOPException;
import org.apache.fop.fonts.FontManager;
import org.apache.fop.fonts.FontTriplet;
import org.apache.fop.fonts.substitute.FontSubstitutions;
import org.apache.fop.fonts.substitute.FontSubstitutionsConfigurator;
import org.apache.fop.util.LogUtil;

public class FontManagerConfigurator {
    private static Log log = LogFactory.getLog(FontManagerConfigurator.class);
    private final Configuration cfg;
    private URI baseURI = null;

    public FontManagerConfigurator(Configuration configuration) {
        this.cfg = configuration;
    }

    public FontManagerConfigurator(Configuration configuration, URI uRI) {
        this.cfg = configuration;
        this.baseURI = uRI;
    }

    public void configure(FontManager fontManager, boolean bl) throws FOPException {
        String string;
        if (this.cfg.getChild("use-cache", false) != null) {
            try {
                fontManager.setUseCache(this.cfg.getChild("use-cache").getValueAsBoolean());
            }
            catch (ConfigurationException configurationException) {
                LogUtil.handleException(log, (Exception)((Object)configurationException), true);
            }
        }
        if (this.cfg.getChild("cache-file", false) != null) {
            try {
                fontManager.setCacheFile(new File(this.cfg.getChild("cache-file").getValue()));
            }
            catch (ConfigurationException configurationException) {
                LogUtil.handleException(log, (Exception)((Object)configurationException), true);
            }
        }
        if (this.cfg.getChild("font-base", false) != null) {
            string = this.cfg.getChild("font-base").getValue(null);
            if (this.baseURI != null) {
                string = this.baseURI.resolve(string).normalize().toString();
            }
            try {
                fontManager.setFontBaseURL(string);
            }
            catch (MalformedURLException malformedURLException) {
                LogUtil.handleException(log, malformedURLException, true);
            }
        }
        if (this.cfg.getChild("base14-kerning", false) != null) {
            try {
                fontManager.setBase14KerningEnabled(this.cfg.getChild("base14-kerning").getValueAsBoolean());
            }
            catch (ConfigurationException configurationException) {
                LogUtil.handleException(log, (Exception)((Object)configurationException), true);
            }
        }
        if ((string = this.cfg.getChild("fonts", false)) != null) {
            FontSubstitutions fontSubstitutions;
            Configuration configuration = string.getChild("substitutions", false);
            if (configuration != null) {
                fontSubstitutions = new FontSubstitutions();
                new FontSubstitutionsConfigurator(configuration).configure(fontSubstitutions);
                fontManager.setFontSubstitutions(fontSubstitutions);
            }
            if ((fontSubstitutions = string.getChild("referenced-fonts", false)) != null) {
                FontTriplet.Matcher matcher = FontManagerConfigurator.createFontsMatcher((Configuration)fontSubstitutions, bl);
                fontManager.setReferencedFontsMatcher(matcher);
            }
        }
    }

    public static FontTriplet.Matcher createFontsMatcher(Configuration configuration, boolean bl) throws FOPException {
        ArrayList<FontFamilyRegExFontTripletMatcher> arrayList = new ArrayList<FontFamilyRegExFontTripletMatcher>();
        Configuration[] configurationArray = configuration.getChildren("match");
        for (int i = 0; i < configurationArray.length; ++i) {
            try {
                arrayList.add(new FontFamilyRegExFontTripletMatcher(configurationArray[i].getAttribute("font-family")));
                continue;
            }
            catch (ConfigurationException configurationException) {
                LogUtil.handleException(log, (Exception)((Object)configurationException), bl);
            }
        }
        OrFontTripletMatcher orFontTripletMatcher = new OrFontTripletMatcher(arrayList.toArray(new FontTriplet.Matcher[arrayList.size()]));
        return orFontTripletMatcher;
    }

    private static class FontFamilyRegExFontTripletMatcher
    implements FontTriplet.Matcher {
        private final Pattern regex;

        public FontFamilyRegExFontTripletMatcher(String string) {
            this.regex = Pattern.compile(string);
        }

        public boolean matches(FontTriplet fontTriplet) {
            return this.regex.matcher(fontTriplet.getName()).matches();
        }
    }

    private static class OrFontTripletMatcher
    implements FontTriplet.Matcher {
        private final FontTriplet.Matcher[] matchers;

        public OrFontTripletMatcher(FontTriplet.Matcher[] matcherArray) {
            this.matchers = matcherArray;
        }

        public boolean matches(FontTriplet fontTriplet) {
            int n = this.matchers.length;
            for (int i = 0; i < n; ++i) {
                if (!this.matchers[i].matches(fontTriplet)) continue;
                return true;
            }
            return false;
        }
    }
}

