/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.SAXParserFactory;
import org.apache.fop.apps.FOPException;
import org.apache.fop.fonts.CIDFontType;
import org.apache.fop.fonts.CMapSegment;
import org.apache.fop.fonts.CustomFont;
import org.apache.fop.fonts.FontResolver;
import org.apache.fop.fonts.FontType;
import org.apache.fop.fonts.MultiByteFont;
import org.apache.fop.fonts.SingleByteFont;
import org.apache.fop.fonts.Typeface;
import org.apache.fop.fonts.apps.TTFReader;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class FontReader
extends DefaultHandler {
    private boolean isCID = false;
    private CustomFont returnFont = null;
    private MultiByteFont multiFont = null;
    private SingleByteFont singleFont = null;
    private StringBuffer text = new StringBuffer();
    private List<Integer> cidWidths = null;
    private int cidWidthIndex = 0;
    private Map<Integer, Integer> currentKerning = null;
    private List<CMapSegment> bfranges = null;

    private void createFont(InputSource inputSource) throws FOPException {
        XMLReader xMLReader = null;
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(true);
            xMLReader = sAXParserFactory.newSAXParser().getXMLReader();
        }
        catch (Exception exception) {
            throw new FOPException(exception);
        }
        if (xMLReader == null) {
            throw new FOPException("Unable to create SAX parser");
        }
        try {
            xMLReader.setFeature("http://xml.org/sax/features/namespace-prefixes", false);
        }
        catch (SAXException sAXException) {
            throw new FOPException("You need a SAX parser which supports SAX version 2", sAXException);
        }
        xMLReader.setContentHandler(this);
        try {
            xMLReader.parse(inputSource);
        }
        catch (SAXException sAXException) {
            throw new FOPException(sAXException);
        }
        catch (IOException iOException) {
            throw new FOPException(iOException);
        }
    }

    public void setFontEmbedPath(String string) {
        this.returnFont.setEmbedFileName(string);
    }

    public void setKerningEnabled(boolean bl) {
        this.returnFont.setKerningEnabled(bl);
    }

    public void setAdvancedEnabled(boolean bl) {
        this.returnFont.setAdvancedEnabled(bl);
    }

    public void setResolver(FontResolver fontResolver) {
        this.returnFont.setResolver(fontResolver);
    }

    public Typeface getFont() {
        return this.returnFont;
    }

    public FontReader(InputSource inputSource) throws FOPException {
        this.createFont(inputSource);
    }

    public void startDocument() {
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (string2.equals("font-metrics")) {
            if ("TYPE0".equals(attributes.getValue("type"))) {
                this.multiFont = new MultiByteFont();
                this.returnFont = this.multiFont;
                this.isCID = true;
                TTFReader.checkMetricsVersion(attributes);
            } else if ("TRUETYPE".equals(attributes.getValue("type"))) {
                this.singleFont = new SingleByteFont();
                this.singleFont.setFontType(FontType.TRUETYPE);
                this.returnFont = this.singleFont;
                this.isCID = false;
                TTFReader.checkMetricsVersion(attributes);
            } else {
                this.singleFont = new SingleByteFont();
                this.singleFont.setFontType(FontType.TYPE1);
                this.returnFont = this.singleFont;
                this.isCID = false;
            }
        } else if ("embed".equals(string2)) {
            this.returnFont.setEmbedFileName(attributes.getValue("file"));
            this.returnFont.setEmbedResourceName(attributes.getValue("class"));
        } else if ("cid-widths".equals(string2)) {
            this.cidWidthIndex = this.getInt(attributes.getValue("start-index"));
            this.cidWidths = new ArrayList<Integer>();
        } else if ("kerning".equals(string2)) {
            this.currentKerning = new HashMap<Integer, Integer>();
            this.returnFont.putKerningEntry(new Integer(attributes.getValue("kpx1")), this.currentKerning);
        } else if ("bfranges".equals(string2)) {
            this.bfranges = new ArrayList<CMapSegment>();
        } else if ("bf".equals(string2)) {
            CMapSegment cMapSegment = new CMapSegment(this.getInt(attributes.getValue("us")), this.getInt(attributes.getValue("ue")), this.getInt(attributes.getValue("gi")));
            this.bfranges.add(cMapSegment);
        } else if ("wx".equals(string2)) {
            this.cidWidths.add(new Integer(attributes.getValue("w")));
        } else if (!"widths".equals(string2)) {
            if ("char".equals(string2)) {
                try {
                    this.singleFont.setWidth(Integer.parseInt(attributes.getValue("idx")), Integer.parseInt(attributes.getValue("wdt")));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new SAXException("Malformed width in metric file: " + numberFormatException.getMessage(), numberFormatException);
                }
            } else if ("pair".equals(string2)) {
                this.currentKerning.put(new Integer(attributes.getValue("kpx2")), new Integer(attributes.getValue("kern")));
            }
        }
    }

    private int getInt(String string) throws SAXException {
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            throw new SAXException("Error while parsing integer value: " + string, exception);
        }
        return n;
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        String string4 = this.text.toString().trim();
        if ("font-name".equals(string2)) {
            this.returnFont.setFontName(string4);
        } else if ("full-name".equals(string2)) {
            this.returnFont.setFullName(string4);
        } else if ("family-name".equals(string2)) {
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.add(string4);
            this.returnFont.setFamilyNames(hashSet);
        } else if ("ttc-name".equals(string2) && this.isCID) {
            this.multiFont.setTTCName(string4);
        } else if ("encoding".equals(string2)) {
            if (this.singleFont != null && this.singleFont.getFontType() == FontType.TYPE1) {
                this.singleFont.setEncoding(string4);
            }
        } else if ("cap-height".equals(string2)) {
            this.returnFont.setCapHeight(this.getInt(string4));
        } else if ("x-height".equals(string2)) {
            this.returnFont.setXHeight(this.getInt(string4));
        } else if ("ascender".equals(string2)) {
            this.returnFont.setAscender(this.getInt(string4));
        } else if ("descender".equals(string2)) {
            this.returnFont.setDescender(this.getInt(string4));
        } else if ("left".equals(string2)) {
            int[] nArray = this.returnFont.getFontBBox();
            nArray[0] = this.getInt(string4);
            this.returnFont.setFontBBox(nArray);
        } else if ("bottom".equals(string2)) {
            int[] nArray = this.returnFont.getFontBBox();
            nArray[1] = this.getInt(string4);
            this.returnFont.setFontBBox(nArray);
        } else if ("right".equals(string2)) {
            int[] nArray = this.returnFont.getFontBBox();
            nArray[2] = this.getInt(string4);
            this.returnFont.setFontBBox(nArray);
        } else if ("top".equals(string2)) {
            int[] nArray = this.returnFont.getFontBBox();
            nArray[3] = this.getInt(string4);
            this.returnFont.setFontBBox(nArray);
        } else if ("first-char".equals(string2)) {
            this.returnFont.setFirstChar(this.getInt(string4));
        } else if ("last-char".equals(string2)) {
            this.returnFont.setLastChar(this.getInt(string4));
        } else if ("flags".equals(string2)) {
            this.returnFont.setFlags(this.getInt(string4));
        } else if ("stemv".equals(string2)) {
            this.returnFont.setStemV(this.getInt(string4));
        } else if ("italic-angle".equals(string2)) {
            this.returnFont.setItalicAngle(this.getInt(string4));
        } else if ("missing-width".equals(string2)) {
            this.returnFont.setMissingWidth(this.getInt(string4));
        } else if ("cid-type".equals(string2)) {
            this.multiFont.setCIDType(CIDFontType.byName(string4));
        } else if ("default-width".equals(string2)) {
            this.multiFont.setDefaultWidth(this.getInt(string4));
        } else if ("cid-widths".equals(string2)) {
            int[] nArray = new int[this.cidWidths.size()];
            int n = 0;
            for (int i = 0; i < this.cidWidths.size(); ++i) {
                nArray[n++] = this.cidWidths.get(i);
            }
            this.multiFont.setWidthArray(nArray);
        } else if ("bfranges".equals(string2)) {
            this.multiFont.setCMap(this.bfranges.toArray(new CMapSegment[0]));
        }
        this.text.setLength(0);
    }

    public void characters(char[] cArray, int n, int n2) {
        this.text.append(cArray, n, n2);
    }
}

