/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts.autodetect;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.fonts.CustomFont;
import org.apache.fop.fonts.EmbedFontInfo;
import org.apache.fop.fonts.EmbeddingMode;
import org.apache.fop.fonts.EncodingMode;
import org.apache.fop.fonts.FontCache;
import org.apache.fop.fonts.FontEventListener;
import org.apache.fop.fonts.FontLoader;
import org.apache.fop.fonts.FontResolver;
import org.apache.fop.fonts.FontTriplet;
import org.apache.fop.fonts.FontUtil;
import org.apache.fop.fonts.MultiByteFont;
import org.apache.fop.fonts.Typeface;
import org.apache.fop.fonts.truetype.FontFileReader;
import org.apache.fop.fonts.truetype.TTFFile;
import org.apache.fop.fonts.truetype.TTFFontLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FontInfoFinder {
    private final Log log = LogFactory.getLog(FontInfoFinder.class);
    private FontEventListener eventListener;
    private final Pattern quotePattern = Pattern.compile("'");

    public void setEventListener(FontEventListener fontEventListener) {
        this.eventListener = fontEventListener;
    }

    private void generateTripletsFromFont(CustomFont customFont, Collection<FontTriplet> collection) {
        int n;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Font: " + customFont.getFullName() + ", family: " + customFont.getFamilyNames() + ", PS: " + customFont.getFontName() + ", EmbedName: " + customFont.getEmbedFontName()));
        }
        String string = this.stripQuotes(customFont.getStrippedFontName());
        String string2 = this.stripQuotes(customFont.getFullName());
        String string3 = string2.toLowerCase();
        String string4 = this.guessStyle(customFont, string3);
        int n2 = n = FontUtil.guessWeight(string3);
        collection.add(new FontTriplet(string2, "normal", 400));
        if (!string2.equals(string)) {
            collection.add(new FontTriplet(string, "normal", 400));
        }
        Set<String> set = customFont.getFamilyNames();
        for (String string5 : set) {
            if (string2.equals(string5 = this.stripQuotes(string5))) continue;
            int n3 = string2.startsWith(string5) ? string2.length() - string5.length() : string2.length();
            collection.add(new FontTriplet(string5, string4, n2, n3));
        }
    }

    private String stripQuotes(String string) {
        return this.quotePattern.matcher(string).replaceAll("");
    }

    private String guessStyle(CustomFont customFont, String string) {
        String string2 = "normal";
        string2 = customFont.getItalicAngle() > 0 ? "italic" : FontUtil.guessStyle(string);
        return string2;
    }

    private EmbedFontInfo getFontInfoFromCustomFont(URL uRL, CustomFont customFont, FontCache fontCache) {
        ArrayList<FontTriplet> arrayList = new ArrayList<FontTriplet>();
        this.generateTripletsFromFont(customFont, arrayList);
        String string = uRL.toExternalForm();
        String string2 = null;
        if (customFont instanceof MultiByteFont) {
            string2 = ((MultiByteFont)customFont).getTTCName();
        }
        EmbedFontInfo embedFontInfo = new EmbedFontInfo(null, customFont.isKerningEnabled(), customFont.isAdvancedEnabled(), arrayList, string, string2);
        embedFontInfo.setPostScriptName(customFont.getFontName());
        if (fontCache != null) {
            fontCache.addFont(embedFontInfo);
        }
        return embedFontInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EmbedFontInfo[] find(URL uRL, FontResolver fontResolver, FontCache fontCache) {
        Object object;
        String string = null;
        string = uRL.toExternalForm();
        boolean bl = true;
        boolean bl2 = fontResolver != null ? fontResolver.isComplexScriptFeaturesEnabled() : true;
        long l = -1L;
        if (fontCache != null) {
            l = FontCache.getLastModified(uRL);
            if (fontCache.containsFont(string)) {
                object = fontCache.getFontInfos(string, l);
                if (object != null) {
                    return object;
                }
            } else if (fontCache.isFailedFont(string, l)) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Skipping font file that failed to load previously: " + string));
                }
                return null;
            }
        }
        object = null;
        if (uRL.toExternalForm().toLowerCase().endsWith(".ttc")) {
            Object object2;
            List<String> list = null;
            String string2 = uRL.toExternalForm().trim();
            InputStream inputStream = null;
            try {
                inputStream = FontLoader.openFontUri(fontResolver, string2);
                object2 = new TTFFile(false, false);
                FontFileReader fontFileReader = new FontFileReader(inputStream);
                list = ((TTFFile)object2).getTTCnames(fontFileReader);
            }
            catch (Exception exception) {
                if (this.eventListener != null) {
                    this.eventListener.fontLoadingErrorAtAutoDetection(this, string2, exception);
                }
                EmbedFontInfo[] embedFontInfoArray = null;
                return embedFontInfoArray;
            }
            finally {
                IOUtils.closeQuietly((InputStream)inputStream);
            }
            object2 = new ArrayList();
            for (String string3 : list) {
                Object object3;
                block25: {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Loading " + string3));
                    }
                    try {
                        object3 = new TTFFontLoader(string2, string3, true, EmbeddingMode.AUTO, EncodingMode.AUTO, bl, bl2, fontResolver);
                        object = ((FontLoader)object3).getFont();
                        if (this.eventListener == null) break block25;
                        ((Typeface)object).setEventListener(this.eventListener);
                    }
                    catch (Exception exception) {
                        if (fontCache != null) {
                            fontCache.registerFailedFont(string, l);
                        }
                        if (this.eventListener == null) continue;
                        this.eventListener.fontLoadingErrorAtAutoDetection(this, string, exception);
                        continue;
                    }
                }
                if ((object3 = this.getFontInfoFromCustomFont(uRL, (CustomFont)object, fontCache)) == null) continue;
                object2.add(object3);
            }
            return object2.toArray(new EmbedFontInfo[object2.size()]);
        }
        try {
            object = FontLoader.loadFont(uRL, null, true, EmbeddingMode.AUTO, EncodingMode.AUTO, fontResolver);
            if (this.eventListener != null) {
                ((Typeface)object).setEventListener(this.eventListener);
            }
        }
        catch (Exception exception) {
            if (fontCache != null) {
                fontCache.registerFailedFont(string, l);
            }
            if (this.eventListener != null) {
                this.eventListener.fontLoadingErrorAtAutoDetection(this, string, exception);
            }
            return null;
        }
        EmbedFontInfo embedFontInfo = this.getFontInfoFromCustomFont(uRL, (CustomFont)object, fontCache);
        if (embedFontInfo != null) {
            return new EmbedFontInfo[]{embedFontInfo};
        }
        return null;
    }
}

