/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts.substitute;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.fonts.FontTriplet;
import org.apache.fop.fonts.FontUtil;
import org.apache.fop.fonts.substitute.AttributeValue;
import org.apache.fop.fonts.substitute.FontWeightRange;

public class FontQualifier {
    private static Log log = LogFactory.getLog(FontQualifier.class);
    private AttributeValue fontFamilyAttributeValue = null;
    private AttributeValue fontStyleAttributeValue = null;
    private AttributeValue fontWeightAttributeValue = null;

    public void setFontFamily(String string) {
        AttributeValue attributeValue = AttributeValue.valueOf(string);
        if (attributeValue == null) {
            log.error((Object)("Invalid font-family value '" + string + "'"));
            return;
        }
        this.fontFamilyAttributeValue = attributeValue;
    }

    public void setFontStyle(String string) {
        AttributeValue attributeValue = AttributeValue.valueOf(string);
        if (attributeValue != null) {
            this.fontStyleAttributeValue = attributeValue;
        }
    }

    public void setFontWeight(String string) {
        AttributeValue attributeValue = AttributeValue.valueOf(string);
        if (attributeValue != null) {
            for (Object e : attributeValue) {
                if (!(e instanceof String)) continue;
                String string2 = ((String)e).trim();
                try {
                    FontUtil.parseCSS2FontWeight(string2);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    log.error((Object)("Invalid font-weight value '" + string2 + "'"));
                    return;
                }
            }
            this.fontWeightAttributeValue = attributeValue;
        }
    }

    public AttributeValue getFontFamily() {
        return this.fontFamilyAttributeValue;
    }

    public AttributeValue getFontStyle() {
        if (this.fontStyleAttributeValue == null) {
            return AttributeValue.valueOf("normal");
        }
        return this.fontStyleAttributeValue;
    }

    public AttributeValue getFontWeight() {
        if (this.fontWeightAttributeValue == null) {
            return AttributeValue.valueOf(Integer.toString(400));
        }
        return this.fontWeightAttributeValue;
    }

    public boolean hasFontWeight() {
        return this.fontWeightAttributeValue != null;
    }

    public boolean hasFontStyle() {
        return this.fontStyleAttributeValue != null;
    }

    protected List match(FontInfo fontInfo) {
        AttributeValue attributeValue = this.getFontFamily();
        AttributeValue attributeValue2 = this.getFontWeight();
        AttributeValue attributeValue3 = this.getFontStyle();
        ArrayList<FontTriplet> arrayList = new ArrayList<FontTriplet>();
        for (String string : attributeValue) {
            Map<FontTriplet, String> map = fontInfo.getFontTriplets();
            if (map == null) continue;
            Set<FontTriplet> set = map.keySet();
            for (FontTriplet fontTriplet : set) {
                Object object;
                Object object22;
                String string2 = fontTriplet.getName();
                if (!string.toLowerCase().equals(string2.toLowerCase())) continue;
                boolean bl = false;
                int n = fontTriplet.getWeight();
                for (Object object22 : attributeValue2) {
                    int n2;
                    if (object22 instanceof FontWeightRange) {
                        object = (FontWeightRange)object22;
                        if (!((FontWeightRange)object).isWithinRange(n)) continue;
                        bl = true;
                        continue;
                    }
                    if (object22 instanceof String) {
                        object = (String)object22;
                        n2 = FontUtil.parseCSS2FontWeight((String)object);
                        if (n2 != n) continue;
                        bl = true;
                        continue;
                    }
                    if (!(object22 instanceof Integer) || (n2 = ((Integer)(object = (Integer)object22)).intValue()) != n) continue;
                    bl = true;
                }
                boolean bl2 = false;
                object22 = fontTriplet.getStyle();
                object = attributeValue3.iterator();
                while (object.hasNext()) {
                    String string3 = (String)object.next();
                    if (!((String)object22).equals(string3)) continue;
                    bl2 = true;
                }
                if (!bl || !bl2) continue;
                arrayList.add(fontTriplet);
            }
        }
        return arrayList;
    }

    protected FontTriplet bestMatch(FontInfo fontInfo) {
        List list = this.match(fontInfo);
        FontTriplet fontTriplet = null;
        if (list.size() == 1) {
            fontTriplet = (FontTriplet)list.get(0);
        } else {
            for (FontTriplet fontTriplet2 : list) {
                if (fontTriplet == null) {
                    fontTriplet = fontTriplet2;
                    continue;
                }
                int n = fontTriplet2.getPriority();
                if (n >= fontTriplet.getPriority()) continue;
                fontTriplet = fontTriplet2;
            }
        }
        return fontTriplet;
    }

    public List getTriplets() {
        ArrayList<FontTriplet> arrayList = new ArrayList<FontTriplet>();
        AttributeValue attributeValue = this.getFontFamily();
        for (String string : attributeValue) {
            AttributeValue attributeValue2 = this.getFontStyle();
            for (String string2 : attributeValue2) {
                AttributeValue attributeValue3 = this.getFontWeight();
                for (Object e : attributeValue3) {
                    Object object;
                    if (e instanceof FontWeightRange) {
                        object = (FontWeightRange)e;
                        int[] nArray = ((FontWeightRange)object).toArray();
                        for (int i = 0; i < nArray.length; ++i) {
                            arrayList.add(new FontTriplet(string, string2, nArray[i]));
                        }
                        continue;
                    }
                    if (e instanceof String) {
                        object = (String)e;
                        int n = FontUtil.parseCSS2FontWeight((String)object);
                        arrayList.add(new FontTriplet(string, string2, n));
                        continue;
                    }
                    if (!(e instanceof Integer)) continue;
                    object = (Integer)e;
                    int n = (Integer)object;
                    arrayList.add(new FontTriplet(string, string2, n));
                }
            }
        }
        return arrayList;
    }

    public String toString() {
        String string = new String();
        if (this.fontFamilyAttributeValue != null) {
            string = string + "font-family=" + this.fontFamilyAttributeValue;
        }
        if (this.fontStyleAttributeValue != null) {
            if (string.length() > 0) {
                string = string + ", ";
            }
            string = string + "font-style=" + this.fontStyleAttributeValue;
        }
        if (this.fontWeightAttributeValue != null) {
            if (string.length() > 0) {
                string = string + ", ";
            }
            string = string + "font-weight=" + this.fontWeightAttributeValue;
        }
        return string;
    }
}

