/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts.substitute;

import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FontWeightRange {
    protected static final Log log = LogFactory.getLog((String)"org.apache.fop.render.fonts");
    private int start;
    private int end;

    public static FontWeightRange valueOf(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "..");
        FontWeightRange fontWeightRange = null;
        if (stringTokenizer.countTokens() == 2) {
            String string2 = stringTokenizer.nextToken().trim();
            try {
                int n;
                int n2 = Integer.parseInt(string2);
                if (n2 % 100 != 0) {
                    log.error((Object)"font-weight start range is not a multiple of 100");
                }
                if ((n = Integer.parseInt(stringTokenizer.nextToken())) % 100 != 0) {
                    log.error((Object)"font-weight end range is not a multiple of 100");
                }
                if (n2 <= n) {
                    fontWeightRange = new FontWeightRange(n2, n);
                } else {
                    log.error((Object)"font-weight start range is greater than end range");
                }
            }
            catch (NumberFormatException numberFormatException) {
                log.error((Object)("invalid font-weight value " + string2));
            }
        }
        return fontWeightRange;
    }

    public FontWeightRange(int n, int n2) {
        this.start = n;
        this.end = n2;
    }

    public boolean isWithinRange(int n) {
        return n >= this.start && n <= this.end;
    }

    public String toString() {
        return this.start + ".." + this.end;
    }

    public int[] toArray() {
        int n = 0;
        for (int i = this.start; i <= this.end; i += 100) {
            ++n;
        }
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = this.start + i * 100;
        }
        return nArray;
    }
}

