/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts.truetype;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;

public class FontFileReader {
    private int fsize;
    private int current;
    private byte[] file;

    private void init(InputStream inputStream) throws IOException {
        this.file = IOUtils.toByteArray((InputStream)inputStream);
        this.fsize = this.file.length;
        this.current = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FontFileReader(String string) throws IOException {
        File file = new File(string);
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            this.init(fileInputStream);
        }
        finally {
            ((InputStream)fileInputStream).close();
        }
    }

    public FontFileReader(InputStream inputStream) throws IOException {
        this.init(inputStream);
    }

    public void seekSet(long l) throws IOException {
        if (l > (long)this.fsize || l < 0L) {
            throw new EOFException("Reached EOF, file size=" + this.fsize + " offset=" + l);
        }
        this.current = (int)l;
    }

    public void skip(long l) throws IOException {
        this.seekSet((long)this.current + l);
    }

    public int getCurrentPos() {
        return this.current;
    }

    public int getFileSize() {
        return this.fsize;
    }

    private byte read() throws IOException {
        if (this.current >= this.fsize) {
            throw new EOFException("Reached EOF, file size=" + this.fsize);
        }
        byte by = this.file[this.current++];
        return by;
    }

    public final byte readTTFByte() throws IOException {
        return this.read();
    }

    public final int readTTFUByte() throws IOException {
        byte by = this.read();
        if (by < 0) {
            return 256 + by;
        }
        return by;
    }

    public final short readTTFShort() throws IOException {
        int n = (this.readTTFUByte() << 8) + this.readTTFUByte();
        short s = (short)n;
        return s;
    }

    public final int readTTFUShort() throws IOException {
        int n = (this.readTTFUByte() << 8) + this.readTTFUByte();
        return n;
    }

    public final void writeTTFUShort(long l, int n) throws IOException {
        if (l + 2L > (long)this.fsize) {
            throw new EOFException("Reached EOF");
        }
        byte by = (byte)(n >> 8 & 0xFF);
        byte by2 = (byte)(n & 0xFF);
        int n2 = (int)l;
        this.file[n2] = by;
        this.file[n2 + 1] = by2;
    }

    public final short readTTFShort(long l) throws IOException {
        long l2 = this.getCurrentPos();
        this.seekSet(l);
        short s = this.readTTFShort();
        this.seekSet(l2);
        return s;
    }

    public final int readTTFUShort(long l) throws IOException {
        long l2 = this.getCurrentPos();
        this.seekSet(l);
        int n = this.readTTFUShort();
        this.seekSet(l2);
        return n;
    }

    public final int readTTFLong() throws IOException {
        long l = this.readTTFUByte();
        l = (l << 8) + (long)this.readTTFUByte();
        l = (l << 8) + (long)this.readTTFUByte();
        l = (l << 8) + (long)this.readTTFUByte();
        return (int)l;
    }

    public final long readTTFULong() throws IOException {
        long l = this.readTTFUByte();
        l = (l << 8) + (long)this.readTTFUByte();
        l = (l << 8) + (long)this.readTTFUByte();
        l = (l << 8) + (long)this.readTTFUByte();
        return l;
    }

    public final String readTTFString() throws IOException {
        int n = this.current;
        while (this.file[n++] != 0) {
            if (n < this.fsize) continue;
            throw new EOFException("Reached EOF, file size=" + this.fsize);
        }
        byte[] byArray = new byte[n - this.current - 1];
        System.arraycopy(this.file, this.current, byArray, 0, n - this.current - 1);
        return new String(byArray, "ISO-8859-1");
    }

    public final String readTTFString(int n) throws IOException {
        if (n + this.current > this.fsize) {
            throw new EOFException("Reached EOF, file size=" + this.fsize);
        }
        byte[] byArray = new byte[n];
        System.arraycopy(this.file, this.current, byArray, 0, n);
        this.current += n;
        String string = byArray.length > 0 && byArray[0] == 0 ? "UTF-16BE" : "ISO-8859-1";
        return new String(byArray, string);
    }

    public final String readTTFString(int n, int n2) throws IOException {
        if (n + this.current > this.fsize) {
            throw new EOFException("Reached EOF, file size=" + this.fsize);
        }
        byte[] byArray = new byte[n];
        System.arraycopy(this.file, this.current, byArray, 0, n);
        this.current += n;
        String string = "UTF-16BE";
        return new String(byArray, string);
    }

    public byte[] getBytes(int n, int n2) throws IOException {
        if (n + n2 > this.fsize) {
            throw new IOException("Reached EOF");
        }
        byte[] byArray = new byte[n2];
        System.arraycopy(this.file, n, byArray, 0, n2);
        return byArray;
    }

    public byte[] getAllBytes() {
        return this.file;
    }
}

