/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts.truetype;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.apache.fop.fonts.truetype.FontFileReader;

public class TTFDirTabEntry {
    private byte[] tag = new byte[4];
    private int checksum;
    private long offset;
    private long length;

    public TTFDirTabEntry() {
    }

    public TTFDirTabEntry(long l, long l2) {
        this.offset = l;
        this.length = l2;
    }

    public String read(FontFileReader fontFileReader) throws IOException {
        this.tag[0] = fontFileReader.readTTFByte();
        this.tag[1] = fontFileReader.readTTFByte();
        this.tag[2] = fontFileReader.readTTFByte();
        this.tag[3] = fontFileReader.readTTFByte();
        fontFileReader.skip(4L);
        this.offset = fontFileReader.readTTFULong();
        this.length = fontFileReader.readTTFULong();
        String string = new String(this.tag, "ISO-8859-1");
        return string;
    }

    public String toString() {
        return "Read dir tab [" + this.tag[0] + " " + this.tag[1] + " " + this.tag[2] + " " + this.tag[3] + "]" + " offset: " + this.offset + " length: " + this.length + " name: " + this.tag;
    }

    public int getChecksum() {
        return this.checksum;
    }

    public long getLength() {
        return this.length;
    }

    public long getOffset() {
        return this.offset;
    }

    public byte[] getTag() {
        return this.tag;
    }

    public String getTagString() {
        try {
            return new String(this.tag, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return this.toString();
        }
    }
}

