/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts.truetype;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.fop.fonts.CIDFontType;
import org.apache.fop.fonts.CMapSegment;
import org.apache.fop.fonts.EmbeddingMode;
import org.apache.fop.fonts.EncodingMode;
import org.apache.fop.fonts.FontLoader;
import org.apache.fop.fonts.FontResolver;
import org.apache.fop.fonts.FontType;
import org.apache.fop.fonts.MultiByteFont;
import org.apache.fop.fonts.NamedCharacter;
import org.apache.fop.fonts.SingleByteFont;
import org.apache.fop.fonts.truetype.FontFileReader;
import org.apache.fop.fonts.truetype.TTFFile;
import org.apache.fop.util.HexEncoder;

public class TTFFontLoader
extends FontLoader {
    private MultiByteFont multiFont;
    private SingleByteFont singleFont;
    private final String subFontName;
    private EncodingMode encodingMode;
    private EmbeddingMode embeddingMode;

    public TTFFontLoader(String string, FontResolver fontResolver) {
        this(string, null, true, EmbeddingMode.AUTO, EncodingMode.AUTO, true, true, fontResolver);
    }

    public TTFFontLoader(String string, String string2, boolean bl, EmbeddingMode embeddingMode, EncodingMode encodingMode, boolean bl2, boolean bl3, FontResolver fontResolver) {
        super(string, bl, bl2, bl3, fontResolver);
        this.subFontName = string2;
        this.encodingMode = encodingMode;
        this.embeddingMode = embeddingMode;
        if (this.encodingMode == EncodingMode.AUTO) {
            this.encodingMode = EncodingMode.CID;
        }
        if (this.embeddingMode == EmbeddingMode.AUTO) {
            this.embeddingMode = EmbeddingMode.SUBSET;
        }
    }

    protected void read() throws IOException {
        this.read(this.subFontName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void read(String string) throws IOException {
        InputStream inputStream = TTFFontLoader.openFontUri(this.resolver, this.fontFileURI);
        try {
            TTFFile tTFFile = new TTFFile(this.useKerning, this.useAdvanced);
            FontFileReader fontFileReader = new FontFileReader(inputStream);
            boolean bl = tTFFile.readFont(fontFileReader, string);
            if (!bl) {
                throw new IOException("TrueType font is not supported: " + this.fontFileURI);
            }
            this.buildFont(tTFFile, string);
            this.loaded = true;
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    private void buildFont(TTFFile tTFFile, String string) {
        Object object;
        if (tTFFile.isCFF()) {
            throw new UnsupportedOperationException("OpenType fonts with CFF data are not supported, yet");
        }
        boolean bl = this.embedded;
        if (this.encodingMode == EncodingMode.SINGLE_BYTE) {
            bl = false;
        }
        if (bl) {
            this.multiFont = new MultiByteFont();
            this.returnFont = this.multiFont;
            this.multiFont.setTTCName(string);
        } else {
            this.singleFont = new SingleByteFont();
            this.returnFont = this.singleFont;
        }
        this.returnFont.setResolver(this.resolver);
        this.returnFont.setFontName(tTFFile.getPostScriptName());
        this.returnFont.setFullName(tTFFile.getFullName());
        this.returnFont.setFamilyNames(tTFFile.getFamilyNames());
        this.returnFont.setFontSubFamilyName(tTFFile.getSubFamilyName());
        this.returnFont.setCapHeight(tTFFile.getCapHeight());
        this.returnFont.setXHeight(tTFFile.getXHeight());
        this.returnFont.setAscender(tTFFile.getLowerCaseAscent());
        this.returnFont.setDescender(tTFFile.getLowerCaseDescent());
        this.returnFont.setFontBBox(tTFFile.getFontBBox());
        this.returnFont.setFlags(tTFFile.getFlags());
        this.returnFont.setStemV(Integer.parseInt(tTFFile.getStemV()));
        this.returnFont.setItalicAngle(Integer.parseInt(tTFFile.getItalicAngle()));
        this.returnFont.setMissingWidth(0);
        this.returnFont.setWeight(tTFFile.getWeightClass());
        this.returnFont.setEmbeddingMode(this.embeddingMode);
        if (bl) {
            this.multiFont.setCIDType(CIDFontType.CIDTYPE2);
            object = tTFFile.getWidths();
            this.multiFont.setWidthArray((int[])object);
        } else {
            this.singleFont.setFontType(FontType.TRUETYPE);
            this.singleFont.setEncoding(tTFFile.getCharSetName());
            this.returnFont.setFirstChar(tTFFile.getFirstChar());
            this.returnFont.setLastChar(tTFFile.getLastChar());
            this.singleFont.setTrueTypePostScriptVersion(tTFFile.getPostScriptVersion());
            this.copyWidthsSingleByte(tTFFile);
        }
        this.returnFont.setCMap(this.getCMap(tTFFile));
        if (this.useKerning) {
            this.copyKerning(tTFFile, bl);
        }
        if (this.useAdvanced) {
            this.copyAdvanced(tTFFile);
        }
        if (this.embedded) {
            if (tTFFile.isEmbeddable()) {
                this.returnFont.setEmbedFileName(this.fontFileURI);
            } else {
                object = "The font " + this.fontFileURI + " is not embeddable due to a" + " licensing restriction.";
                throw new RuntimeException((String)object);
            }
        }
    }

    private CMapSegment[] getCMap(TTFFile tTFFile) {
        CMapSegment[] cMapSegmentArray = new CMapSegment[tTFFile.getCMaps().size()];
        return tTFFile.getCMaps().toArray(cMapSegmentArray);
    }

    private void copyWidthsSingleByte(TTFFile tTFFile) {
        int[] nArray = tTFFile.getWidths();
        for (int i = this.singleFont.getFirstChar(); i <= this.singleFont.getLastChar(); ++i) {
            this.singleFont.setWidth(i, tTFFile.getCharWidth(i));
        }
        for (CMapSegment cMapSegment : tTFFile.getCMaps()) {
            if (cMapSegment.getUnicodeStart() >= 65534) continue;
            for (char c = (char)cMapSegment.getUnicodeStart(); c <= cMapSegment.getUnicodeEnd(); c = (char)(c + '\u0001')) {
                char c2 = this.singleFont.getEncoding().mapChar(c);
                if (c2 > '\u0000') continue;
                int n = cMapSegment.getGlyphStartIndex() + c - cMapSegment.getUnicodeStart();
                String string = tTFFile.getGlyphName(n);
                if (string.length() == 0 && tTFFile.getPostScriptVersion() != TTFFile.PostScriptVersion.V2) {
                    string = "u" + HexEncoder.encode(c);
                }
                if (string.length() <= 0) continue;
                String string2 = Character.toString(c);
                NamedCharacter namedCharacter = new NamedCharacter(string, string2);
                this.singleFont.addUnencodedCharacter(namedCharacter, nArray[n]);
            }
        }
    }

    private void copyKerning(TTFFile tTFFile, boolean bl) {
        Set<Integer> set = bl ? tTFFile.getKerning().keySet() : tTFFile.getAnsiKerning().keySet();
        for (Integer n : set) {
            Map<Integer, Integer> map = bl ? tTFFile.getKerning().get(n) : tTFFile.getAnsiKerning().get(n);
            this.returnFont.putKerningEntry(n, map);
        }
    }

    private void copyAdvanced(TTFFile tTFFile) {
        if (this.returnFont instanceof MultiByteFont) {
            MultiByteFont multiByteFont = (MultiByteFont)this.returnFont;
            multiByteFont.setGDEF(tTFFile.getGDEF());
            multiByteFont.setGSUB(tTFFile.getGSUB());
            multiByteFont.setGPOS(tTFFile.getGPOS());
        }
    }
}

