/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts.type1;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class PFMInputStream
extends FilterInputStream {
    private final DataInputStream datain;

    public PFMInputStream(InputStream inputStream) {
        super(inputStream);
        this.datain = new DataInputStream(inputStream);
    }

    public short readByte() throws IOException {
        short s = this.datain.readByte();
        int n = ((s & 0xF0) >>> 4 << 4) + (s & 0xF);
        return (short)n;
    }

    public int readShort() throws IOException {
        short s = this.datain.readShort();
        int n = (s & 0xFF00) >>> 8;
        int n2 = (s & 0xFF) << 8;
        return n2 + n;
    }

    public long readInt() throws IOException {
        int n = this.datain.readInt();
        int n2 = (n & 0xFF000000) >>> 24;
        int n3 = (n & 0xFF0000) >>> 8;
        int n4 = (n & 0xFF00) << 8;
        int n5 = (n & 0xFF) << 24;
        return n2 + n3 + n4 + n5;
    }

    public String readString() throws IOException {
        InputStreamReader inputStreamReader = new InputStreamReader(this.in, "ISO-8859-1");
        StringBuffer stringBuffer = new StringBuffer();
        int n = inputStreamReader.read();
        while (n > 0) {
            stringBuffer.append((char)n);
            n = inputStreamReader.read();
        }
        if (n == -1) {
            throw new EOFException("Unexpected end of stream reached");
        }
        return stringBuffer.toString();
    }
}

