/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.hyphenation;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectOutputStream;
import org.apache.fop.hyphenation.HyphenationException;
import org.apache.fop.hyphenation.HyphenationTree;

public class SerializeHyphPattern {
    private boolean errorDump = false;

    public void setErrorDump(boolean bl) {
        this.errorDump = bl;
    }

    public void serializeDir(File file, File file2) {
        String[] stringArray = file.list(new FilenameFilter(){

            public boolean accept(File file, String string) {
                return string.endsWith(".xml");
            }
        });
        for (int i = 0; i < stringArray.length; ++i) {
            File file3 = new File(file, stringArray[i]);
            String string = stringArray[i].substring(0, stringArray[i].length() - ".xml".length()) + ".hyp";
            File file4 = new File(file2, string);
            this.serializeFile(file3, file4);
        }
    }

    private void serializeFile(File file, File file2) {
        boolean bl = this.rebuild(file, file2);
        if (bl) {
            HyphenationTree hyphenationTree = this.buildPatternFile(file);
            try {
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(file2)));
                objectOutputStream.writeObject(hyphenationTree);
                objectOutputStream.close();
            }
            catch (IOException iOException) {
                System.err.println("Can't write compiled pattern file: " + file2);
                System.err.println(iOException);
            }
        }
    }

    private HyphenationTree buildPatternFile(File file) {
        HyphenationTree hyphenationTree;
        block3: {
            System.out.println("Processing " + file);
            hyphenationTree = new HyphenationTree();
            try {
                hyphenationTree.loadPatterns(file.toString());
                if (this.errorDump) {
                    System.out.println("Stats: ");
                    hyphenationTree.printStats();
                }
            }
            catch (HyphenationException hyphenationException) {
                System.err.println("Can't load patterns from xml file " + file + " - Maybe hyphenation.dtd is missing?");
                if (!this.errorDump) break block3;
                System.err.println(hyphenationException.toString());
            }
        }
        return hyphenationTree;
    }

    private boolean rebuild(File file, File file2) {
        if (file2.exists()) {
            return file2.lastModified() < file.lastModified();
        }
        return true;
    }

    public static void main(String[] stringArray) {
        SerializeHyphPattern serializeHyphPattern = new SerializeHyphPattern();
        serializeHyphPattern.serializeDir(new File(stringArray[0]), new File(stringArray[1]));
    }
}

