/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.image.loader.batik;

import java.awt.Dimension;
import java.awt.geom.AffineTransform;
import java.util.Map;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.image.loader.batik.BatikUtil;
import org.apache.fop.image.loader.batik.GenericFOPBridgeContext;
import org.apache.fop.image.loader.batik.Graphics2DImagePainterImpl;
import org.apache.fop.svg.SimpleSVGUserAgent;
import org.apache.xmlgraphics.image.loader.Image;
import org.apache.xmlgraphics.image.loader.ImageException;
import org.apache.xmlgraphics.image.loader.ImageFlavor;
import org.apache.xmlgraphics.image.loader.ImageInfo;
import org.apache.xmlgraphics.image.loader.ImageManager;
import org.apache.xmlgraphics.image.loader.ImageProcessingHints;
import org.apache.xmlgraphics.image.loader.ImageSessionContext;
import org.apache.xmlgraphics.image.loader.XMLNamespaceEnabledImageFlavor;
import org.apache.xmlgraphics.image.loader.impl.AbstractImageConverter;
import org.apache.xmlgraphics.image.loader.impl.ImageGraphics2D;
import org.apache.xmlgraphics.image.loader.impl.ImageXMLDOM;
import org.apache.xmlgraphics.java2d.Graphics2DImagePainter;
import org.w3c.dom.Document;

public class ImageConverterSVG2G2D
extends AbstractImageConverter {
    private static Log log = LogFactory.getLog(ImageConverterSVG2G2D.class);

    public Image convert(Image image, Map map) throws ImageException {
        GraphicsNode graphicsNode;
        this.checkSourceFlavor(image);
        ImageXMLDOM imageXMLDOM = (ImageXMLDOM)image;
        if (!"http://www.w3.org/2000/svg".equals(imageXMLDOM.getRootNamespace())) {
            throw new IllegalArgumentException("XML DOM is not in the SVG namespace: " + imageXMLDOM.getRootNamespace());
        }
        float f = 0.35277778f;
        Number number = (Number)map.get(ImageProcessingHints.SOURCE_RESOLUTION);
        if (number != null) {
            f = (float)((double)25.4f / number.doubleValue());
        }
        SimpleSVGUserAgent simpleSVGUserAgent = this.createBatikUserAgent(f);
        GVTBuilder gVTBuilder = new GVTBuilder();
        ImageManager imageManager = (ImageManager)map.get(ImageProcessingHints.IMAGE_MANAGER);
        ImageSessionContext imageSessionContext = (ImageSessionContext)map.get(ImageProcessingHints.IMAGE_SESSION_CONTEXT);
        boolean bl = imageManager != null && imageSessionContext != null;
        GenericFOPBridgeContext genericFOPBridgeContext = bl ? new GenericFOPBridgeContext((UserAgent)simpleSVGUserAgent, null, imageManager, imageSessionContext) : new BridgeContext((UserAgent)simpleSVGUserAgent);
        Document document = imageXMLDOM.getDocument();
        Document document2 = BatikUtil.cloneSVGDocument(document);
        try {
            graphicsNode = gVTBuilder.build((BridgeContext)genericFOPBridgeContext, document2);
        }
        catch (Exception exception) {
            throw new ImageException("GVT tree could not be built for SVG graphic", (Throwable)exception);
        }
        int n = imageXMLDOM.getSize().getWidthMpt();
        int n2 = imageXMLDOM.getSize().getHeightMpt();
        Dimension dimension = new Dimension(n, n2);
        Graphics2DImagePainter graphics2DImagePainter = this.createPainter(genericFOPBridgeContext, graphicsNode, dimension);
        ImageInfo imageInfo = image.getInfo();
        ImageGraphics2D imageGraphics2D = new ImageGraphics2D(imageInfo, graphics2DImagePainter);
        return imageGraphics2D;
    }

    protected SimpleSVGUserAgent createBatikUserAgent(float f) {
        return new SimpleSVGUserAgent(f, new AffineTransform()){

            public void displayMessage(String string) {
                log.info((Object)string);
            }

            public void displayError(Exception exception) {
                log.error((Object)"Error converting SVG to a Java2D graphic", (Throwable)exception);
            }

            public void displayError(String string) {
                log.error((Object)string);
            }
        };
    }

    protected Graphics2DImagePainter createPainter(BridgeContext bridgeContext, GraphicsNode graphicsNode, Dimension dimension) {
        return new Graphics2DImagePainterImpl(graphicsNode, bridgeContext, dimension);
    }

    public ImageFlavor getSourceFlavor() {
        return XMLNamespaceEnabledImageFlavor.SVG_DOM;
    }

    public ImageFlavor getTargetFlavor() {
        return ImageFlavor.GRAPHICS2D;
    }
}

