/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr;

import java.util.LinkedList;
import java.util.List;
import org.apache.fop.layoutmgr.BreakElement;
import org.apache.fop.layoutmgr.KnuthBox;
import org.apache.fop.layoutmgr.KnuthElement;
import org.apache.fop.layoutmgr.KnuthGlue;
import org.apache.fop.layoutmgr.KnuthPenalty;
import org.apache.fop.layoutmgr.KnuthSequence;
import org.apache.fop.layoutmgr.ListElement;
import org.apache.fop.layoutmgr.inline.InlineLevelLayoutManager;
import org.apache.fop.layoutmgr.inline.KnuthInlineBox;

public class InlineKnuthSequence
extends KnuthSequence {
    private static final long serialVersionUID = 1354774188859946549L;
    private boolean isClosed = false;

    public InlineKnuthSequence() {
    }

    public InlineKnuthSequence(List list) {
        super(list);
    }

    public boolean isInlineSequence() {
        return true;
    }

    public boolean canAppendSequence(KnuthSequence knuthSequence) {
        return knuthSequence.isInlineSequence() && !this.isClosed;
    }

    public boolean appendSequence(KnuthSequence knuthSequence) {
        if (!this.canAppendSequence(knuthSequence)) {
            return false;
        }
        ListElement listElement = this.getLast();
        ListElement listElement2 = knuthSequence.getElement(0);
        if (listElement2.isBox() && !((KnuthElement)listElement2).isAuxiliary() && listElement.isBox() && ((KnuthElement)listElement).getWidth() != 0) {
            this.addALetterSpace();
        }
        this.addAll(knuthSequence);
        return true;
    }

    public boolean appendSequence(KnuthSequence knuthSequence, boolean bl, BreakElement breakElement) {
        return this.appendSequence(knuthSequence);
    }

    public KnuthSequence endSequence() {
        if (!this.isClosed) {
            this.add(new KnuthPenalty(0, -1000, false, null, false));
            this.isClosed = true;
        }
        return this;
    }

    public void addALetterSpace() {
        KnuthBox knuthBox = (KnuthBox)this.getLast();
        if (!(!knuthBox.isAuxiliary() || this.size() >= 4 && this.getElement(this.size() - 2).isGlue() && this.getElement(this.size() - 3).isPenalty() && this.getElement(this.size() - 4).isBox())) {
            return;
        }
        this.removeLast();
        LinkedList<KnuthElement> linkedList = new LinkedList<KnuthElement>();
        if (!knuthBox.isAuxiliary()) {
            linkedList.add(knuthBox);
        } else {
            linkedList.add(knuthBox);
            linkedList.addFirst((KnuthGlue)this.removeLast());
            linkedList.addFirst((KnuthPenalty)this.removeLast());
            linkedList.addFirst((KnuthBox)this.removeLast());
        }
        this.addAll(((InlineLevelLayoutManager)knuthBox.getLayoutManager()).addALetterSpaceTo(linkedList));
        if (knuthBox instanceof KnuthInlineBox && ((KnuthInlineBox)knuthBox).isAnchor()) {
            KnuthInlineBox knuthInlineBox = (KnuthInlineBox)this.getLast();
            knuthInlineBox.setFootnoteBodyLM(((KnuthInlineBox)knuthBox).getFootnoteBodyLM());
        }
    }
}

