/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr;

import org.apache.fop.fo.properties.KeepProperty;
import org.apache.fop.fo.properties.Property;

public final class Keep {
    private static final int STRENGTH_AUTO = Integer.MIN_VALUE;
    private static final int STRENGTH_ALWAYS = Integer.MAX_VALUE;
    public static final Keep KEEP_AUTO = new Keep(Integer.MIN_VALUE, 9);
    public static final Keep KEEP_ALWAYS = new Keep(Integer.MAX_VALUE, 75);
    private int strength;
    private int context;

    private Keep(int n, int n2) {
        this.strength = n;
        this.context = n2;
    }

    private static int getKeepStrength(Property property) {
        if (property.isAuto()) {
            return Integer.MIN_VALUE;
        }
        if (property.getEnum() == 7) {
            return Integer.MAX_VALUE;
        }
        return property.getNumber().intValue();
    }

    public static Keep getKeep(KeepProperty keepProperty) {
        Keep keep = new Keep(Integer.MIN_VALUE, 9);
        keep.update(keepProperty.getWithinPage(), 104);
        keep.update(keepProperty.getWithinColumn(), 28);
        keep.update(keepProperty.getWithinLine(), 75);
        return keep;
    }

    private void update(Property property, int n) {
        if (!property.isAuto()) {
            this.strength = Keep.getKeepStrength(property);
            this.context = n;
        }
    }

    public boolean isAuto() {
        return this.strength == Integer.MIN_VALUE;
    }

    public int getContext() {
        return this.context;
    }

    public int getPenalty() {
        if (this.strength == Integer.MIN_VALUE) {
            return 0;
        }
        if (this.strength == Integer.MAX_VALUE) {
            return 1000;
        }
        return 999;
    }

    private static int getKeepContextPriority(int n) {
        switch (n) {
            case 75: {
                return 0;
            }
            case 28: {
                return 1;
            }
            case 104: {
                return 2;
            }
            case 9: {
                return 3;
            }
        }
        throw new IllegalArgumentException();
    }

    public Keep compare(Keep keep) {
        int n;
        if (this.strength == Integer.MAX_VALUE && this.strength > keep.strength) {
            return this;
        }
        if (keep.strength == Integer.MAX_VALUE && keep.strength > this.strength) {
            return keep;
        }
        int n2 = Keep.getKeepContextPriority(this.context);
        if (n2 == (n = Keep.getKeepContextPriority(keep.context))) {
            return this.strength >= keep.strength ? this : keep;
        }
        return n2 < n ? this : keep;
    }

    public String toString() {
        return this.strength == Integer.MIN_VALUE ? "auto" : (this.strength == Integer.MAX_VALUE ? "always" : Integer.toString(this.strength));
    }
}

