/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.fo.FObj;
import org.apache.fop.layoutmgr.AbstractBreaker;
import org.apache.fop.layoutmgr.BreakingAlgorithm;
import org.apache.fop.layoutmgr.KnuthBlockBox;
import org.apache.fop.layoutmgr.KnuthBox;
import org.apache.fop.layoutmgr.KnuthElement;
import org.apache.fop.layoutmgr.KnuthPenalty;
import org.apache.fop.layoutmgr.KnuthSequence;
import org.apache.fop.layoutmgr.LayoutManager;
import org.apache.fop.layoutmgr.PageProvider;
import org.apache.fop.layoutmgr.SpaceResolver;
import org.apache.fop.traits.MinOptMax;
import org.apache.fop.util.ListUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PageBreakingAlgorithm
extends BreakingAlgorithm {
    private static Log log = LogFactory.getLog(PageBreakingAlgorithm.class);
    private LayoutManager topLevelLM;
    private PageProvider pageProvider;
    private PageBreakingLayoutListener layoutListener;
    private LinkedList<AbstractBreaker.PageBreakPosition> pageBreaks = null;
    private List<List<KnuthElement>> footnotesList = null;
    private List<Integer> lengthList = null;
    private int totalFootnotesLength = 0;
    private int insertedFootnotesLength = 0;
    private boolean footnotesPending = false;
    private boolean newFootnotes = false;
    private int firstNewFootnoteIndex = 0;
    private int footnoteListIndex = 0;
    private int footnoteElementIndex = -1;
    private int splitFootnoteDemerits = 5000;
    private int deferredFootnoteDemerits = 10000;
    private MinOptMax footnoteSeparatorLength = null;
    private int storedPrevBreakIndex = -1;
    private int storedBreakIndex = -1;
    private boolean storedValue = false;
    private boolean autoHeight = false;
    private boolean favorSinglePart = false;
    private int ipdDifference;
    private BreakingAlgorithm.KnuthNode bestNodeForIPDChange;
    private int currentKeepContext = 9;
    private BreakingAlgorithm.KnuthNode lastBeforeKeepContextSwitch;

    public PageBreakingAlgorithm(LayoutManager layoutManager, PageProvider pageProvider, PageBreakingLayoutListener pageBreakingLayoutListener, int n, int n2, MinOptMax minOptMax, boolean bl, boolean bl2, boolean bl3) {
        super(n, n2, true, bl, 0);
        this.topLevelLM = layoutManager;
        this.pageProvider = pageProvider;
        this.layoutListener = pageBreakingLayoutListener;
        this.best = new BestPageRecords();
        this.footnoteSeparatorLength = minOptMax;
        this.autoHeight = bl2;
        this.favorSinglePart = bl3;
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.insertedFootnotesLength = 0;
        this.footnoteListIndex = 0;
        this.footnoteElementIndex = -1;
    }

    @Override
    protected BreakingAlgorithm.KnuthNode recoverFromTooLong(BreakingAlgorithm.KnuthNode knuthNode) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Recovering from too long: " + knuthNode));
            log.debug((Object)("\tlastTooShort = " + this.getLastTooShort()));
            log.debug((Object)("\tlastBeforeKeepContextSwitch = " + this.lastBeforeKeepContextSwitch));
            log.debug((Object)("\tcurrentKeepContext = " + AbstractBreaker.getBreakClassName(this.currentKeepContext)));
        }
        if (this.lastBeforeKeepContextSwitch == null || this.currentKeepContext == 9) {
            return super.recoverFromTooLong(knuthNode);
        }
        BreakingAlgorithm.KnuthNode knuthNode2 = this.lastBeforeKeepContextSwitch;
        this.lastBeforeKeepContextSwitch = null;
        while (!this.pageProvider.endPage(knuthNode2.line - 1)) {
            log.trace((Object)"Adding node for empty column");
            knuthNode2 = this.createNode(knuthNode2.position, knuthNode2.line + 1, 1, 0, 0, 0, 0.0, 0, 0, 0, 0.0, knuthNode2);
        }
        return knuthNode2;
    }

    @Override
    protected BreakingAlgorithm.KnuthNode compareNodes(BreakingAlgorithm.KnuthNode knuthNode, BreakingAlgorithm.KnuthNode knuthNode2) {
        if (knuthNode == null || knuthNode2 == null) {
            return knuthNode == null ? knuthNode2 : knuthNode;
        }
        if (this.pageProvider != null) {
            if (this.pageProvider.endPage(knuthNode.line - 1) && !this.pageProvider.endPage(knuthNode2.line - 1)) {
                return knuthNode;
            }
            if (this.pageProvider.endPage(knuthNode2.line - 1) && !this.pageProvider.endPage(knuthNode.line - 1)) {
                return knuthNode2;
            }
        }
        return super.compareNodes(knuthNode, knuthNode2);
    }

    @Override
    protected BreakingAlgorithm.KnuthNode createNode(int n, int n2, int n3, int n4, int n5, int n6, double d, int n7, int n8, int n9, double d2, BreakingAlgorithm.KnuthNode knuthNode) {
        return new KnuthPageNode(n, n2, n3, n4, n5, n6, this.insertedFootnotesLength, this.footnoteListIndex, this.footnoteElementIndex, d, n7, n8, n9, d2, knuthNode);
    }

    @Override
    protected BreakingAlgorithm.KnuthNode createNode(int n, int n2, int n3, int n4, int n5, int n6) {
        return new KnuthPageNode(n, n2, n3, n4, n5, n6, ((BestPageRecords)this.best).getFootnotesLength(n3), ((BestPageRecords)this.best).getFootnoteListIndex(n3), ((BestPageRecords)this.best).getFootnoteElementIndex(n3), this.best.getAdjust(n3), this.best.getAvailableShrink(n3), this.best.getAvailableStretch(n3), this.best.getDifference(n3), this.best.getDemerits(n3), this.best.getNode(n3));
    }

    @Override
    protected void handleBox(KnuthBox knuthBox) {
        super.handleBox(knuthBox);
        if (knuthBox instanceof KnuthBlockBox && ((KnuthBlockBox)knuthBox).hasAnchors()) {
            this.handleFootnotes(((KnuthBlockBox)knuthBox).getElementLists());
            if (!this.newFootnotes) {
                this.newFootnotes = true;
                this.firstNewFootnoteIndex = this.footnotesList.size() - 1;
            }
        }
    }

    @Override
    protected void handlePenaltyAt(KnuthPenalty knuthPenalty, int n, int n2) {
        int n3;
        super.handlePenaltyAt(knuthPenalty, n, n2);
        if (knuthPenalty.getPenalty() == 1000 && ((n3 = knuthPenalty.getBreakClass()) == 104 || n3 == 28)) {
            this.considerLegalBreak(knuthPenalty, n);
        }
    }

    private void handleFootnotes(List<List<KnuthElement>> list) {
        if (!this.footnotesPending) {
            this.footnotesPending = true;
            this.footnotesList = new ArrayList<List<KnuthElement>>();
            this.lengthList = new ArrayList<Integer>();
            this.totalFootnotesLength = 0;
        }
        if (!this.newFootnotes) {
            this.newFootnotes = true;
            this.firstNewFootnoteIndex = this.footnotesList.size();
        }
        for (List<KnuthElement> list2 : list) {
            int n;
            SpaceResolver.resolveElementList(list2);
            int n2 = 0;
            this.footnotesList.add(list2);
            for (KnuthElement knuthElement : list2) {
                if (!knuthElement.isBox() && !knuthElement.isGlue()) continue;
                n2 += knuthElement.getWidth();
            }
            int n3 = n = this.lengthList == null || this.lengthList.isEmpty() ? 0 : ListUtil.getLast(this.lengthList);
            if (this.lengthList != null) {
                this.lengthList.add(n + n2);
            }
            this.totalFootnotesLength += n2;
        }
    }

    @Override
    protected int restartFrom(BreakingAlgorithm.KnuthNode knuthNode, int n) {
        int n2 = super.restartFrom(knuthNode, n);
        this.newFootnotes = false;
        if (this.footnotesPending) {
            for (int i = n; i >= knuthNode.position; --i) {
                KnuthElement knuthElement = this.getElement(i);
                if (!(knuthElement instanceof KnuthBlockBox) || !((KnuthBlockBox)knuthElement).hasAnchors()) continue;
                this.resetFootnotes(((KnuthBlockBox)knuthElement).getElementLists());
            }
        }
        return n2;
    }

    private void resetFootnotes(List<List<KnuthElement>> list) {
        for (int i = 0; i < list.size(); ++i) {
            ListUtil.removeLast(this.footnotesList);
            ListUtil.removeLast(this.lengthList);
            this.totalFootnotesLength = !this.lengthList.isEmpty() ? ListUtil.getLast(this.lengthList) : 0;
        }
        if (this.footnotesList.size() == 0) {
            this.footnotesPending = false;
        }
    }

    @Override
    protected void considerLegalBreak(KnuthElement knuthElement, int n) {
        if (knuthElement.isPenalty()) {
            int n2 = ((KnuthPenalty)knuthElement).getBreakClass();
            switch (n2) {
                case 104: {
                    if (this.currentKeepContext != n2) {
                        this.lastBeforeKeepContextSwitch = this.getLastTooShort();
                    }
                    this.currentKeepContext = n2;
                    break;
                }
                case 28: {
                    if (this.currentKeepContext != n2) {
                        this.lastBeforeKeepContextSwitch = this.getLastTooShort();
                    }
                    this.currentKeepContext = n2;
                    break;
                }
                case 9: {
                    this.currentKeepContext = n2;
                    break;
                }
            }
        }
        super.considerLegalBreak(knuthElement, n);
        this.newFootnotes = false;
    }

    @Override
    protected boolean elementCanEndLine(KnuthElement knuthElement, int n, int n2) {
        if (!knuthElement.isPenalty() || this.pageProvider == null) {
            return true;
        }
        KnuthPenalty knuthPenalty = (KnuthPenalty)knuthElement;
        if (knuthPenalty.getPenalty() <= 0) {
            return true;
        }
        int n3 = knuthPenalty.getBreakClass();
        switch (n3) {
            case 28: 
            case 75: {
                return knuthPenalty.getPenalty() < 1000;
            }
            case 104: {
                return knuthPenalty.getPenalty() < 1000 || !this.pageProvider.endPage(n - 1);
            }
            case 9: {
                log.debug((Object)"keep is not auto but context is");
                return true;
            }
        }
        if (knuthPenalty.getPenalty() < 1000) {
            log.debug((Object)("Non recognized keep context:" + n3));
            return true;
        }
        return false;
    }

    @Override
    protected int computeDifference(BreakingAlgorithm.KnuthNode knuthNode, KnuthElement knuthElement, int n) {
        int n2;
        KnuthPageNode knuthPageNode = (KnuthPageNode)knuthNode;
        int n3 = this.totalWidth - knuthPageNode.totalWidth;
        if (knuthElement.isPenalty()) {
            n3 += knuthElement.getWidth();
        }
        if (this.footnotesPending && (n2 = this.totalFootnotesLength - knuthPageNode.totalFootnotes) > 0) {
            if ((n3 += this.footnoteSeparatorLength.getOpt()) + n2 <= this.getLineWidth(knuthNode.line)) {
                n3 += n2;
                this.insertedFootnotesLength = knuthPageNode.totalFootnotes + n2;
                this.footnoteListIndex = this.footnotesList.size() - 1;
                this.footnoteElementIndex = this.getFootnoteList(this.footnoteListIndex).size() - 1;
            } else {
                int n4;
                boolean bl = this.canDeferOldFootnotes(knuthPageNode, n);
                if ((bl || this.newFootnotes) && (n4 = this.getFootnoteSplit(knuthPageNode, this.getLineWidth(knuthNode.line) - n3, bl)) > 0) {
                    n3 += n4;
                    this.insertedFootnotesLength = knuthPageNode.totalFootnotes + n4;
                } else {
                    n3 += n2;
                    this.insertedFootnotesLength = knuthPageNode.totalFootnotes + n2;
                    this.footnoteListIndex = this.footnotesList.size() - 1;
                    this.footnoteElementIndex = this.getFootnoteList(this.footnoteListIndex).size() - 1;
                }
            }
        }
        n2 = this.getLineWidth(knuthNode.line) - n3;
        if (this.autoHeight && n2 < 0) {
            return 0;
        }
        return n2;
    }

    private boolean canDeferOldFootnotes(KnuthPageNode knuthPageNode, int n) {
        return this.noBreakBetween(knuthPageNode.position, n) && this.deferredFootnotes(knuthPageNode.footnoteListIndex, knuthPageNode.footnoteElementIndex, knuthPageNode.totalFootnotes);
    }

    private boolean noBreakBetween(int n, int n2) {
        if (this.storedPrevBreakIndex == -1 || (n < this.storedPrevBreakIndex || n2 != this.storedBreakIndex || !this.storedValue) && (n > this.storedPrevBreakIndex || n2 < this.storedBreakIndex || this.storedValue)) {
            int n3 = n + 1;
            while (!this.par.getElement(n3).isBox()) {
                ++n3;
            }
            while (!(n3 >= n2 || this.par.getElement(n3).isGlue() && this.par.getElement(n3 - 1).isBox() || this.par.getElement(n3).isPenalty() && ((KnuthElement)this.par.getElement(n3)).getPenalty() < 1000)) {
                ++n3;
            }
            this.storedPrevBreakIndex = n;
            this.storedBreakIndex = n2;
            this.storedValue = n3 == n2;
        }
        return this.storedValue;
    }

    private boolean deferredFootnotes(int n, int n2, int n3) {
        return this.newFootnotes && this.firstNewFootnoteIndex != 0 && (n < this.firstNewFootnoteIndex - 1 || n2 < this.getFootnoteList(n).size() - 1) || n3 < this.totalFootnotesLength;
    }

    private int getFootnoteSplit(KnuthPageNode knuthPageNode, int n, boolean bl) {
        return this.getFootnoteSplit(knuthPageNode.footnoteListIndex, knuthPageNode.footnoteElementIndex, knuthPageNode.totalFootnotes, n, bl);
    }

    private int getFootnoteSplit(int n, int n2, int n3, int n4, boolean bl) {
        if (n4 <= 0) {
            return 0;
        }
        int n5 = 0;
        boolean bl2 = false;
        int n6 = n2;
        int n7 = n;
        if (n6 == this.getFootnoteList(n7).size() - 1) {
            ++n7;
            n6 = 0;
        } else {
            ++n6;
        }
        if (this.footnotesList.size() - 1 > n7) {
            if (!bl && this.newFootnotes && this.firstNewFootnoteIndex > 0) {
                n5 = this.lengthList.get(this.firstNewFootnoteIndex - 1) - n3;
                n7 = this.firstNewFootnoteIndex;
                n6 = 0;
            }
            while (this.lengthList.get(n7) - n3 <= n4) {
                n5 = this.lengthList.get(n7) - n3;
                bl2 = true;
                ++n7;
                n6 = 0;
            }
        }
        ListIterator<KnuthElement> listIterator = this.getFootnoteList(n7).listIterator(n6);
        int n8 = 0;
        int n9 = -1;
        int n10 = -1;
        block1: while (!bl2 || n5 <= n4) {
            if (!bl2) {
                bl2 = true;
            } else {
                n8 = n5;
                n9 = n10;
            }
            boolean bl3 = false;
            while (listIterator.hasNext()) {
                KnuthElement knuthElement = listIterator.next();
                if (knuthElement.isBox()) {
                    n5 += knuthElement.getWidth();
                    bl3 = true;
                    continue;
                }
                if (knuthElement.isGlue()) {
                    if (bl3) {
                        n10 = listIterator.previousIndex();
                        continue block1;
                    }
                    bl3 = false;
                    n5 += knuthElement.getWidth();
                    continue;
                }
                if (knuthElement.getPenalty() >= 1000) continue;
                n10 = listIterator.previousIndex();
                continue block1;
            }
        }
        if (!bl2) {
            n8 = 0;
        } else if (n8 > 0) {
            this.footnoteListIndex = n9 != -1 ? n7 : n7 - 1;
            this.footnoteElementIndex = n9 != -1 ? n9 : this.getFootnoteList(this.footnoteListIndex).size() - 1;
        }
        return n8;
    }

    @Override
    protected double computeAdjustmentRatio(BreakingAlgorithm.KnuthNode knuthNode, int n) {
        if (n > 0) {
            int n2 = this.totalStretch - knuthNode.totalStretch;
            if (((KnuthPageNode)knuthNode).totalFootnotes < this.totalFootnotesLength) {
                n2 += this.footnoteSeparatorLength.getStretch();
            }
            if (n2 > 0) {
                return (double)n / (double)n2;
            }
            return 1000.0;
        }
        if (n < 0) {
            int n3 = this.totalShrink - knuthNode.totalShrink;
            if (((KnuthPageNode)knuthNode).totalFootnotes < this.totalFootnotesLength) {
                n3 += this.footnoteSeparatorLength.getShrink();
            }
            if (n3 > 0) {
                return (double)n / (double)n3;
            }
            return -1000.0;
        }
        return 0.0;
    }

    @Override
    protected double computeDemerits(BreakingAlgorithm.KnuthNode knuthNode, KnuthElement knuthElement, int n, double d) {
        double d2;
        double d3 = 0.0;
        double d4 = Math.abs(d);
        d4 = 1.0 + 100.0 * d4 * d4 * d4;
        d3 = knuthElement.isPenalty() ? ((d2 = (double)knuthElement.getPenalty()) >= 0.0 ? (d4 += d2) * d4 : (!knuthElement.isForcedBreak() ? d4 * d4 - d2 * d2 : d4 * d4)) : d4 * d4;
        if (knuthElement.isPenalty() && ((KnuthPenalty)knuthElement).isPenaltyFlagged() && this.getElement(knuthNode.position).isPenalty() && ((KnuthPenalty)this.getElement(knuthNode.position)).isPenaltyFlagged()) {
            d3 += (double)this.repeatedFlaggedDemerit;
        }
        if (Math.abs(n - knuthNode.fitness) > 1) {
            d3 += (double)this.incompatibleFitnessDemerit;
        }
        if (this.footnotesPending) {
            if (this.footnoteListIndex < this.footnotesList.size() - 1) {
                d3 += (double)((this.footnotesList.size() - 1 - this.footnoteListIndex) * this.deferredFootnoteDemerits);
            }
            if (this.footnoteListIndex < this.footnotesList.size() && this.footnoteElementIndex < this.getFootnoteList(this.footnoteListIndex).size() - 1) {
                d3 += (double)this.splitFootnoteDemerits;
            }
        }
        return d3 += knuthNode.totalDemerits;
    }

    @Override
    protected void finish() {
        for (int i = this.startLine; i < this.endLine; ++i) {
            KnuthPageNode knuthPageNode = (KnuthPageNode)this.getNode(i);
            while (knuthPageNode != null) {
                if (knuthPageNode.totalFootnotes < this.totalFootnotesLength) {
                    this.createFootnotePages(knuthPageNode);
                }
                knuthPageNode = (KnuthPageNode)knuthPageNode.next;
            }
        }
    }

    private void createFootnotePages(KnuthPageNode knuthPageNode) {
        this.insertedFootnotesLength = knuthPageNode.totalFootnotes;
        this.footnoteListIndex = knuthPageNode.footnoteListIndex;
        this.footnoteElementIndex = knuthPageNode.footnoteElementIndex;
        int n = this.getLineWidth(knuthPageNode.line);
        int n2 = 0;
        KnuthPageNode knuthPageNode2 = knuthPageNode;
        while (this.insertedFootnotesLength < this.totalFootnotesLength) {
            int n3 = this.lengthList.get(this.footnoteListIndex);
            if (n3 - this.insertedFootnotesLength <= n) {
                n -= n3 - this.insertedFootnotesLength;
                this.insertedFootnotesLength = n3;
                this.footnoteElementIndex = this.getFootnoteList(this.footnoteListIndex).size() - 1;
                continue;
            }
            n2 = this.getFootnoteSplit(this.footnoteListIndex, this.footnoteElementIndex, this.insertedFootnotesLength, n, true);
            if (n2 > 0) {
                n -= n2;
                this.insertedFootnotesLength += n2;
                continue;
            }
            KnuthPageNode knuthPageNode3 = (KnuthPageNode)this.createNode(knuthPageNode.position, knuthPageNode2.line + 1, 1, this.insertedFootnotesLength - knuthPageNode2.totalFootnotes, 0, 0, 0.0, 0, 0, 0, 0.0, knuthPageNode2);
            this.addNode(knuthPageNode3.line, knuthPageNode3);
            this.removeNode(knuthPageNode2.line, knuthPageNode2);
            knuthPageNode2 = knuthPageNode3;
            n = this.getLineWidth(knuthPageNode3.line);
        }
        KnuthPageNode knuthPageNode4 = (KnuthPageNode)this.createNode(knuthPageNode.position, knuthPageNode2.line + 1, 1, this.totalFootnotesLength - knuthPageNode2.totalFootnotes, 0, 0, 0.0, 0, 0, 0, 0.0, knuthPageNode2);
        this.addNode(knuthPageNode4.line, knuthPageNode4);
        this.removeNode(knuthPageNode2.line, knuthPageNode2);
    }

    public LinkedList<AbstractBreaker.PageBreakPosition> getPageBreaks() {
        return this.pageBreaks;
    }

    public void insertPageBreakAsFirst(AbstractBreaker.PageBreakPosition pageBreakPosition) {
        if (this.pageBreaks == null) {
            this.pageBreaks = new LinkedList();
        }
        this.pageBreaks.addFirst(pageBreakPosition);
    }

    public void removeAllPageBreaks() {
        if (this.pageBreaks == null || this.pageBreaks.isEmpty()) {
            return;
        }
        this.pageBreaks.subList(0, this.pageBreaks.size() - 1).clear();
    }

    @Override
    public void updateData1(int n, double d) {
    }

    @Override
    public void updateData2(BreakingAlgorithm.KnuthNode knuthNode, KnuthSequence knuthSequence, int n) {
        int n2 = knuthNode.difference;
        if (n2 + knuthNode.availableShrink < 0 && !this.autoHeight && this.layoutListener != null) {
            this.layoutListener.notifyOverflow(knuthNode.line - 1, -n2, this.getFObj());
        }
        boolean bl = knuthNode.line < n;
        int n3 = bl ? this.alignment : this.alignmentLast;
        double d = knuthNode.adjustRatio;
        if (d < 0.0) {
            n2 = 0;
        } else if (d <= 1.0 && bl) {
            n2 = 0;
        } else if (d > 1.0) {
            d = 1.0;
            n2 -= knuthNode.availableStretch;
        } else if (n3 != 70) {
            d = 0.0;
        } else {
            n2 = 0;
        }
        int n4 = ((KnuthPageNode)knuthNode.previous).footnoteListIndex;
        int n5 = ((KnuthPageNode)knuthNode.previous).footnoteElementIndex;
        if (this.footnotesList != null && n5 == this.getFootnoteList(n4).size() - 1) {
            ++n4;
            n5 = 0;
        } else {
            ++n5;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("BBA> difference=" + n2 + " ratio=" + d + " position=" + knuthNode.position));
        }
        this.insertPageBreakAsFirst(new AbstractBreaker.PageBreakPosition(this.topLevelLM, knuthNode.position, n4, n5, ((KnuthPageNode)knuthNode).footnoteListIndex, ((KnuthPageNode)knuthNode).footnoteElementIndex, d, n2));
    }

    @Override
    protected int filterActiveNodes() {
        BreakingAlgorithm.KnuthNode knuthNode = null;
        for (int i = this.startLine; i < this.endLine; ++i) {
            BreakingAlgorithm.KnuthNode knuthNode2 = this.getNode(i);
            while (knuthNode2 != null) {
                if (!this.favorSinglePart || knuthNode2.line <= 1 || knuthNode == null || Math.abs(knuthNode.difference) >= knuthNode.availableShrink) {
                    knuthNode = this.compareNodes(knuthNode, knuthNode2);
                }
                if (knuthNode2 != knuthNode) {
                    this.removeNode(i, knuthNode2);
                }
                knuthNode2 = knuthNode2.next;
            }
        }
        assert (knuthNode != null);
        return knuthNode.line;
    }

    protected final List<KnuthElement> getFootnoteList(int n) {
        return this.footnotesList.get(n);
    }

    public FObj getFObj() {
        return this.topLevelLM.getFObj();
    }

    @Override
    protected int getLineWidth(int n) {
        int n2 = this.pageProvider != null ? this.pageProvider.getAvailableBPD(n) : super.getLineWidth(n);
        if (log.isTraceEnabled()) {
            log.trace((Object)("getLineWidth(" + n + ") -> " + n2));
        }
        return n2;
    }

    @Override
    protected int getIPDdifference() {
        return this.ipdDifference;
    }

    @Override
    protected int handleIpdChange() {
        log.trace((Object)("Best node for ipd change:" + this.bestNodeForIPDChange));
        this.calculateBreakPoints(this.bestNodeForIPDChange, this.par, this.bestNodeForIPDChange.line + 1);
        this.activeLines = null;
        return this.bestNodeForIPDChange.line;
    }

    @Override
    protected void addNode(int n, BreakingAlgorithm.KnuthNode knuthNode) {
        if (knuthNode.position < this.par.size() - 1 && n > 0 && (this.ipdDifference = this.compareIPDs(n - 1)) != 0) {
            log.trace((Object)("IPD changes at page " + n));
            if (this.bestNodeForIPDChange == null || knuthNode.totalDemerits < this.bestNodeForIPDChange.totalDemerits) {
                this.bestNodeForIPDChange = knuthNode;
            }
        } else {
            if (knuthNode.position == this.par.size() - 1) {
                this.ipdDifference = 0;
            }
            super.addNode(n, knuthNode);
        }
    }

    BreakingAlgorithm.KnuthNode getBestNodeBeforeIPDChange() {
        return this.bestNodeForIPDChange;
    }

    private int compareIPDs(int n) {
        if (this.pageProvider == null) {
            return 0;
        }
        return this.pageProvider.compareIPDs(n);
    }

    public static interface PageBreakingLayoutListener {
        public void notifyOverflow(int var1, int var2, FObj var3);
    }

    protected class BestPageRecords
    extends BreakingAlgorithm.BestRecords {
        private int[] bestFootnotesLength = new int[4];
        private int[] bestFootnoteListIndex = new int[4];
        private int[] bestFootnoteElementIndex = new int[4];

        protected BestPageRecords() {
        }

        public void addRecord(double d, BreakingAlgorithm.KnuthNode knuthNode, double d2, int n, int n2, int n3, int n4) {
            super.addRecord(d, knuthNode, d2, n, n2, n3, n4);
            this.bestFootnotesLength[n4] = PageBreakingAlgorithm.this.insertedFootnotesLength;
            this.bestFootnoteListIndex[n4] = PageBreakingAlgorithm.this.footnoteListIndex;
            this.bestFootnoteElementIndex[n4] = PageBreakingAlgorithm.this.footnoteElementIndex;
        }

        public int getFootnotesLength(int n) {
            return this.bestFootnotesLength[n];
        }

        public int getFootnoteListIndex(int n) {
            return this.bestFootnoteListIndex[n];
        }

        public int getFootnoteElementIndex(int n) {
            return this.bestFootnoteElementIndex[n];
        }
    }

    protected class KnuthPageNode
    extends BreakingAlgorithm.KnuthNode {
        public int totalFootnotes;
        public int footnoteListIndex;
        public int footnoteElementIndex;

        public KnuthPageNode(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, double d, int n10, int n11, int n12, double d2, BreakingAlgorithm.KnuthNode knuthNode) {
            super(n, n2, n3, n4, n5, n6, d, n10, n11, n12, d2, knuthNode);
            this.totalFootnotes = n7;
            this.footnoteListIndex = n8;
            this.footnoteElementIndex = n9;
        }
    }
}

