/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.layoutmgr.BorderOrPaddingElement;
import org.apache.fop.layoutmgr.BreakElement;
import org.apache.fop.layoutmgr.KnuthBox;
import org.apache.fop.layoutmgr.KnuthElement;
import org.apache.fop.layoutmgr.KnuthGlue;
import org.apache.fop.layoutmgr.KnuthPenalty;
import org.apache.fop.layoutmgr.ListElement;
import org.apache.fop.layoutmgr.NonLeafPosition;
import org.apache.fop.layoutmgr.Position;
import org.apache.fop.layoutmgr.RelSide;
import org.apache.fop.layoutmgr.SpaceElement;
import org.apache.fop.layoutmgr.UnresolvedListElement;
import org.apache.fop.layoutmgr.UnresolvedListElementWithLength;
import org.apache.fop.traits.MinOptMax;

public final class SpaceResolver {
    private static final Log LOG = LogFactory.getLog(SpaceResolver.class);
    private UnresolvedListElementWithLength[] firstPart;
    private BreakElement breakPoss;
    private UnresolvedListElementWithLength[] secondPart;
    private UnresolvedListElementWithLength[] noBreak;
    private MinOptMax[] firstPartLengths;
    private MinOptMax[] secondPartLengths;
    private MinOptMax[] noBreakLengths;
    private boolean isFirst;
    private boolean isLast;

    private SpaceResolver(List list, BreakElement breakElement, List list2, boolean bl, boolean bl2) {
        ListIterator listIterator;
        this.isFirst = bl;
        this.isLast = bl2;
        int n = 0;
        if (list != null) {
            n += list.size();
        }
        if (list2 != null) {
            n += list2.size();
        }
        this.noBreak = new UnresolvedListElementWithLength[n];
        this.noBreakLengths = new MinOptMax[n];
        int n2 = 0;
        if (list != null) {
            listIterator = list.listIterator();
            while (listIterator.hasNext()) {
                this.noBreak[n2] = (UnresolvedListElementWithLength)listIterator.next();
                this.noBreakLengths[n2] = this.noBreak[n2].getLength();
                ++n2;
            }
        }
        if (list2 != null) {
            listIterator = list2.listIterator();
            while (listIterator.hasNext()) {
                this.noBreak[n2] = (UnresolvedListElementWithLength)listIterator.next();
                this.noBreakLengths[n2] = this.noBreak[n2].getLength();
                ++n2;
            }
        }
        if (breakElement != null) {
            if (breakElement.getPendingAfterMarks() != null) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("    adding pending before break: " + breakElement.getPendingAfterMarks()));
                }
                list.addAll(0, breakElement.getPendingAfterMarks());
            }
            if (breakElement.getPendingBeforeMarks() != null) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("    adding pending after break: " + breakElement.getPendingBeforeMarks()));
                }
                list2.addAll(0, breakElement.getPendingBeforeMarks());
            }
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("before: " + list));
            LOG.trace((Object)("  break: " + breakElement));
            LOG.trace((Object)("after: " + list2));
            LOG.trace((Object)("NO-BREAK: " + this.toString(this.noBreak, this.noBreakLengths)));
        }
        if (list != null) {
            this.firstPart = new UnresolvedListElementWithLength[list.size()];
            this.firstPartLengths = new MinOptMax[this.firstPart.length];
            list.toArray(this.firstPart);
            for (n2 = 0; n2 < this.firstPart.length; ++n2) {
                this.firstPartLengths[n2] = this.firstPart[n2].getLength();
            }
        }
        this.breakPoss = breakElement;
        if (list2 != null) {
            this.secondPart = new UnresolvedListElementWithLength[list2.size()];
            this.secondPartLengths = new MinOptMax[this.secondPart.length];
            list2.toArray(this.secondPart);
            for (n2 = 0; n2 < this.secondPart.length; ++n2) {
                this.secondPartLengths[n2] = this.secondPart[n2].getLength();
            }
        }
        this.resolve();
    }

    private String toString(Object[] objectArray, Object[] objectArray2) {
        if (objectArray.length != objectArray2.length) {
            throw new IllegalArgumentException("The length of both arrays must be equal");
        }
        StringBuffer stringBuffer = new StringBuffer("[");
        for (int i = 0; i < objectArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(String.valueOf(objectArray[i]));
            stringBuffer.append("/");
            stringBuffer.append(String.valueOf(objectArray2[i]));
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    private void removeConditionalBorderAndPadding(UnresolvedListElement[] unresolvedListElementArray, MinOptMax[] minOptMaxArray, boolean bl) {
        for (int i = 0; i < unresolvedListElementArray.length; ++i) {
            BorderOrPaddingElement borderOrPaddingElement;
            int n = bl ? unresolvedListElementArray.length - 1 - i : i;
            if (!(unresolvedListElementArray[n] instanceof BorderOrPaddingElement) || !(borderOrPaddingElement = (BorderOrPaddingElement)unresolvedListElementArray[n]).isConditional() || borderOrPaddingElement.isFirst() || borderOrPaddingElement.isLast()) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Nulling conditional element: " + borderOrPaddingElement));
            }
            minOptMaxArray[n] = null;
        }
        if (LOG.isTraceEnabled() && unresolvedListElementArray.length > 0) {
            LOG.trace((Object)("-->Resulting list: " + this.toString(unresolvedListElementArray, minOptMaxArray)));
        }
    }

    private void performSpaceResolutionRule1(UnresolvedListElement[] unresolvedListElementArray, MinOptMax[] minOptMaxArray, boolean bl) {
        for (int i = 0; i < unresolvedListElementArray.length; ++i) {
            int n = bl ? unresolvedListElementArray.length - 1 - i : i;
            if (minOptMaxArray[n] == null) continue;
            if (unresolvedListElementArray[n] instanceof BorderOrPaddingElement || !unresolvedListElementArray[n].isConditional()) break;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Nulling conditional element using 4.3.1, rule 1: " + unresolvedListElementArray[n]));
            }
            minOptMaxArray[n] = null;
        }
        if (LOG.isTraceEnabled() && unresolvedListElementArray.length > 0) {
            LOG.trace((Object)("-->Resulting list: " + this.toString(unresolvedListElementArray, minOptMaxArray)));
        }
    }

    private void performSpaceResolutionRules2to3(UnresolvedListElement[] unresolvedListElementArray, MinOptMax[] minOptMaxArray, int n, int n2) {
        int n3;
        int n4;
        SpaceElement spaceElement;
        int n5;
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("rule 2-3: " + n + "-" + n2));
        }
        boolean bl = false;
        int n6 = 0;
        for (n5 = n; n5 <= n2; ++n5) {
            if (minOptMaxArray[n5] == null) continue;
            ++n6;
            spaceElement = (SpaceElement)unresolvedListElementArray[n5];
            if (!spaceElement.isForcing()) continue;
            bl = true;
            break;
        }
        if (n6 == 0) {
            return;
        }
        if (bl) {
            for (n5 = n; n5 <= n2; ++n5) {
                if (minOptMaxArray[n5] == null || (spaceElement = (SpaceElement)unresolvedListElementArray[n5]).isForcing()) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Nulling non-forcing space-specifier using 4.3.1, rule 2: " + unresolvedListElementArray[n5]));
                }
                minOptMaxArray[n5] = null;
            }
            return;
        }
        n5 = Integer.MIN_VALUE;
        for (n4 = n; n4 <= n2; ++n4) {
            if (minOptMaxArray[n4] == null) continue;
            spaceElement = (SpaceElement)unresolvedListElementArray[n4];
            n5 = Math.max(n5, spaceElement.getPrecedence());
        }
        if (n5 != 0 && LOG.isDebugEnabled()) {
            LOG.debug((Object)("Highest precedence is " + n5));
        }
        n6 = 0;
        n4 = Integer.MIN_VALUE;
        for (n3 = n; n3 <= n2; ++n3) {
            if (minOptMaxArray[n3] == null) continue;
            spaceElement = (SpaceElement)unresolvedListElementArray[n3];
            if (spaceElement.getPrecedence() != n5) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Nulling space-specifier with precedence " + spaceElement.getPrecedence() + " using 4.3.1, rule 3: " + unresolvedListElementArray[n3]));
                }
                minOptMaxArray[n3] = null;
                continue;
            }
            n4 = Math.max(n4, spaceElement.getLength().getOpt());
            ++n6;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Greatest optimum: " + n4));
        }
        if (n6 <= 1) {
            return;
        }
        n6 = 0;
        for (n3 = n; n3 <= n2; ++n3) {
            if (minOptMaxArray[n3] == null) continue;
            spaceElement = (SpaceElement)unresolvedListElementArray[n3];
            if (spaceElement.getLength().getOpt() < n4) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Nulling space-specifier with smaller optimum length using 4.3.1, rule 3: " + unresolvedListElementArray[n3]));
                }
                minOptMaxArray[n3] = null;
                continue;
            }
            ++n6;
        }
        if (n6 <= 1) {
            return;
        }
        n3 = Integer.MIN_VALUE;
        int n7 = Integer.MAX_VALUE;
        for (int i = n; i <= n2; ++i) {
            if (minOptMaxArray[i] == null) continue;
            spaceElement = (SpaceElement)unresolvedListElementArray[i];
            n3 = Math.max(n3, spaceElement.getLength().getMin());
            n7 = Math.min(n7, spaceElement.getLength().getMax());
            if (n6 > 1) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Nulling non-last space-specifier using 4.3.1, rule 3, second part: " + unresolvedListElementArray[i]));
                }
                minOptMaxArray[i] = null;
                --n6;
                continue;
            }
            minOptMaxArray[i] = MinOptMax.getInstance(n3, minOptMaxArray[i].getOpt(), n7);
        }
        if (LOG.isTraceEnabled() && unresolvedListElementArray.length > 0) {
            LOG.trace((Object)("Remaining spaces: " + n6));
            LOG.trace((Object)("-->Resulting list: " + this.toString(unresolvedListElementArray, minOptMaxArray)));
        }
    }

    private void performSpaceResolutionRules2to3(UnresolvedListElement[] unresolvedListElementArray, MinOptMax[] minOptMaxArray) {
        int n;
        int n2 = n = 0;
        while (n2 < unresolvedListElementArray.length) {
            if (unresolvedListElementArray[n2] instanceof SpaceElement) {
                while (n2 < unresolvedListElementArray.length && (unresolvedListElementArray[n2] == null || unresolvedListElementArray[n2] instanceof SpaceElement)) {
                    ++n2;
                }
                this.performSpaceResolutionRules2to3(unresolvedListElementArray, minOptMaxArray, n, n2 - 1);
            }
            n = ++n2;
        }
    }

    private boolean hasFirstPart() {
        return this.firstPart != null && this.firstPart.length > 0;
    }

    private boolean hasSecondPart() {
        return this.secondPart != null && this.secondPart.length > 0;
    }

    private void resolve() {
        if (this.breakPoss != null) {
            if (this.hasFirstPart()) {
                this.removeConditionalBorderAndPadding(this.firstPart, this.firstPartLengths, true);
                this.performSpaceResolutionRule1(this.firstPart, this.firstPartLengths, true);
                this.performSpaceResolutionRules2to3(this.firstPart, this.firstPartLengths);
            }
            if (this.hasSecondPart()) {
                this.removeConditionalBorderAndPadding(this.secondPart, this.secondPartLengths, false);
                this.performSpaceResolutionRule1(this.secondPart, this.secondPartLengths, false);
                this.performSpaceResolutionRules2to3(this.secondPart, this.secondPartLengths);
            }
            if (this.noBreak != null) {
                this.performSpaceResolutionRules2to3(this.noBreak, this.noBreakLengths);
            }
        } else {
            if (this.isFirst) {
                this.removeConditionalBorderAndPadding(this.secondPart, this.secondPartLengths, false);
                this.performSpaceResolutionRule1(this.secondPart, this.secondPartLengths, false);
            }
            if (this.isLast) {
                this.removeConditionalBorderAndPadding(this.firstPart, this.firstPartLengths, true);
                this.performSpaceResolutionRule1(this.firstPart, this.firstPartLengths, true);
            }
            if (this.hasFirstPart()) {
                LOG.trace((Object)"Swapping first and second parts.");
                UnresolvedListElementWithLength[] unresolvedListElementWithLengthArray = this.secondPart;
                MinOptMax[] minOptMaxArray = this.secondPartLengths;
                this.secondPart = this.firstPart;
                this.secondPartLengths = this.firstPartLengths;
                this.firstPart = unresolvedListElementWithLengthArray;
                this.firstPartLengths = minOptMaxArray;
                if (this.hasFirstPart()) {
                    throw new IllegalStateException("Didn't expect more than one parts in ano-break condition.");
                }
            }
            this.performSpaceResolutionRules2to3(this.secondPart, this.secondPartLengths);
        }
    }

    private MinOptMax sum(MinOptMax[] minOptMaxArray) {
        MinOptMax minOptMax = MinOptMax.ZERO;
        for (int i = 0; i < minOptMaxArray.length; ++i) {
            if (minOptMaxArray[i] == null) continue;
            minOptMax = minOptMax.plus(minOptMaxArray[i]);
        }
        return minOptMax;
    }

    private void generate(ListIterator listIterator) {
        Object object;
        MinOptMax minOptMax = this.sum(this.firstPartLengths);
        MinOptMax minOptMax2 = this.sum(this.secondPartLengths);
        boolean bl = false;
        if (this.breakPoss != null) {
            if (minOptMax.isNonZero()) {
                listIterator.add(new KnuthPenalty(0, 1000, false, null, true));
                listIterator.add(new KnuthGlue(minOptMax, null, true));
                if (this.breakPoss.isForcedBreak()) {
                    listIterator.add(new KnuthBox(0, null, true));
                }
            }
            listIterator.add(new KnuthPenalty(this.breakPoss.getPenaltyWidth(), this.breakPoss.getPenaltyValue(), false, this.breakPoss.getBreakClass(), new SpaceHandlingBreakPosition(this, this.breakPoss), false));
            if (this.breakPoss.getPenaltyValue() <= -1000) {
                return;
            }
            object = this.sum(this.noBreakLengths);
            MinOptMax minOptMax3 = minOptMax.plus(minOptMax2);
            int n = ((MinOptMax)object).getOpt() - minOptMax3.getOpt();
            int n2 = ((MinOptMax)object).getStretch() - minOptMax3.getStretch();
            int n3 = ((MinOptMax)object).getShrink() - minOptMax3.getShrink();
            if (n != 0 || n2 != 0 || n3 != 0) {
                listIterator.add(new KnuthGlue(n, n2, n3, null, true));
            }
        } else if (minOptMax.isNonZero()) {
            throw new IllegalStateException("spaceBeforeBreak should be 0 in this case");
        }
        object = null;
        if (this.breakPoss == null) {
            object = new SpaceHandlingPosition(this);
        }
        if (minOptMax2.isNonZero() || object != null) {
            listIterator.add(new KnuthBox(0, (Position)object, true));
        }
        if (minOptMax2.isNonZero()) {
            listIterator.add(new KnuthPenalty(0, 1000, false, null, true));
            listIterator.add(new KnuthGlue(minOptMax2, null, true));
            bl = true;
        }
        if (this.isLast && bl) {
            listIterator.add(new KnuthBox(0, null, true));
        }
    }

    public static void resolveElementList(List list) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)list);
        }
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        ArrayList<ListElement> arrayList = new ArrayList<ListElement>();
        ArrayList arrayList2 = new ArrayList();
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            ListElement listElement = (ListElement)listIterator.next();
            if (listElement.isUnresolvedElement()) {
                Object object;
                ArrayList<ListElement> arrayList3;
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("unresolved found: " + listElement + " " + bl + "/" + bl2));
                }
                BreakElement breakElement = null;
                arrayList.clear();
                arrayList2.clear();
                if (listElement instanceof BreakElement) {
                    breakElement = (BreakElement)listElement;
                    arrayList3 = arrayList2;
                } else {
                    arrayList3 = arrayList;
                    arrayList3.add(listElement);
                }
                listIterator.remove();
                bl2 = true;
                bl3 = true;
                while (listIterator.hasNext()) {
                    listElement = (ListElement)listIterator.next();
                    if (listElement instanceof BreakElement && breakElement != null) {
                        bl3 = false;
                        bl2 = false;
                        break;
                    }
                    if (arrayList3 == arrayList && listElement instanceof BreakElement) {
                        breakElement = (BreakElement)listElement;
                        listIterator.remove();
                        arrayList3 = arrayList2;
                        continue;
                    }
                    if (listElement.isUnresolvedElement()) {
                        arrayList3.add(listElement);
                        listIterator.remove();
                        continue;
                    }
                    bl2 = false;
                    break;
                }
                if (breakElement == null && arrayList2.isEmpty() && !bl2) {
                    LOG.trace((Object)"Swap first and second parts in no-break condition, second part is empty.");
                    object = arrayList2;
                    arrayList2 = arrayList;
                    arrayList = object;
                }
                LOG.debug((Object)("----start space resolution (first=" + bl + ", last=" + bl2 + ")..."));
                object = new SpaceResolver(arrayList, breakElement, arrayList2, bl, bl2);
                if (!bl2) {
                    listIterator.previous();
                }
                super.generate(listIterator);
                if (!bl2 && bl3) {
                    listIterator.next();
                }
                LOG.debug((Object)"----end space resolution.");
            }
            bl = false;
        }
    }

    public static void performConditionalsNotification(List list, int n, int n2, int n3) {
        Position position;
        KnuthElement knuthElement = null;
        if (n3 > 0) {
            knuthElement = (KnuthElement)list.get(n3);
        }
        SpaceHandlingBreakPosition spaceHandlingBreakPosition = null;
        SpaceHandlingBreakPosition spaceHandlingBreakPosition2 = null;
        if (knuthElement != null && knuthElement.isPenalty() && (position = knuthElement.getPosition()) instanceof SpaceHandlingBreakPosition) {
            spaceHandlingBreakPosition = (SpaceHandlingBreakPosition)position;
            spaceHandlingBreakPosition.notifyBreakSituation(true, RelSide.BEFORE);
        }
        if ((knuthElement = (KnuthElement)list.get(n2)) != null && knuthElement.isPenalty() && (position = knuthElement.getPosition()) instanceof SpaceHandlingBreakPosition) {
            spaceHandlingBreakPosition2 = (SpaceHandlingBreakPosition)position;
            spaceHandlingBreakPosition2.notifyBreakSituation(true, RelSide.AFTER);
        }
        for (int i = n; i <= n2; ++i) {
            SpaceHandlingBreakPosition spaceHandlingBreakPosition3;
            Position position2 = ((KnuthElement)list.get(i)).getPosition();
            if (position2 instanceof SpaceHandlingPosition) {
                ((SpaceHandlingPosition)position2).notifySpaceSituation();
                continue;
            }
            if (!(position2 instanceof SpaceHandlingBreakPosition) || (spaceHandlingBreakPosition3 = (SpaceHandlingBreakPosition)position2) == spaceHandlingBreakPosition || spaceHandlingBreakPosition3 == spaceHandlingBreakPosition2) continue;
            spaceHandlingBreakPosition3.notifyBreakSituation(false, null);
        }
    }

    public static class SpaceHandlingPosition
    extends Position {
        private SpaceResolver resolver;

        public SpaceHandlingPosition(SpaceResolver spaceResolver) {
            super(null);
            this.resolver = spaceResolver;
        }

        public SpaceResolver getSpaceResolver() {
            return this.resolver;
        }

        public void notifySpaceSituation() {
            if (this.resolver.breakPoss != null) {
                throw new IllegalStateException("Only applicable to no-break situations");
            }
            for (int i = 0; i < this.resolver.secondPart.length; ++i) {
                this.resolver.secondPart[i].notifyLayoutManager(this.resolver.secondPartLengths[i]);
            }
        }

        public String toString() {
            return "SpaceHandlingPosition";
        }
    }

    public static class SpaceHandlingBreakPosition
    extends Position {
        private SpaceResolver resolver;
        private Position originalPosition;

        public SpaceHandlingBreakPosition(SpaceResolver spaceResolver, BreakElement breakElement) {
            super(null);
            this.resolver = spaceResolver;
            this.originalPosition = breakElement.getPosition();
            while (this.originalPosition instanceof NonLeafPosition) {
                this.originalPosition = this.originalPosition.getPosition();
            }
        }

        public SpaceResolver getSpaceResolver() {
            return this.resolver;
        }

        public void notifyBreakSituation(boolean bl, RelSide relSide) {
            if (bl) {
                if (RelSide.BEFORE == relSide) {
                    for (int i = 0; i < this.resolver.secondPart.length; ++i) {
                        this.resolver.secondPart[i].notifyLayoutManager(this.resolver.secondPartLengths[i]);
                    }
                } else {
                    for (int i = 0; i < this.resolver.firstPart.length; ++i) {
                        this.resolver.firstPart[i].notifyLayoutManager(this.resolver.firstPartLengths[i]);
                    }
                }
            } else {
                for (int i = 0; i < this.resolver.noBreak.length; ++i) {
                    this.resolver.noBreak[i].notifyLayoutManager(this.resolver.noBreakLengths[i]);
                }
            }
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("SpaceHandlingBreakPosition(");
            stringBuffer.append(this.originalPosition);
            stringBuffer.append(")");
            return stringBuffer.toString();
        }

        public Position getOriginalBreakPosition() {
            return this.originalPosition;
        }

        public Position getPosition() {
            return this.originalPosition;
        }
    }
}

