/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.accessibility.StructureTreeElement;
import org.apache.fop.area.Area;
import org.apache.fop.area.Trait;
import org.apache.fop.datatypes.PercentBaseContext;
import org.apache.fop.datatypes.SimplePercentBaseContext;
import org.apache.fop.fo.properties.CommonBorderPaddingBackground;
import org.apache.fop.fo.properties.CommonMarginBlock;
import org.apache.fop.fo.properties.CommonTextDecoration;
import org.apache.fop.fonts.Font;
import org.apache.fop.traits.BorderProps;
import org.apache.fop.traits.MinOptMax;

public final class TraitSetter {
    private static final Log LOG = LogFactory.getLog(TraitSetter.class);

    private TraitSetter() {
    }

    public static void setBorderPaddingTraits(Area area, CommonBorderPaddingBackground commonBorderPaddingBackground, boolean bl, boolean bl2, PercentBaseContext percentBaseContext) {
        int n = commonBorderPaddingBackground.getPadding(2, bl, percentBaseContext);
        if (n > 0) {
            area.addTrait(Trait.PADDING_START, n);
        }
        if ((n = commonBorderPaddingBackground.getPadding(3, bl2, percentBaseContext)) > 0) {
            area.addTrait(Trait.PADDING_END, n);
        }
        if ((n = commonBorderPaddingBackground.getPadding(0, false, percentBaseContext)) > 0) {
            area.addTrait(Trait.PADDING_BEFORE, n);
        }
        if ((n = commonBorderPaddingBackground.getPadding(1, false, percentBaseContext)) > 0) {
            area.addTrait(Trait.PADDING_AFTER, n);
        }
        TraitSetter.addBorderTrait(area, commonBorderPaddingBackground, bl, 2, 0, Trait.BORDER_START);
        TraitSetter.addBorderTrait(area, commonBorderPaddingBackground, bl2, 3, 0, Trait.BORDER_END);
        TraitSetter.addBorderTrait(area, commonBorderPaddingBackground, false, 0, 0, Trait.BORDER_BEFORE);
        TraitSetter.addBorderTrait(area, commonBorderPaddingBackground, false, 1, 0, Trait.BORDER_AFTER);
    }

    private static void addBorderTrait(Area area, CommonBorderPaddingBackground commonBorderPaddingBackground, boolean bl, int n, int n2, Integer n3) {
        int n4 = commonBorderPaddingBackground.getBorderWidth(n, bl);
        if (n4 > 0) {
            area.addTrait(n3, new BorderProps(commonBorderPaddingBackground.getBorderStyle(n), n4, commonBorderPaddingBackground.getBorderColor(n), n2));
        }
    }

    public static void addBorders(Area area, CommonBorderPaddingBackground commonBorderPaddingBackground, PercentBaseContext percentBaseContext) {
        BorderProps borderProps = TraitSetter.getBorderProps(commonBorderPaddingBackground, 0);
        if (borderProps != null) {
            area.addTrait(Trait.BORDER_BEFORE, borderProps);
        }
        if ((borderProps = TraitSetter.getBorderProps(commonBorderPaddingBackground, 1)) != null) {
            area.addTrait(Trait.BORDER_AFTER, borderProps);
        }
        if ((borderProps = TraitSetter.getBorderProps(commonBorderPaddingBackground, 2)) != null) {
            area.addTrait(Trait.BORDER_START, borderProps);
        }
        if ((borderProps = TraitSetter.getBorderProps(commonBorderPaddingBackground, 3)) != null) {
            area.addTrait(Trait.BORDER_END, borderProps);
        }
        TraitSetter.addPadding(area, commonBorderPaddingBackground, percentBaseContext);
    }

    public static void addBorders(Area area, CommonBorderPaddingBackground commonBorderPaddingBackground, boolean bl, boolean bl2, boolean bl3, boolean bl4, PercentBaseContext percentBaseContext) {
        BorderProps borderProps = TraitSetter.getBorderProps(commonBorderPaddingBackground, 0);
        if (borderProps != null && !bl) {
            area.addTrait(Trait.BORDER_BEFORE, borderProps);
        }
        if ((borderProps = TraitSetter.getBorderProps(commonBorderPaddingBackground, 1)) != null && !bl2) {
            area.addTrait(Trait.BORDER_AFTER, borderProps);
        }
        if ((borderProps = TraitSetter.getBorderProps(commonBorderPaddingBackground, 2)) != null && !bl3) {
            area.addTrait(Trait.BORDER_START, borderProps);
        }
        if ((borderProps = TraitSetter.getBorderProps(commonBorderPaddingBackground, 3)) != null && !bl4) {
            area.addTrait(Trait.BORDER_END, borderProps);
        }
    }

    public static void addCollapsingBorders(Area area, CommonBorderPaddingBackground.BorderInfo borderInfo, CommonBorderPaddingBackground.BorderInfo borderInfo2, CommonBorderPaddingBackground.BorderInfo borderInfo3, CommonBorderPaddingBackground.BorderInfo borderInfo4, boolean[] blArray) {
        BorderProps borderProps = TraitSetter.getCollapsingBorderProps(borderInfo, blArray[0]);
        if (borderProps != null) {
            area.addTrait(Trait.BORDER_BEFORE, borderProps);
        }
        if ((borderProps = TraitSetter.getCollapsingBorderProps(borderInfo2, blArray[1])) != null) {
            area.addTrait(Trait.BORDER_AFTER, borderProps);
        }
        if ((borderProps = TraitSetter.getCollapsingBorderProps(borderInfo3, blArray[2])) != null) {
            area.addTrait(Trait.BORDER_START, borderProps);
        }
        if ((borderProps = TraitSetter.getCollapsingBorderProps(borderInfo4, blArray[3])) != null) {
            area.addTrait(Trait.BORDER_END, borderProps);
        }
    }

    private static void addPadding(Area area, CommonBorderPaddingBackground commonBorderPaddingBackground, PercentBaseContext percentBaseContext) {
        TraitSetter.addPadding(area, commonBorderPaddingBackground, false, false, false, false, percentBaseContext);
    }

    public static void addPadding(Area area, CommonBorderPaddingBackground commonBorderPaddingBackground, boolean bl, boolean bl2, boolean bl3, boolean bl4, PercentBaseContext percentBaseContext) {
        int n = commonBorderPaddingBackground.getPadding(0, bl, percentBaseContext);
        if (n != 0) {
            area.addTrait(Trait.PADDING_BEFORE, n);
        }
        if ((n = commonBorderPaddingBackground.getPadding(1, bl2, percentBaseContext)) != 0) {
            area.addTrait(Trait.PADDING_AFTER, n);
        }
        if ((n = commonBorderPaddingBackground.getPadding(2, bl3, percentBaseContext)) != 0) {
            area.addTrait(Trait.PADDING_START, n);
        }
        if ((n = commonBorderPaddingBackground.getPadding(3, bl4, percentBaseContext)) != 0) {
            area.addTrait(Trait.PADDING_END, n);
        }
    }

    private static BorderProps getBorderProps(CommonBorderPaddingBackground commonBorderPaddingBackground, int n) {
        int n2 = commonBorderPaddingBackground.getBorderWidth(n, false);
        if (n2 != 0) {
            BorderProps borderProps = new BorderProps(commonBorderPaddingBackground.getBorderStyle(n), n2, commonBorderPaddingBackground.getBorderColor(n), 0);
            return borderProps;
        }
        return null;
    }

    private static BorderProps getCollapsingBorderProps(CommonBorderPaddingBackground.BorderInfo borderInfo, boolean bl) {
        assert (borderInfo != null);
        int n = borderInfo.getRetainedWidth();
        if (n != 0) {
            return new BorderProps(borderInfo.getStyle(), n, borderInfo.getColor(), bl ? 2 : 1);
        }
        return null;
    }

    public static void addBackground(Area area, CommonBorderPaddingBackground commonBorderPaddingBackground, PercentBaseContext percentBaseContext, int n, int n2, int n3, int n4) {
        if (!commonBorderPaddingBackground.hasBackground()) {
            return;
        }
        Trait.Background background = new Trait.Background();
        background.setColor(commonBorderPaddingBackground.backgroundColor);
        if (commonBorderPaddingBackground.getImageInfo() != null) {
            SimplePercentBaseContext simplePercentBaseContext;
            background.setURL(commonBorderPaddingBackground.backgroundImage);
            background.setImageInfo(commonBorderPaddingBackground.getImageInfo());
            background.setRepeat(commonBorderPaddingBackground.backgroundRepeat);
            if (commonBorderPaddingBackground.backgroundPositionHorizontal != null && (background.getRepeat() == 96 || background.getRepeat() == 114)) {
                if (area.getIPD() > 0) {
                    simplePercentBaseContext = new SimplePercentBaseContext(percentBaseContext, 9, n3 - background.getImageInfo().getSize().getWidthMpt());
                    background.setHoriz(n + commonBorderPaddingBackground.backgroundPositionHorizontal.getValue(simplePercentBaseContext));
                } else {
                    LOG.warn((Object)"Horizontal background image positioning ignored because the IPD was not set on the area. (Yes, it's a bug in FOP)");
                }
            }
            if (commonBorderPaddingBackground.backgroundPositionVertical != null && (background.getRepeat() == 96 || background.getRepeat() == 113)) {
                if (area.getBPD() > 0) {
                    simplePercentBaseContext = new SimplePercentBaseContext(percentBaseContext, 10, n4 - background.getImageInfo().getSize().getHeightMpt());
                    background.setVertical(n2 + commonBorderPaddingBackground.backgroundPositionVertical.getValue(simplePercentBaseContext));
                } else {
                    LOG.warn((Object)"Vertical background image positioning ignored because the BPD was not set on the area. (Yes, it's a bug in FOP)");
                }
            }
        }
        area.addTrait(Trait.BACKGROUND, background);
    }

    public static void addBackground(Area area, CommonBorderPaddingBackground commonBorderPaddingBackground, PercentBaseContext percentBaseContext) {
        if (!commonBorderPaddingBackground.hasBackground()) {
            return;
        }
        Trait.Background background = new Trait.Background();
        background.setColor(commonBorderPaddingBackground.backgroundColor);
        if (commonBorderPaddingBackground.getImageInfo() != null) {
            int n;
            SimplePercentBaseContext simplePercentBaseContext;
            int n2;
            int n3;
            int n4;
            background.setURL(commonBorderPaddingBackground.backgroundImage);
            background.setImageInfo(commonBorderPaddingBackground.getImageInfo());
            background.setRepeat(commonBorderPaddingBackground.backgroundRepeat);
            if (commonBorderPaddingBackground.backgroundPositionHorizontal != null && (background.getRepeat() == 96 || background.getRepeat() == 114)) {
                if (area.getIPD() > 0) {
                    n4 = area.getIPD();
                    n4 += commonBorderPaddingBackground.getPaddingStart(false, percentBaseContext);
                    n3 = background.getImageInfo().getSize().getWidthMpt();
                    n2 = (n4 += commonBorderPaddingBackground.getPaddingEnd(false, percentBaseContext)) - n3;
                    simplePercentBaseContext = new SimplePercentBaseContext(percentBaseContext, 9, n2);
                    n = commonBorderPaddingBackground.backgroundPositionHorizontal.getValue(simplePercentBaseContext);
                    background.setHoriz(n);
                } else {
                    LOG.warn((Object)"Horizontal background image positioning ignored because the IPD was not set on the area. (Yes, it's a bug in FOP)");
                }
            }
            if (commonBorderPaddingBackground.backgroundPositionVertical != null && (background.getRepeat() == 96 || background.getRepeat() == 113)) {
                if (area.getBPD() > 0) {
                    n4 = area.getBPD();
                    n4 += commonBorderPaddingBackground.getPaddingBefore(false, percentBaseContext);
                    n3 = background.getImageInfo().getSize().getHeightMpt();
                    n2 = (n4 += commonBorderPaddingBackground.getPaddingAfter(false, percentBaseContext)) - n3;
                    simplePercentBaseContext = new SimplePercentBaseContext(percentBaseContext, 10, n2);
                    n = commonBorderPaddingBackground.backgroundPositionVertical.getValue(simplePercentBaseContext);
                    background.setVertical(n);
                } else {
                    LOG.warn((Object)"Vertical background image positioning ignored because the BPD was not set on the area. (Yes, it's a bug in FOP)");
                }
            }
        }
        area.addTrait(Trait.BACKGROUND, background);
    }

    public static void addMargins(Area area, CommonBorderPaddingBackground commonBorderPaddingBackground, int n, int n2, PercentBaseContext percentBaseContext) {
        int n3;
        int n4;
        if (n != 0) {
            area.addTrait(Trait.START_INDENT, n);
        }
        if ((n4 = n - commonBorderPaddingBackground.getBorderStartWidth(false) - commonBorderPaddingBackground.getPaddingStart(false, percentBaseContext)) != 0) {
            area.addTrait(Trait.SPACE_START, n4);
        }
        if (n2 != 0) {
            area.addTrait(Trait.END_INDENT, n2);
        }
        if ((n3 = n2 - commonBorderPaddingBackground.getBorderEndWidth(false) - commonBorderPaddingBackground.getPaddingEnd(false, percentBaseContext)) != 0) {
            area.addTrait(Trait.SPACE_END, n3);
        }
    }

    public static void addMargins(Area area, CommonBorderPaddingBackground commonBorderPaddingBackground, CommonMarginBlock commonMarginBlock, PercentBaseContext percentBaseContext) {
        int n = commonMarginBlock.startIndent.getValue(percentBaseContext);
        int n2 = commonMarginBlock.endIndent.getValue(percentBaseContext);
        TraitSetter.addMargins(area, commonBorderPaddingBackground, n, n2, percentBaseContext);
    }

    public static int getEffectiveSpace(double d, MinOptMax minOptMax) {
        if (minOptMax == null) {
            return 0;
        }
        int n = minOptMax.getOpt();
        n = d > 0.0 ? (n += (int)(d * (double)minOptMax.getStretch())) : (n += (int)(d * (double)minOptMax.getShrink()));
        return n;
    }

    public static void addSpaceBeforeAfter(Area area, double d, MinOptMax minOptMax, MinOptMax minOptMax2) {
        TraitSetter.addSpaceTrait(area, Trait.SPACE_BEFORE, minOptMax, d);
        TraitSetter.addSpaceTrait(area, Trait.SPACE_AFTER, minOptMax2, d);
    }

    private static void addSpaceTrait(Area area, Integer n, MinOptMax minOptMax, double d) {
        int n2 = TraitSetter.getEffectiveSpace(d, minOptMax);
        if (n2 != 0) {
            area.addTrait(n, n2);
        }
    }

    public static void addBreaks(Area area, int n, int n2) {
    }

    public static void addFontTraits(Area area, Font font) {
        area.addTrait(Trait.FONT, font.getFontTriplet());
        area.addTrait(Trait.FONT_SIZE, font.getFontSize());
    }

    public static void addTextDecoration(Area area, CommonTextDecoration commonTextDecoration) {
        if (commonTextDecoration != null) {
            if (commonTextDecoration.hasUnderline()) {
                area.addTrait(Trait.UNDERLINE, Boolean.TRUE);
                area.addTrait(Trait.UNDERLINE_COLOR, commonTextDecoration.getUnderlineColor());
            }
            if (commonTextDecoration.hasOverline()) {
                area.addTrait(Trait.OVERLINE, Boolean.TRUE);
                area.addTrait(Trait.OVERLINE_COLOR, commonTextDecoration.getOverlineColor());
            }
            if (commonTextDecoration.hasLineThrough()) {
                area.addTrait(Trait.LINETHROUGH, Boolean.TRUE);
                area.addTrait(Trait.LINETHROUGH_COLOR, commonTextDecoration.getLineThroughColor());
            }
            if (commonTextDecoration.isBlinking()) {
                area.addTrait(Trait.BLINK, Boolean.TRUE);
            }
        }
    }

    public static void addStructureTreeElement(Area area, StructureTreeElement structureTreeElement) {
        if (structureTreeElement != null) {
            area.addTrait(Trait.STRUCTURE_TREE_ELEMENT, structureTreeElement);
        }
    }

    public static void setProducerID(Area area, String string) {
        if (string != null && string.length() > 0) {
            area.addTrait(Trait.PROD_ID, string);
        }
    }
}

