/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr.inline;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.List;
import org.apache.fop.area.Area;
import org.apache.fop.area.inline.InlineViewport;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.flow.AbstractGraphics;
import org.apache.fop.fo.properties.CommonBorderPaddingBackground;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.TraitSetter;
import org.apache.fop.layoutmgr.inline.AlignmentContext;
import org.apache.fop.layoutmgr.inline.ImageLayout;
import org.apache.fop.layoutmgr.inline.LeafNodeLayoutManager;

public abstract class AbstractGraphicsLayoutManager
extends LeafNodeLayoutManager {
    public AbstractGraphicsLayoutManager(AbstractGraphics abstractGraphics) {
        super(abstractGraphics);
    }

    private InlineViewport getInlineArea() {
        int n;
        AbstractGraphics abstractGraphics = (AbstractGraphics)this.fobj;
        Dimension dimension = new Dimension(abstractGraphics.getIntrinsicWidth(), abstractGraphics.getIntrinsicHeight());
        int n2 = abstractGraphics.getBidiLevel();
        ImageLayout imageLayout = new ImageLayout(abstractGraphics, this, dimension);
        Rectangle rectangle = imageLayout.getPlacement();
        CommonBorderPaddingBackground commonBorderPaddingBackground = abstractGraphics.getCommonBorderPaddingBackground();
        this.setCommonBorderPaddingBackground(commonBorderPaddingBackground);
        int n3 = commonBorderPaddingBackground.getPadding(0, false, this);
        rectangle.y += (n3 += commonBorderPaddingBackground.getBorderWidth(0, false));
        if (n2 == -1 || (n2 & 1) == 0) {
            n = commonBorderPaddingBackground.getPadding(2, false, this);
            rectangle.x += (n += commonBorderPaddingBackground.getBorderWidth(2, false));
        } else {
            n = commonBorderPaddingBackground.getPadding(3, false, this);
            rectangle.x += (n += commonBorderPaddingBackground.getBorderWidth(3, false));
        }
        Area area = this.getChildArea();
        TraitSetter.setProducerID(area, abstractGraphics.getId());
        this.transferForeignAttributes(area);
        InlineViewport inlineViewport = new InlineViewport(area, n2);
        TraitSetter.addStructureTreeElement(inlineViewport, abstractGraphics.getStructureTreeElement());
        TraitSetter.setProducerID(inlineViewport, abstractGraphics.getId());
        inlineViewport.setIPD(imageLayout.getViewportSize().width);
        inlineViewport.setBPD(imageLayout.getViewportSize().height);
        inlineViewport.setContentPosition(rectangle);
        inlineViewport.setClip(imageLayout.isClipped());
        inlineViewport.setBlockProgressionOffset(0);
        TraitSetter.addBorders(inlineViewport, commonBorderPaddingBackground, false, false, false, false, this);
        TraitSetter.addPadding(inlineViewport, commonBorderPaddingBackground, false, false, false, false, this);
        TraitSetter.addBackground(inlineViewport, commonBorderPaddingBackground, this);
        return inlineViewport;
    }

    public List getNextKnuthElements(LayoutContext layoutContext, int n) {
        InlineViewport inlineViewport = this.getInlineArea();
        this.setCurrentArea(inlineViewport);
        return super.getNextKnuthElements(layoutContext, n);
    }

    protected AlignmentContext makeAlignmentContext(LayoutContext layoutContext) {
        AbstractGraphics abstractGraphics = (AbstractGraphics)this.fobj;
        return new AlignmentContext(this.get(layoutContext).getAllocBPD(), abstractGraphics.getAlignmentAdjust(), abstractGraphics.getAlignmentBaseline(), abstractGraphics.getBaselineShift(), abstractGraphics.getDominantBaseline(), layoutContext.getAlignmentContext());
    }

    protected abstract Area getChildArea();

    public int getBaseLength(int n, FObj fObj) {
        switch (n) {
            case 7: {
                return ((AbstractGraphics)fObj).getIntrinsicWidth();
            }
            case 8: {
                return ((AbstractGraphics)fObj).getIntrinsicHeight();
            }
            case 12: {
                return this.get(null).getBPD();
            }
        }
        return super.getBaseLength(n, fObj);
    }
}

