/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr.inline;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.area.Area;
import org.apache.fop.area.Block;
import org.apache.fop.area.LineArea;
import org.apache.fop.area.inline.InlineArea;
import org.apache.fop.fo.pagination.Title;
import org.apache.fop.layoutmgr.AbstractBaseLayoutManager;
import org.apache.fop.layoutmgr.KnuthElement;
import org.apache.fop.layoutmgr.KnuthPossPosIter;
import org.apache.fop.layoutmgr.KnuthSequence;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.LayoutManager;
import org.apache.fop.layoutmgr.PageSequenceLayoutManager;
import org.apache.fop.layoutmgr.Position;
import org.apache.fop.layoutmgr.PositionIterator;
import org.apache.fop.layoutmgr.SpaceSpecifier;
import org.apache.fop.layoutmgr.inline.HyphContext;
import org.apache.fop.layoutmgr.inline.InlineLevelLayoutManager;
import org.apache.fop.layoutmgr.inline.KnuthInlineBox;

public class ContentLayoutManager
extends AbstractBaseLayoutManager
implements InlineLevelLayoutManager {
    private static Log log = LogFactory.getLog(ContentLayoutManager.class);
    private Area holder;
    private int stackSize;
    private LayoutManager parentLM;
    private InlineLevelLayoutManager childLM = null;

    public ContentLayoutManager(Area area, LayoutManager layoutManager) {
        this.holder = area;
        this.parentLM = layoutManager;
    }

    public ContentLayoutManager(PageSequenceLayoutManager pageSequenceLayoutManager, Title title) {
        this.parentLM = pageSequenceLayoutManager;
        this.holder = new LineArea();
        try {
            LayoutManager layoutManager = pageSequenceLayoutManager.getLayoutManagerMaker().makeLayoutManager(title);
            this.addChildLM(layoutManager);
            this.fillArea(layoutManager);
        }
        catch (IllegalStateException illegalStateException) {
            log.warn((Object)"Title has no content");
            throw illegalStateException;
        }
    }

    public void initialize() {
    }

    private void fillArea(LayoutManager layoutManager) {
        Object object;
        Object object2;
        int n;
        int n2 = 1000000;
        LayoutContext layoutContext = new LayoutContext(2);
        layoutContext.setLeadingSpace(new SpaceSpecifier(false));
        layoutContext.setTrailingSpace(new SpaceSpecifier(false));
        layoutContext.setRefIPD(n2);
        int n3 = 14000;
        int n4 = 12000;
        int n5 = 2000;
        int n6 = (n3 - n4 - n5) / 2;
        int n7 = n4 + n6;
        int n8 = n = n5 + n6;
        this.stackSize = 0;
        List list = this.getNextKnuthElements(layoutContext, 135);
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            object2 = (KnuthElement)listIterator.next();
            if (!(object2 instanceof KnuthInlineBox)) continue;
            object = (KnuthInlineBox)object2;
        }
        if (n - n7 > n8) {
            n8 = n - n7;
        }
        object2 = new LayoutContext(0);
        ((LayoutContext)object2).setFlags(256, true);
        ((LayoutContext)object2).setLeadingSpace(new SpaceSpecifier(false));
        ((LayoutContext)object2).setTrailingSpace(new SpaceSpecifier(false));
        object = new KnuthPossPosIter(list, 0, list.size());
        layoutManager.addAreas((PositionIterator)object, (LayoutContext)object2);
    }

    public void addAreas(PositionIterator positionIterator, LayoutContext layoutContext) {
        int n = ((InlineArea)this.holder).getIPD();
        LayoutContext layoutContext2 = new LayoutContext(layoutContext);
        layoutContext2.setIPDAdjust(0.0);
        this.childLM.addAreas(positionIterator, layoutContext2);
        ((InlineArea)this.holder).setIPD(n);
    }

    public int getStackingSize() {
        return this.stackSize;
    }

    public Area getParentArea(Area area) {
        return this.holder;
    }

    public void addChildArea(Area area) {
        this.holder.addChildArea(area);
    }

    public void setParent(LayoutManager layoutManager) {
        this.parentLM = layoutManager;
    }

    public LayoutManager getParent() {
        return this.parentLM;
    }

    public boolean isFinished() {
        return false;
    }

    public void setFinished(boolean bl) {
    }

    public boolean createNextChildLMs(int n) {
        return false;
    }

    public List getChildLMs() {
        ArrayList<InlineLevelLayoutManager> arrayList = new ArrayList<InlineLevelLayoutManager>(1);
        arrayList.add(this.childLM);
        return arrayList;
    }

    public void addChildLM(LayoutManager layoutManager) {
        if (layoutManager == null) {
            return;
        }
        layoutManager.setParent(this);
        this.childLM = (InlineLevelLayoutManager)layoutManager;
        log.trace((Object)(this.getClass().getName() + ": Adding child LM " + layoutManager.getClass().getName()));
    }

    public void addChildLMs(List list) {
        if (list == null || list.size() == 0) {
            return;
        }
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            LayoutManager layoutManager = (LayoutManager)listIterator.next();
            this.addChildLM(layoutManager);
        }
    }

    public List getNextKnuthElements(LayoutContext layoutContext, int n) {
        LinkedList<KnuthElement> linkedList = new LinkedList<KnuthElement>();
        this.childLM.initialize();
        while (!this.childLM.isFinished()) {
            List list = this.childLM.getNextKnuthElements(layoutContext, n);
            if (list == null) continue;
            while (list.size() > 0) {
                KnuthElement knuthElement2;
                Object e = list.remove(0);
                if (e instanceof KnuthSequence) {
                    KnuthSequence knuthSequence = (KnuthSequence)e;
                    for (KnuthElement knuthElement2 : knuthSequence) {
                        this.stackSize += knuthElement2.getWidth();
                        linkedList.add(knuthElement2);
                    }
                    continue;
                }
                knuthElement2 = (KnuthElement)e;
                this.stackSize += knuthElement2.getWidth();
                linkedList.add(knuthElement2);
            }
        }
        this.setFinished(true);
        return linkedList;
    }

    public List addALetterSpaceTo(List list) {
        return list;
    }

    public List addALetterSpaceTo(List list, int n) {
        return this.addALetterSpaceTo(list);
    }

    public String getWordChars(Position position) {
        return "";
    }

    public void hyphenate(Position position, HyphContext hyphContext) {
    }

    public boolean applyChanges(List list) {
        return false;
    }

    public boolean applyChanges(List list, int n) {
        return this.applyChanges(list);
    }

    public List getChangedKnuthElements(List list, int n) {
        return null;
    }

    public List getChangedKnuthElements(List list, int n, int n2) {
        return this.getChangedKnuthElements(list, n);
    }

    public PageSequenceLayoutManager getPSLM() {
        return this.parentLM.getPSLM();
    }

    public int getContentAreaIPD() {
        return this.holder.getIPD();
    }

    public int getContentAreaBPD() {
        return this.holder.getBPD();
    }

    public boolean getGeneratesReferenceArea() {
        return false;
    }

    public boolean getGeneratesBlockArea() {
        return this.getGeneratesLineArea() || this.holder instanceof Block;
    }

    public boolean getGeneratesLineArea() {
        return this.holder instanceof LineArea;
    }

    public Position notifyPos(Position position) {
        return position;
    }
}

