/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr.inline;

import java.awt.Dimension;
import java.awt.Rectangle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.datatypes.Length;
import org.apache.fop.datatypes.PercentBaseContext;
import org.apache.fop.fo.Constants;
import org.apache.fop.fo.GraphicsProperties;
import org.apache.fop.fo.properties.LengthRangeProperty;

public class ImageLayout
implements Constants {
    protected static final Log log = LogFactory.getLog(ImageLayout.class);
    private GraphicsProperties props;
    private PercentBaseContext percentBaseContext;
    private Dimension intrinsicSize;
    private Rectangle placement;
    private Dimension viewportSize = new Dimension(-1, -1);
    private boolean clip;

    public ImageLayout(GraphicsProperties graphicsProperties, PercentBaseContext percentBaseContext, Dimension dimension) {
        this.props = graphicsProperties;
        this.percentBaseContext = percentBaseContext;
        this.intrinsicSize = dimension;
        this.doLayout();
    }

    protected void doLayout() {
        int n = -1;
        int n2 = -1;
        Length length = this.props.getBlockProgressionDimension().getOptimum(this.percentBaseContext).getLength();
        if (length.getEnum() != 9) {
            n = length.getValue(this.percentBaseContext);
        }
        length = this.props.getBlockProgressionDimension().getMinimum(this.percentBaseContext).getLength();
        if (n == -1 && length.getEnum() != 9) {
            n = length.getValue(this.percentBaseContext);
        }
        if ((length = this.props.getInlineProgressionDimension().getOptimum(this.percentBaseContext).getLength()).getEnum() != 9) {
            n2 = length.getValue(this.percentBaseContext);
        }
        length = this.props.getInlineProgressionDimension().getMinimum(this.percentBaseContext).getLength();
        if (n2 == -1 && length.getEnum() != 9) {
            n2 = length.getValue(this.percentBaseContext);
        }
        boolean bl = false;
        int n3 = -1;
        int n4 = -1;
        length = this.props.getContentWidth();
        if (length.getEnum() != 9) {
            switch (length.getEnum()) {
                case 125: {
                    if (n2 != -1) {
                        n3 = n2;
                    }
                    bl = true;
                    break;
                }
                case 187: {
                    if (n2 != -1 && this.intrinsicSize.width > n2) {
                        n3 = n2;
                    }
                    bl = true;
                    break;
                }
                case 188: {
                    if (n2 != -1 && this.intrinsicSize.width < n2) {
                        n3 = n2;
                    }
                    bl = true;
                    break;
                }
                default: {
                    n3 = length.getValue(this.percentBaseContext);
                }
            }
        }
        if ((length = this.props.getContentHeight()).getEnum() != 9) {
            switch (length.getEnum()) {
                case 125: {
                    if (n != -1) {
                        n4 = n;
                    }
                    bl = true;
                    break;
                }
                case 187: {
                    if (n != -1 && this.intrinsicSize.height > n) {
                        n4 = n;
                    }
                    bl = true;
                    break;
                }
                case 188: {
                    if (n != -1 && this.intrinsicSize.height < n) {
                        n4 = n;
                    }
                    bl = true;
                    break;
                }
                default: {
                    n4 = length.getValue(this.percentBaseContext);
                }
            }
        }
        Dimension dimension = bl ? this.constrain(this.intrinsicSize) : this.intrinsicSize;
        Dimension dimension2 = this.adjustContentSize(n3, n4, dimension);
        n3 = dimension2.width;
        n4 = dimension2.height;
        if (n2 == -1) {
            n2 = this.constrainExtent(n3, this.props.getInlineProgressionDimension(), this.props.getContentWidth());
        }
        if (n == -1) {
            n = this.constrainExtent(n4, this.props.getBlockProgressionDimension(), this.props.getContentHeight());
        }
        this.clip = false;
        int n5 = this.props.getOverflow();
        if (n5 == 57) {
            this.clip = true;
        } else if (n5 == 42) {
            if (n3 > n2 || n4 > n) {
                log.error((Object)"Object overflows the viewport: clipping");
            }
            this.clip = true;
        }
        int n6 = this.computeXOffset(n2, n3);
        int n7 = this.computeYOffset(n, n4);
        this.viewportSize.setSize(n2, n);
        this.placement = new Rectangle(n6, n7, n3, n4);
    }

    private int constrainExtent(int n, LengthRangeProperty lengthRangeProperty, Length length) {
        int n2;
        boolean bl = length.getEnum() != 187;
        boolean bl2 = length.getEnum() != 188;
        Length length2 = lengthRangeProperty.getMaximum(this.percentBaseContext).getLength();
        if (length2.getEnum() != 9 && (n2 = length2.getValue(this.percentBaseContext)) != -1 && bl2) {
            n = Math.min(n, n2);
        }
        if ((length2 = lengthRangeProperty.getMinimum(this.percentBaseContext).getLength()).getEnum() != 9 && (n2 = length2.getValue(this.percentBaseContext)) != -1 && bl) {
            n = Math.max(n, n2);
        }
        return n;
    }

    private Dimension constrain(Dimension dimension) {
        Dimension dimension2 = new Dimension(dimension);
        int n = this.constrainExtent(dimension.width, this.props.getInlineProgressionDimension(), this.props.getContentWidth());
        int n2 = this.constrainExtent(dimension.height, this.props.getBlockProgressionDimension(), this.props.getContentHeight());
        int n3 = this.props.getScaling();
        if (n3 == 154) {
            double d = (double)n / (double)dimension.width;
            double d2 = (double)n2 / (double)dimension.height;
            if (d < d2) {
                dimension2.width = n;
                dimension2.height = (int)(d * (double)dimension.height);
            } else if (d > d2) {
                dimension2.width = (int)(d2 * (double)dimension.width);
                dimension2.height = n2;
            } else {
                dimension2.width = n;
                dimension2.height = n2;
            }
        } else {
            dimension2.width = n;
            dimension2.height = n2;
        }
        return dimension2;
    }

    private Dimension adjustContentSize(int n, int n2, Dimension dimension) {
        Dimension dimension2 = new Dimension(n, n2);
        int n3 = this.props.getScaling();
        if (n3 == 154 || n == -1 || n2 == -1) {
            if (n == -1 && n2 == -1) {
                dimension2.width = dimension.width;
                dimension2.height = dimension.height;
            } else if (n == -1) {
                dimension2.width = dimension.height == 0 ? 0 : (int)((double)dimension.width * (double)n2 / (double)dimension.height);
            } else if (n2 == -1) {
                dimension2.height = dimension.width == 0 ? 0 : (int)((double)dimension.height * (double)n / (double)dimension.width);
            } else if (dimension.width == 0 || dimension.height == 0) {
                dimension2.width = 0;
                dimension2.height = 0;
            } else {
                double d = (double)n / (double)dimension.width;
                double d2 = (double)n2 / (double)dimension.height;
                if (d < d2) {
                    dimension2.height = (int)(d * (double)dimension.height);
                } else if (d > d2) {
                    dimension2.width = (int)(d2 * (double)dimension.width);
                }
            }
        }
        return dimension2;
    }

    public int computeXOffset(int n, int n2) {
        int n3 = 0;
        switch (this.props.getTextAlign()) {
            case 23: {
                n3 = (n - n2) / 2;
                break;
            }
            case 39: {
                n3 = n - n2;
                break;
            }
            case 135: {
                break;
            }
        }
        return n3;
    }

    public int computeYOffset(int n, int n2) {
        int n3 = 0;
        switch (this.props.getDisplayAlign()) {
            case 13: {
                break;
            }
            case 3: {
                n3 = n - n2;
                break;
            }
            case 23: {
                n3 = (n - n2) / 2;
                break;
            }
        }
        return n3;
    }

    public Rectangle getPlacement() {
        return this.placement;
    }

    public Dimension getViewportSize() {
        return this.viewportSize;
    }

    public Dimension getIntrinsicSize() {
        return this.intrinsicSize;
    }

    public boolean isClipped() {
        return this.clip;
    }
}

