/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr.inline;

import org.apache.fop.area.PageViewport;
import org.apache.fop.area.inline.InlineArea;
import org.apache.fop.area.inline.TextArea;
import org.apache.fop.area.inline.UnresolvedPageNumber;
import org.apache.fop.fo.flow.PageNumberCitation;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.inline.AbstractPageNumberCitationLayoutManager;

public class PageNumberCitationLayoutManager
extends AbstractPageNumberCitationLayoutManager {
    public PageNumberCitationLayoutManager(PageNumberCitation pageNumberCitation) {
        super(pageNumberCitation);
    }

    public InlineArea get(LayoutContext layoutContext) {
        this.curArea = this.getPageNumberCitationInlineArea();
        return this.curArea;
    }

    private InlineArea getPageNumberCitationInlineArea() {
        PageViewport pageViewport = this.getPSLM().getFirstPVWithID(this.fobj.getRefId());
        TextArea textArea = null;
        int n = this.getBidiLevel();
        if (pageViewport != null) {
            String string = pageViewport.getPageNumberString();
            textArea = new TextArea();
            int n2 = this.getStringWidth(string);
            textArea.setBidiLevel(n);
            textArea.addWord(string, 0, n);
            textArea.setIPD(n2);
            this.resolved = true;
        } else {
            textArea = new UnresolvedPageNumber(this.fobj.getRefId(), this.font);
            String string = "MMM";
            int n3 = this.getStringWidth(string);
            textArea.setBidiLevel(n);
            textArea.setIPD(n3);
            this.resolved = false;
        }
        this.updateTextAreaTraits(textArea);
        return textArea;
    }
}

